/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.congruences;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.combinators.ZenoFunctor;
import bindead.domainnetwork.interfaces.Summarization;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.Substitution;
import bindead.domains.congruences.CongruenceState;
import bindead.domains.congruences.CongruenceStateBuilder;
import bindead.domains.congruences.ScalingVisitor;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Congruence;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.MultiMap;
import javalx.persistentcollections.ThreeWaySplit;
import rreil.lang.util.Type;

public class Congruences<D extends ZenoDomain<D>>
extends ZenoFunctor<CongruenceState, D, Congruences<D>> {
    public static final String NAME = "CONGRUENCES";

    public Congruences(D child) {
        super(NAME, CongruenceState.EMPTY, child);
    }

    private Congruences(CongruenceState state, D childState) {
        super(NAME, state, childState);
    }

    @Override
    public Congruences<D> introduce(NumVar variable, Type type, Option<BigInt> value) {
        Congruence c;
        CongruenceStateBuilder builder = new CongruenceStateBuilder((CongruenceState)this.state);
        Option<BigInt> childValue = Option.none();
        if (value.isSome()) {
            c = new Congruence(Bound.ZERO, value.get());
            childValue = Option.some(value.get());
        } else {
            c = Congruence.ONE;
        }
        builder.state = builder.state.bind((Object)variable, (Object)c);
        Object newChildState = ((ZenoDomain)this.childState).introduce(variable, type, childValue);
        newChildState = builder.applyChildOps(newChildState);
        return new Congruences(builder.build(), newChildState);
    }

    @Override
    public Congruences<D> project(VarSet vars) {
        CongruenceStateBuilder builder = new CongruenceStateBuilder((CongruenceState)this.state);
        for (NumVar variable : vars) {
            builder.remove(variable);
        }
        Object newChildState = ((ZenoDomain)this.childState).project(vars);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public Congruences<D> build(CongruenceState state, D childState) {
        return new Congruences<D>(state, childState);
    }

    @Override
    public Congruences<D> join(Congruences<D> other) {
        CongruenceStateBuilder thisBuilder = new CongruenceStateBuilder((CongruenceState)this.state);
        CongruenceStateBuilder otherBuilder = new CongruenceStateBuilder((CongruenceState)other.state);
        thisBuilder.makeCompatible(otherBuilder);
        ThreeWaySplit<AVLMap<NumVar, Congruence>> split = Congruences.split(thisBuilder.state, otherBuilder.state);
        AVLMap<NumVar, Congruence> current = otherBuilder.state.intersection(Congruence.join, split.inBothButDiffering());
        thisBuilder.state = current.union(Congruence.join, thisBuilder.state);
        ZenoDomain thisChildState = thisBuilder.applyChildOps((ZenoDomain)this.childState);
        ZenoDomain otherChildState = otherBuilder.applyChildOps((ZenoDomain)other.childState);
        CongruenceState compatibleState = thisBuilder.build();
        ZenoDomain newChildState = thisChildState.join(otherChildState);
        return this.build(compatibleState, (D)newChildState);
    }

    private static ThreeWaySplit<AVLMap<NumVar, Congruence>> split(AVLMap<NumVar, Congruence> state, AVLMap<NumVar, Congruence> other) {
        ThreeWaySplit<AVLMap<NumVar, Congruence>> split = state.split(other);
        if (!split.onlyInFirst().isEmpty()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        if (!split.onlyInSecond().isEmpty()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        return split;
    }

    @Override
    public Congruences<D> widen(Congruences<D> other) {
        CongruenceStateBuilder thisBuilder = new CongruenceStateBuilder((CongruenceState)this.state);
        CongruenceStateBuilder otherBuilder = new CongruenceStateBuilder((CongruenceState)other.state);
        thisBuilder.makeCompatible(otherBuilder);
        ThreeWaySplit<AVLMap<NumVar, Congruence>> split = Congruences.split(thisBuilder.state, ((CongruenceState)other.state).congruences);
        AVLMap<NumVar, Congruence> current = otherBuilder.state.intersection(Congruence.join, split.inBothButDiffering());
        thisBuilder.state = current.union(Congruence.join, thisBuilder.state);
        ZenoDomain thisChildState = thisBuilder.applyChildOps((ZenoDomain)this.childState);
        ZenoDomain otherChildState = otherBuilder.applyChildOps((ZenoDomain)other.childState);
        ZenoDomain newChildState = thisChildState.widen(otherChildState);
        return this.build(thisBuilder.build(), (D)newChildState);
    }

    @Override
    public boolean subsetOrEqual(Congruences<D> other) {
        ThreeWaySplit<AVLMap<NumVar, Congruence>> split = Congruences.split(((CongruenceState)this.state).congruences, ((CongruenceState)other.state).congruences);
        for (P2<NumVar, Congruence> p2 : split.inBothButDiffering()) {
            if (p2._2().subsetOrEqual(((CongruenceState)other.state).congruences.get(p2._1()).get())) continue;
            return false;
        }
        CongruenceStateBuilder thisBuilder = new CongruenceStateBuilder((CongruenceState)this.state);
        CongruenceStateBuilder congruenceStateBuilder = new CongruenceStateBuilder((CongruenceState)other.state);
        thisBuilder.makeCompatible(congruenceStateBuilder);
        ZenoDomain thisChildState = thisBuilder.applyChildOps((ZenoDomain)this.childState);
        ZenoDomain otherChildState = congruenceStateBuilder.applyChildOps((ZenoDomain)other.childState);
        return thisChildState.subsetOrEqual(otherChildState);
    }

    @Override
    public Congruences<D> eval(Zeno.Assign stmt) {
        CongruenceStateBuilder builder = new CongruenceStateBuilder((CongruenceState)this.state);
        ScalingVisitor.run(stmt, builder);
        ZenoDomain newChildState = builder.applyChildOps((ZenoDomain)this.childState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Congruences<D> eval(Zeno.Test test) throws Unreachable {
        CongruenceStateBuilder builder = new CongruenceStateBuilder((CongruenceState)this.state);
        ScalingVisitor.run(test, builder);
        ZenoDomain newChildState = builder.applyChildOps((ZenoDomain)this.childState);
        builder.reduceFromNewEqualities(newChildState.getSynthChannel().getEquations());
        newChildState = builder.applyChildOps(newChildState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Congruences<D> substitute(NumVar x, NumVar y) {
        CongruenceStateBuilder builder = new CongruenceStateBuilder((CongruenceState)this.state);
        builder.substituteInCongruences(x, y);
        Object newChildState = ((ZenoDomain)this.childState).substitute(x, y);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public Congruences<D> expand(FoldMap vars) {
        CongruenceStateBuilder builder = new CongruenceStateBuilder((CongruenceState)this.state);
        builder.expand(vars);
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).expand(vars);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Congruences<D> fold(FoldMap vars) {
        CongruenceStateBuilder builder = new CongruenceStateBuilder((CongruenceState)this.state);
        builder.fold(vars);
        ZenoDomain newChildState = builder.applyChildOps((ZenoDomain)this.childState);
        newChildState = (ZenoDomain)newChildState.fold(vars);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Congruences<D> copyAndPaste(VarSet vars, Congruences<D> from) {
        CongruenceStateBuilder builder = new CongruenceStateBuilder((CongruenceState)this.state);
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).copyAndPaste(vars, (Summarization)((Object)from.childState));
        builder.copyAndPaste(vars, (CongruenceState)from.state);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Range queryRange(Linear expr) {
        Congruence congruence = Congruences.evaluateCongruences(expr, ((CongruenceState)this.state).congruences);
        Linear inlinedExpr = ((CongruenceState)this.state).inlineIntoLinear(expr, null);
        if (inlinedExpr.isConstantOnly()) {
            return Range.from(inlinedExpr.getConstant()).ensureCongruent(congruence);
        }
        return ((ZenoDomain)this.childState).queryRange(inlinedExpr).ensureCongruent(congruence);
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel oldChannel = super.getSynthChannel();
        SynthChannel newChannel = oldChannel.clone();
        SetOfEquations newEquations = SetOfEquations.empty();
        for (Linear equation : oldChannel.getEquations()) {
            newEquations = newEquations.add(this.scaleLinear(equation));
        }
        newChannel.setEquations(newEquations);
        MultiMap<Zeno.Test, Zeno.Test> newImplications = MultiMap.empty();
        ZenoFactory factory = ZenoFactory.getInstance();
        for (P2<Zeno.Test, Zeno.Test> p2 : oldChannel.getImplications()) {
            Zeno.Test lhs = p2._1();
            Zeno.Test newLhs = factory.comparison(this.scaleLinear(lhs.getExpr()), lhs.getOperator());
            Zeno.Test rhs = p2._2();
            Zeno.Test newRhs = factory.comparison(this.scaleLinear(rhs.getExpr()), rhs.getOperator());
            newImplications = newImplications.add(newLhs, newRhs);
        }
        newChannel.setImplications(newImplications);
        return newChannel;
    }

    private Linear scaleLinear(Linear equation) {
        Linear newEquation = equation;
        for (NumVar var : equation.getVars()) {
            if (!((CongruenceState)this.state).congruences.contains(var)) continue;
            Congruence congruence = ((CongruenceState)this.state).congruences.get(var).get();
            BigInt scale = congruence.getScale();
            BigInt offset = congruence.getOffset();
            if (scale.isZero()) {
                Range childValue = ((ZenoDomain)this.childState).queryRange(var);
                assert (childValue.sub(offset).isZero()) : "The child domain has a different constant value for variable: " + var + "=" + childValue + " than the Congruences domain: " + offset;
                continue;
            }
            if (scale.isOne() && offset.isZero()) continue;
            Substitution substitution = new Substitution(var, Linear.linear(offset.negate(), Linear.term(var)), scale);
            newEquation = newEquation.applySubstitution(substitution);
        }
        return newEquation;
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        ((CongruenceState)this.state).appendVar(var, builder, (PrettyDomain)((Object)this.childState));
    }

    public static Congruence evaluateCongruences(Linear linear, AVLMap<NumVar, Congruence> congruences) {
        Congruence res = new Congruence(Bound.ZERO, Bound.ZERO);
        for (Linear.Term term : linear) {
            Congruence value = congruences.get(term.getId()).getOrElse(Congruence.ONE).mul(term.getCoeff());
            res = res.add(value);
        }
        res = res.add(new Congruence(Bound.ZERO, linear.getConstant()));
        return res;
    }
}

