/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.apron;

import java.util.Arrays;
import javalx.numeric.Bound;

class OctagonsMatrix {
    final int dim;
    final Bound[][] contents;

    public OctagonsMatrix(int d) {
        this.dim = d;
        int size = d * 2 + 1;
        this.contents = new Bound[size][];
        for (int i = 0; i < size; ++i) {
            this.contents[i] = new Bound[size];
            for (int j = 0; j < size; ++j) {
                this.contents[i][j] = Bound.NEGINF;
            }
        }
    }

    void setLim(int idx1, int idx2, Bound ofs) {
        this.contents[idx1][idx2] = ofs;
        this.contents[idx2][idx1] = ofs;
    }

    int posIdx(int x) {
        return this.dim + x + 1;
    }

    int negIdx(int x) {
        return this.dim - x - 1;
    }

    Bound pnBound(int x, int y) {
        return this.contents[this.posIdx(x)][this.negIdx(y)];
    }

    Bound npBound(int x, int y) {
        return this.pnBound(y, x);
    }

    Bound nnBound(int i, int j) {
        return this.contents[this.negIdx(i)][this.negIdx(j)];
    }

    Bound ppBound(int i, int j) {
        return this.contents[this.posIdx(i)][this.posIdx(j)];
    }

    int indexOfZero() {
        return this.dim;
    }

    void removeVarFromEquations(int var) {
        for (int x = 0; x < this.contents.length; ++x) {
            this.contents[this.posIdx((int)var)][x] = Bound.NEGINF;
            this.contents[this.negIdx((int)var)][x] = Bound.NEGINF;
            this.contents[x][this.posIdx((int)var)] = Bound.NEGINF;
            this.contents[x][this.negIdx((int)var)] = Bound.NEGINF;
        }
    }

    boolean isConstant(int i) {
        Bound pn = this.pnBound(i, -1);
        Bound nn = this.nnBound(i, -1);
        boolean s = pn.equals(nn.negate());
        return s;
    }

    boolean isZeroVar(int i) {
        return i == this.dim;
    }

    public String toString() {
        String s = "";
        for (Object[] objectArray : this.contents) {
            s = s + Arrays.toString(objectArray) + "\n";
        }
        s = s + "\n";
        return s;
    }
}

