/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.affine;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.abstractsyntax.zeno.util.ZenoExprSimplifier;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.combinators.ZenoFunctor;
import bindead.domainnetwork.interfaces.Summarization;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.AffineProperties;
import bindead.domains.affine.AffineState;
import bindead.domains.affine.AffineStateBuilder;
import bindead.domains.affine.InliningVisitor;
import bindead.domains.affine.UnreducedChildInfo;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import java.util.LinkedList;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Range;
import rreil.lang.util.Type;

public class RedundantAffine<D extends ZenoDomain<D>>
extends ZenoFunctor<AffineState, D, RedundantAffine<D>> {
    public static final String NAME = "REDUNDANTAFFINE";
    private static final ZenoFactory zeno = ZenoFactory.getInstance();
    private final boolean DEBUGOTHER;
    private final boolean DEBUGASSIGN;
    private final boolean DEBUGBINARIES;
    private final boolean DEBUGTESTS;
    private final boolean DEBUGSUBSETOREQUAL;

    public RedundantAffine(D child) {
        super(NAME, AffineState.EMPTY, child);
        this.DEBUGOTHER = AffineProperties.INSTANCE.debugOther.isTrue();
        this.DEBUGASSIGN = AffineProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGBINARIES = AffineProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGTESTS = AffineProperties.INSTANCE.debugTests.isTrue();
        this.DEBUGSUBSETOREQUAL = AffineProperties.INSTANCE.debugSubsetOrEqual.isTrue();
    }

    protected RedundantAffine(AffineState state, D childState) {
        super(NAME, state, childState);
        this.DEBUGOTHER = AffineProperties.INSTANCE.debugOther.isTrue();
        this.DEBUGASSIGN = AffineProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGBINARIES = AffineProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGTESTS = AffineProperties.INSTANCE.debugTests.isTrue();
        this.DEBUGSUBSETOREQUAL = AffineProperties.INSTANCE.debugSubsetOrEqual.isTrue();
    }

    @Override
    public RedundantAffine<D> build(AffineState state, D childState) {
        return new RedundantAffine<D>(state, childState);
    }

    @Override
    public RedundantAffine<D> eval(Zeno.Assign assign) {
        Zeno.Assign stmt = InliningVisitor.run(assign, (AffineState)this.state);
        stmt = ZenoExprSimplifier.run(stmt, (QueryChannel)((Object)this.childState));
        AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
        Zeno.Rhs rhs = stmt.getRhs();
        if (rhs instanceof Zeno.Rlin) {
            Zeno.Rlin rlin = (Zeno.Rlin)rhs;
            Linear le = rlin.getLinearTerm();
            Linear.Divisor d = new Linear.Divisor(rlin.getDivisor());
            sys.affineTrans(d, stmt.getLhs().getId(), le);
            if (this.DEBUGASSIGN) {
                System.out.println(this.name + ":");
                System.out.println("  after " + assign + " that is inlined to " + stmt);
                System.out.println("  on child: " + sys.getChildOps());
                System.out.println("  equations: " + sys.build().toString());
            }
        } else {
            sys.promoteVariable(stmt.getLhs().getId());
        }
        AffineState newState = sys.build();
        ZenoDomain newChildState = (ZenoDomain)this.childState;
        if (stmt.getRhs().getVars().size() < assign.getRhs().getVars().size()) {
            assign = stmt;
        }
        newChildState = newChildState.eval(assign);
        newChildState = this.refineChildWithEqualities(newState.newEqualities, newState, newChildState);
        return this.build(newState, (D)newChildState);
    }

    @Override
    public RedundantAffine<D> eval(Zeno.Test test) {
        Zeno.Test stmt = InliningVisitor.run(test, (AffineState)this.state);
        if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
            System.out.println("Affine test: " + test);
        }
        if (ZenoTestHelper.isTautologyReportUnreachable(stmt)) {
            if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                System.out.println("Affine swallowed test: " + test);
            }
            return this;
        }
        Object newChildState = ((ZenoDomain)this.childState).eval(test);
        if (test != stmt) {
            newChildState = newChildState.eval(stmt);
        }
        newChildState = this.refineWithInlinedTests(stmt, newChildState);
        SynthChannel synthChannel = newChildState.getSynthChannel();
        SetOfEquations newChildEqualities = synthChannel.getEquations();
        if (stmt.getOperator() == Zeno.ZenoTestOp.EqualToZero) {
            newChildEqualities = newChildEqualities.add(stmt.getExpr().toEquality());
        }
        if (newChildEqualities.isEmpty()) {
            if (this.DEBUGTESTS) {
                System.out.println(this.name + ": ");
                System.out.println("  evaluating test: " + test);
                System.out.println("  this: " + this.state);
                System.out.println(StringHelpers.indentMultiline("  before: ", ((ZenoDomain)this.childState).toString()));
                System.out.println(StringHelpers.indentMultiline("  after:  ", newChildState.toString()));
            }
            return this.build((AffineState)this.state, newChildState);
        }
        AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
        for (Linear equality : newChildEqualities) {
            equality = sys.inlineIntoLinear(equality, Linear.Divisor.one());
            sys.intersectWithLinear(equality);
        }
        AffineState newState = sys.build();
        VarSet newConstantVars = newState.newEqualities.difference(synthChannel.getVariables());
        newChildState = this.refineChildWithEqualities(newConstantVars, newState, newChildState);
        if (this.DEBUGTESTS) {
            System.out.println(this.name + ": ");
            System.out.println("  evaluating test: " + stmt);
            System.out.println("  this (before): " + this.state);
            System.out.println("  this (after):  " + newState);
            System.out.println(StringHelpers.indentMultiline("  before: ", ((ZenoDomain)this.childState).toString()));
            System.out.println(StringHelpers.indentMultiline("  after:  ", newChildState.toString()));
        }
        return this.build(newState, newChildState);
    }

    private RedundantAffine<D> stripSynthChannel() {
        AffineState newState = ((AffineState)this.state).withoutEqualities();
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).setContext(this.getContext());
        return this.build(newState, (D)newChildState);
    }

    private D refineChildWithEqualities(VarSet equalityVars, AffineState state, D childState) {
        for (NumVar var : equalityVars) {
            Linear newEquality = state.affine.get(var).get().toEquality();
            Zeno.Test newEqualityTest = zeno.comparison(zeno.linear(newEquality), Zeno.ZenoTestOp.EqualToZero);
            try {
                childState = childState.eval(newEqualityTest);
            }
            catch (Unreachable e) {
                Range value = childState.queryRange(newEquality);
                this.getContext().addWarning(new UnreducedChildInfo(newEqualityTest, value));
                throw e;
            }
        }
        return childState;
    }

    private D refineWithInlinedTests(Zeno.Test test, D childState) {
        D newChildState = childState;
        Linear testTerm = test.getExpr();
        for (NumVar var : testTerm.getVars()) {
            for (Linear equality : ((AffineState)this.state).getConstraints(var)) {
                Zeno.Test newTest = zeno.comparison(equality, Zeno.ZenoTestOp.EqualToZero);
                newChildState = newChildState.eval(newTest);
            }
        }
        return newChildState;
    }

    @Override
    public RedundantAffine<D> introduce(NumVar variable, Type type, Option<BigInt> value) {
        if (((AffineState)this.state).inSupport(variable)) {
            throw new DomainStateException.VariableSupportSetException();
        }
        AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
        if (value.isSome()) {
            sys.getChildOps().addIntro(variable);
            sys.affineTrans(Linear.Divisor.one(), variable, Linear.linear(value.get()));
        }
        Object newChildState = ((ZenoDomain)this.childState).introduce(variable, type, value);
        return this.build(sys.build(), newChildState);
    }

    @Override
    public RedundantAffine<D> project(VarSet vars) {
        AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
        for (NumVar variable : vars) {
            sys.removeVariable(variable);
            if (!this.DEBUGOTHER) continue;
            System.out.println(this.name + ":");
            System.out.println("  project: " + vars);
            System.out.println("  on child: " + sys.getChildOps());
            System.out.println("  equations: " + sys.build().toString());
            AffineState newCtx = sys.build();
            assert (newCtx.notInSupport(variable));
        }
        Object newChildState = ((ZenoDomain)this.childState).project(vars);
        AffineState newCtx = sys.build();
        return this.build(newCtx, newChildState);
    }

    @Override
    public RedundantAffine<D> substitute(NumVar x, NumVar y) {
        if (((AffineState)this.state).inSupport(y)) {
            throw new DomainStateException.VariableSupportSetException();
        }
        Linear newEq = ((AffineState)this.state).inlineIntoLinear(Linear.linear(x), Linear.Divisor.one());
        AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
        sys.affineTrans(Linear.Divisor.one(), y, newEq);
        sys.removeVariable(x);
        Object newChildState = ((ZenoDomain)this.childState).substitute(x, y);
        return this.build(sys.build(), newChildState);
    }

    @Override
    public RedundantAffine<D> expand(FoldMap pairs) {
        LinkedList<VarPair> leadingPairs = new LinkedList<VarPair>();
        LinkedList<VarPair> parameterPairs = new LinkedList<VarPair>();
        for (VarPair pair : pairs) {
            if (((AffineState)this.state).affine.contains((NumVar)pair.getPermanent())) {
                leadingPairs.add(pair);
                continue;
            }
            parameterPairs.add(pair);
        }
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).expand(pairs);
        VarSet lhsVars = VarSet.empty();
        for (VarPair pair : parameterPairs) {
            lhsVars = lhsVars.union(((AffineState)this.state).reverse.get((NumVar)pair.getPermanent()).getOrElse(VarSet.empty()));
        }
        for (VarPair pair : leadingPairs) {
            lhsVars = lhsVars.add((NumVar)pair.getPermanent());
        }
        if (lhsVars.size() == 0) {
            return this.build((AffineState)this.state, (D)newChildState);
        }
        AffineStateBuilder builder = new AffineStateBuilder((AffineState)this.state);
        for (NumVar var : lhsVars) {
            Linear eq = ((AffineState)this.state).affine.get(var).get();
            eq = eq.renameVar(pairs);
            eq = builder.inlineIntoLinear(eq, Linear.Divisor.one());
            builder.intersectWithLinear(eq);
        }
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public RedundantAffine<D> fold(FoldMap pairs) {
        AffineStateBuilder builder = new AffineStateBuilder((AffineState)this.state);
        builder.fold(pairs);
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).fold(pairs);
        AffineState built = builder.build();
        return this.build(built, (D)newChildState);
    }

    @Override
    public RedundantAffine<D> copyAndPaste(VarSet vars, RedundantAffine<D> from) {
        VarSet paramVars = vars;
        LinkedList<Linear> eqsToCopy = new LinkedList<Linear>();
        for (NumVar var : paramVars) {
            Option<Linear> oEq = ((AffineState)from.state).affine.get(var);
            if (!oEq.isSome()) continue;
            paramVars = paramVars.remove(var);
            eqsToCopy.add(oEq.get());
        }
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).copyAndPaste(vars, (Summarization)((Object)from.childState));
        AffineStateBuilder builder = new AffineStateBuilder((AffineState)this.state);
        for (Linear eq : eqsToCopy) {
            Range range;
            NumVar key = eq.getKey();
            VarSet varsInEq = eq.getVars().remove(key);
            VarSet varsNotCopied = varsInEq.difference(paramVars);
            if (varsNotCopied.size() == 0) {
                builder.insertLinear(eq);
                continue;
            }
            Linear queryEq = Linear.linear(eq.getConstant());
            eq = eq.dropConstant();
            for (NumVar var : varsNotCopied) {
                queryEq = queryEq.addTerm(eq.getCoeff(var), var);
                eq = eq.dropTerm(var);
            }
            BigInt d = eq.getCoeff(key);
            if (!d.isOne()) {
                eq = eq.dropTerm(key).addTerm(Bound.ONE, key);
            }
            if (!(range = from.queryRange(queryEq)).isFinite()) continue;
            if (range.isConstant()) {
                eq = eq.add(range.getConstantOrNull());
                newChildState = newChildState.eval(zeno.comparison(zeno.linear(eq, d), Zeno.ZenoTestOp.EqualToZero));
                continue;
            }
            Linear upperBoundEquation = eq.add(range.getMax()).negate();
            newChildState = newChildState.eval(zeno.comparison(zeno.linear(upperBoundEquation, d), Zeno.ZenoTestOp.LessThanOrEqualToZero));
            Linear lowerBoundEquation = eq.add(range.getMin());
            newChildState = newChildState.eval(zeno.comparison(zeno.linear(lowerBoundEquation, d), Zeno.ZenoTestOp.LessThanOrEqualToZero));
        }
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public boolean subsetOrEqual(RedundantAffine<D> other) {
        AffineStateBuilder fst = new AffineStateBuilder((AffineState)this.state);
        AffineStateBuilder snd = new AffineStateBuilder((AffineState)other.state);
        boolean isSubset = fst.makeCompatible(snd, true);
        if (this.DEBUGSUBSETOREQUAL) {
            System.out.println(this.name + ":");
            System.out.println("  subset-or-equal: " + isSubset);
            System.out.println("  fst: " + this.state);
            System.out.println("    on child: " + fst.getChildOps());
            System.out.println("  snd: " + other.state);
            System.out.println("    on child: " + snd.getChildOps());
        }
        if (!isSubset) {
            return false;
        }
        return ((ZenoDomain)this.childState).subsetOrEqual(other.childState);
    }

    @Override
    public RedundantAffine<D> join(RedundantAffine<D> other) {
        AffineStateBuilder fst = new AffineStateBuilder((AffineState)this.state);
        AffineStateBuilder snd = new AffineStateBuilder((AffineState)other.state);
        fst.makeCompatible(snd, false);
        if (this.DEBUGBINARIES) {
            System.out.println(this.name + ":");
            System.out.println("  fst: " + this.state);
            System.out.println("    on child: " + fst.getChildOps());
            System.out.println("  snd: " + other.state);
            System.out.println("    on child: " + snd.getChildOps());
        }
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).join(other.childState);
        return this.build(fst.build(), (D)newChildState);
    }

    @Override
    public RedundantAffine<D> widen(RedundantAffine<D> other) {
        AffineStateBuilder fst = new AffineStateBuilder((AffineState)this.state);
        AffineStateBuilder snd = new AffineStateBuilder((AffineState)other.state);
        fst.makeCompatible(snd, false);
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).widen(other.childState);
        AffineState newState = fst.build();
        VarSet equalitiesWithFlags = VarSet.empty();
        for (P2<NumVar, Linear> p2 : newState.affine) {
            if (!RedundantAffine.containsFlag(p2._2())) continue;
            equalitiesWithFlags = equalitiesWithFlags.add(p2._1());
        }
        newChildState = this.refineChildWithEqualities(equalitiesWithFlags, newState, newChildState);
        return this.build(newState, (D)newChildState);
    }

    private static boolean containsFlag(Linear equality) {
        for (NumVar variable : equality.getVars()) {
            if (!variable.isFlag()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Range queryRange(Linear expr) {
        Linear.Divisor d = Linear.Divisor.one();
        Linear inlined = AffineState.inlineIntoLinear(expr, d, ((AffineState)this.state).affine);
        if (inlined.isConstantOnly() && d.get().isEqualTo(Bound.ONE)) {
            return Range.from(inlined.getConstant());
        }
        Range result = ((ZenoDomain)this.childState).queryRange(expr);
        if (this.DEBUGOTHER) {
            System.out.println(this.name + ":");
            System.out.println("  query: " + expr + " that is: " + inlined);
            System.out.println("  equations: " + this.state);
            System.out.println("  divisor: " + d.get());
            System.out.println("  result: " + result);
        }
        return result;
    }

    @Override
    public SetOfEquations queryEqualities(NumVar variable) {
        SetOfEquations equalities = SetOfEquations.empty();
        Linear eq = ((AffineState)this.state).affine.get(variable).getOrNull();
        if (eq != null) {
            equalities = equalities.add(eq);
        }
        VarSet usedIn = ((AffineState)this.state).reverse.get(variable).getOrElse(VarSet.empty());
        for (NumVar x : usedIn) {
            equalities = equalities.add(((AffineState)this.state).affine.get(x).get());
        }
        return equalities;
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel synth = super.getSynthChannel().clone();
        for (NumVar var : ((AffineState)this.state).newEqualities) {
            synth.addEquation(((AffineState)this.state).affine.get(var).get());
        }
        return synth;
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        ((AffineState)this.state).appendVar(builder, var, (PrettyDomain)((Object)this.childState));
    }
}

