/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.affine;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.abstractsyntax.zeno.util.ZenoExprSimplifier;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.combinators.ZenoFunctor;
import bindead.domainnetwork.interfaces.Summarization;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.AffineProperties;
import bindead.domains.affine.AffineState;
import bindead.domains.affine.AffineStateBuilder;
import bindead.domains.affine.InliningVisitor;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import java.util.LinkedList;
import javalx.data.Option;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import rreil.lang.util.Type;

public class Affine<D extends ZenoDomain<D>>
extends ZenoFunctor<AffineState, D, Affine<D>> {
    public static final String NAME = "AFFINE";
    private static final ZenoFactory zeno = ZenoFactory.getInstance();
    private final boolean DEBUGASSIGN;
    private final boolean DEBUGBINARIES;
    private final boolean DEBUGTESTS;
    private final boolean DEBUGOTHER;
    private final boolean DEBUGSUBSETOREQUAL;

    public Affine(D child) {
        super(NAME, AffineState.EMPTY, child);
        this.DEBUGASSIGN = AffineProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGBINARIES = AffineProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGTESTS = AffineProperties.INSTANCE.debugTests.isTrue();
        this.DEBUGOTHER = AffineProperties.INSTANCE.debugOther.isTrue();
        this.DEBUGSUBSETOREQUAL = AffineProperties.INSTANCE.debugSubsetOrEqual.isTrue();
    }

    private Affine(AffineState state, D childState) {
        super(NAME, state, childState);
        this.DEBUGASSIGN = AffineProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGBINARIES = AffineProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGTESTS = AffineProperties.INSTANCE.debugTests.isTrue();
        this.DEBUGOTHER = AffineProperties.INSTANCE.debugOther.isTrue();
        this.DEBUGSUBSETOREQUAL = AffineProperties.INSTANCE.debugSubsetOrEqual.isTrue();
    }

    @Override
    public Affine<D> build(AffineState state, D childState) {
        return new Affine<D>(state, childState);
    }

    @Override
    public Affine<D> eval(Zeno.Assign assign) {
        Zeno.Assign stmt = InliningVisitor.run(assign, (AffineState)this.state);
        stmt = ZenoExprSimplifier.run(stmt, (QueryChannel)((Object)this.childState));
        AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
        Zeno.Rhs rhs = stmt.getRhs();
        ZenoDomain newChildState = (ZenoDomain)this.childState;
        if (rhs instanceof Zeno.Rlin) {
            Zeno.Rlin rlin = (Zeno.Rlin)rhs;
            Linear le = rlin.getLinearTerm();
            Linear.Divisor d = new Linear.Divisor(rlin.getDivisor());
            sys.affineTrans(d, stmt.getLhs().getId(), le);
            if (this.DEBUGASSIGN) {
                System.out.println(this.name + ":");
                System.out.println("  after " + assign + " that is " + stmt);
                System.out.println("  on child: " + sys.getChildOps());
                System.out.println("  equations: " + sys.build().toString());
            }
            newChildState = sys.applyChildOps(newChildState);
        } else {
            sys.promoteVariable(stmt.getLhs().getId());
            try {
                newChildState = sys.applyChildOps(newChildState);
            }
            catch (Unreachable e) {
                stmt = zeno.assign(stmt.getLhs(), zeno.range(Interval.TOP));
                throw e;
            }
            newChildState = newChildState.eval(stmt);
        }
        return this.build(sys.build(), (D)newChildState);
    }

    @Override
    public Affine<D> eval(Zeno.Test test) {
        Zeno.Test stmt = InliningVisitor.run(test, (AffineState)this.state);
        if (ZenoTestHelper.isTautologyReportUnreachable(stmt)) {
            return this;
        }
        Object newChildState = ((ZenoDomain)this.childState).eval(stmt);
        if (this.DEBUGTESTS) {
            System.out.println(this.name + ": ");
            System.out.println("  evaluating test: " + stmt);
            System.out.println("  this: " + this.state);
            System.out.println("  before: " + this.childState);
            System.out.println("  after: " + newChildState);
        }
        SetOfEquations equalities = newChildState.getSynthChannel().getEquations();
        if (stmt.getOperator() == Zeno.ZenoTestOp.EqualToZero) {
            equalities = equalities.add(stmt.getExpr().toEquality());
        }
        if (equalities.isEmpty()) {
            return this.build((AffineState)this.state, newChildState);
        }
        AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
        for (Linear eq : equalities) {
            eq = sys.inlineIntoLinear(eq, Linear.Divisor.one());
            sys.intersectWithLinear(eq);
        }
        newChildState = sys.applyChildOps(newChildState);
        return this.build(sys.build(), newChildState);
    }

    private Affine<D> stripSynthChannel() {
        AffineState newState = ((AffineState)this.state).withoutEqualities();
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).setContext(this.getContext());
        return this.build(newState, (D)newChildState);
    }

    @Override
    public Affine<D> introduce(NumVar variable, Type type, Option<BigInt> value) {
        if (((AffineState)this.state).inSupport(variable)) {
            throw new DomainStateException.VariableSupportSetException();
        }
        if (value.isSome()) {
            AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
            sys.getChildOps().addIntro(variable);
            sys.affineTrans(Linear.Divisor.one(), variable, Linear.linear(value.get()));
            ZenoDomain newChildState = sys.applyChildOps((ZenoDomain)this.childState);
            return this.build(sys.build(), (D)newChildState);
        }
        Object newChildState = ((ZenoDomain)this.childState).introduce(variable, type, value);
        return this.build((AffineState)this.state, newChildState);
    }

    @Override
    public Affine<D> project(VarSet vars) {
        AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
        for (NumVar variable : vars) {
            sys.removeVariable(variable);
            if (this.DEBUGOTHER) {
                System.out.println(this.name + ":");
                System.out.println("  project: " + variable);
                System.out.println("  on child: " + sys.getChildOps());
                System.out.println("  equations: " + sys.build().toString());
            }
            AffineState newCtx = sys.build();
            assert (newCtx.notInSupport(variable));
        }
        ZenoDomain newChildState = sys.applyChildOps((ZenoDomain)this.childState);
        AffineState newCtx = sys.build();
        return this.build(newCtx, (D)newChildState);
    }

    @Override
    public Affine<D> substitute(NumVar x, NumVar y) {
        if (((AffineState)this.state).inSupport(y)) {
            throw new DomainStateException.VariableSupportSetException();
        }
        Linear newEq = ((AffineState)this.state).inlineIntoLinear(Linear.linear(x), Linear.Divisor.one());
        AffineStateBuilder sys = new AffineStateBuilder((AffineState)this.state);
        sys.getChildOps().addIntro(y);
        sys.affineTrans(Linear.Divisor.one(), y, newEq);
        sys.removeVariable(x);
        ZenoDomain newChildState = sys.applyChildOps((ZenoDomain)this.childState);
        return this.build(sys.build(), (D)newChildState);
    }

    @Override
    public Affine<D> expand(FoldMap pairs) {
        FoldMap leadingPairs = new FoldMap();
        FoldMap parameterPairs = new FoldMap();
        for (VarPair pair : pairs) {
            if (((AffineState)this.state).affine.get((NumVar)pair.getPermanent()).isSome()) {
                leadingPairs.add(pair);
                continue;
            }
            parameterPairs.add(pair);
        }
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).expand(parameterPairs);
        VarSet lhsVars = VarSet.empty();
        for (VarPair pair : parameterPairs) {
            lhsVars = lhsVars.union(((AffineState)this.state).reverse.get((NumVar)pair.getPermanent()).getOrElse(VarSet.empty()));
        }
        for (VarPair pair : leadingPairs) {
            lhsVars = lhsVars.add((NumVar)pair.getPermanent());
        }
        if (lhsVars.size() == 0) {
            return this.build((AffineState)this.state, (D)newChildState);
        }
        AffineStateBuilder builder = new AffineStateBuilder((AffineState)this.state);
        for (VarPair pair : leadingPairs) {
            builder.getChildOps().addIntro((NumVar)pair.getEphemeral());
        }
        for (NumVar var : lhsVars) {
            Linear eq = ((AffineState)this.state).affine.get(var).get();
            eq = eq.renameVar(pairs);
            eq = builder.inlineIntoLinear(eq, Linear.Divisor.one());
            builder.getChildOps().addTest(zeno.comparison(eq, Zeno.ZenoTestOp.EqualToZero));
            builder.intersectWithLinear(eq);
        }
        newChildState = builder.applyChildOps(newChildState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Affine<D> fold(FoldMap pairs) {
        AffineStateBuilder builder = new AffineStateBuilder((AffineState)this.state);
        pairs = builder.fold(pairs);
        ZenoDomain newChildState = builder.applyChildOps((ZenoDomain)this.childState);
        newChildState = (ZenoDomain)newChildState.fold(pairs);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Affine<D> copyAndPaste(VarSet vars, Affine<D> from) {
        VarSet paramVars = vars;
        LinkedList<Linear> eqsToCopy = new LinkedList<Linear>();
        for (NumVar var : paramVars) {
            Option<Linear> oEq = ((AffineState)from.state).affine.get(var);
            if (!oEq.isSome()) continue;
            paramVars = paramVars.remove(var);
            eqsToCopy.add(oEq.get());
        }
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).copyAndPaste(paramVars, (Summarization)((Object)from.childState));
        AffineStateBuilder builder = new AffineStateBuilder((AffineState)this.state);
        for (Linear eq : eqsToCopy) {
            NumVar key = eq.getKey();
            VarSet varsInEq = eq.getVars().remove(key);
            VarSet varsNotCopied = varsInEq.difference(paramVars);
            if (varsNotCopied.size() == 0) {
                builder.insertLinear(eq);
                continue;
            }
            Linear queryEq = Linear.linear(eq.getConstant());
            eq = eq.dropConstant();
            for (NumVar var : varsNotCopied) {
                queryEq = queryEq.addTerm(eq.getCoeff(var), var);
                eq = eq.dropTerm(var);
            }
            BigInt d = eq.getCoeff(key);
            if (!d.isOne()) {
                eq = eq.dropTerm(key).addTerm(Bound.ONE, key);
            }
            Range range = from.queryRange(queryEq);
            builder.getChildOps().addIntro(key);
            builder.getChildOps().addAssignment(zeno.assign(zeno.variable(key), zeno.range(range)));
            builder.getChildOps().addAssignment(zeno.assign(zeno.variable(key), zeno.linear(eq, d)));
        }
        newChildState = builder.applyChildOps(newChildState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Affine<D> join(Affine<D> other) {
        AffineStateBuilder fst = new AffineStateBuilder((AffineState)this.state);
        AffineStateBuilder snd = new AffineStateBuilder((AffineState)other.state);
        fst.makeCompatible(snd, false);
        if (this.DEBUGBINARIES) {
            System.out.println(this.name + ":");
            System.out.println("  fst: " + this.state);
            System.out.println("    on child: " + fst.getChildOps());
            System.out.println("  snd: " + other.state);
            System.out.println("    on child: " + snd.getChildOps());
        }
        ZenoDomain newChildStateOfFst = fst.applyChildOps((ZenoDomain)this.childState);
        ZenoDomain newChildStateOfSnd = snd.applyChildOps((ZenoDomain)other.childState);
        ZenoDomain newChildState = newChildStateOfFst.join(newChildStateOfSnd);
        return this.build(fst.build(), (D)newChildState);
    }

    @Override
    public boolean subsetOrEqual(Affine<D> other) {
        AffineStateBuilder fst = new AffineStateBuilder((AffineState)this.state);
        AffineStateBuilder snd = new AffineStateBuilder((AffineState)other.state);
        boolean isSubset = fst.makeCompatible(snd, true);
        if (this.DEBUGSUBSETOREQUAL) {
            System.out.println(this.name + ":");
            System.out.println("  subset-or-equal: " + isSubset);
            System.out.println("  fst: " + this.state);
            System.out.println("    on child: " + fst.getChildOps());
            System.out.println("  snd: " + other.state);
            System.out.println("    on child: " + snd.getChildOps());
        }
        if (!isSubset) {
            return false;
        }
        ZenoDomain newChildStateOfFst = fst.applyChildOps((ZenoDomain)this.childState);
        ZenoDomain newChildStateOfSnd = snd.applyChildOps((ZenoDomain)other.childState);
        return newChildStateOfFst.subsetOrEqual(newChildStateOfSnd);
    }

    @Override
    public Affine<D> widen(Affine<D> other) {
        AffineStateBuilder fst = new AffineStateBuilder((AffineState)this.state);
        AffineStateBuilder snd = new AffineStateBuilder((AffineState)other.state);
        fst.makeCompatible(snd, false);
        ZenoDomain newChildStateOfFst = fst.applyChildOps((ZenoDomain)this.childState);
        ZenoDomain newChildStateOfSnd = snd.applyChildOps((ZenoDomain)other.childState);
        ZenoDomain newChildState = newChildStateOfFst.widen(newChildStateOfSnd);
        return this.build(fst.build(), (D)newChildState);
    }

    @Override
    public Range queryRange(Linear linear) {
        Linear.Divisor d = Linear.Divisor.one();
        Linear inlined = AffineState.inlineIntoLinear(linear, d, ((AffineState)this.state).affine);
        Range result = ((ZenoDomain)this.childState).queryRange(inlined).divRoundInvards(d.get());
        if (this.DEBUGOTHER) {
            System.out.println(this.name + ":");
            System.out.println("  query: " + linear + " that is: " + inlined);
            System.out.println("  equations: " + this.state);
            System.out.println("  divisor: " + d.get());
            System.out.println("  result: " + result);
        }
        if (result == null) {
            throw new Unreachable();
        }
        return result;
    }

    @Override
    public SetOfEquations queryEqualities(NumVar variable) {
        SetOfEquations equalities = SetOfEquations.empty();
        Linear eq = ((AffineState)this.state).affine.get(variable).getOrNull();
        if (eq != null) {
            equalities = equalities.add(eq);
        }
        VarSet usedIn = ((AffineState)this.state).reverse.get(variable).getOrElse(VarSet.empty());
        for (NumVar x : usedIn) {
            equalities = equalities.add(((AffineState)this.state).affine.get(x).get());
        }
        return equalities;
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel syn = ((ZenoDomain)this.childState).getSynthChannel().clone();
        for (NumVar var : ((AffineState)this.state).newEqualities) {
            syn.addEquation(((AffineState)this.state).affine.get(var).get());
        }
        return syn;
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        ((AffineState)this.state).appendVar(builder, var, (PrettyDomain)((Object)this.childState));
    }
}

