/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.interfaces;

import bindead.domainnetwork.interfaces.ContentCtx;
import javalx.data.Option;
import javalx.numeric.BigInt;

public class RegionCtx {
    public static final RegionCtx EMPTYSTICKY = new RegionCtx();
    private final Option<ContentCtx> segment;

    private RegionCtx() {
        this(null);
    }

    public RegionCtx(ContentCtx segment) {
        this.segment = Option.fromNullable(segment);
    }

    public Option<BigInt> getAddress() {
        if (this.segment.isSome()) {
            return Option.some(this.segment.get().getAddress());
        }
        return Option.none();
    }

    public boolean isAddressable() {
        return this.segment.isSome();
    }

    public Option<ContentCtx> getSegment() {
        return this.segment;
    }

    public boolean isSticky() {
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegionCtx{");
        if (this.segment.isSome()) {
            builder.append(", " + this.segment.get());
        }
        builder.append("}");
        return builder.toString();
    }
}

