/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.interfaces;

import binparse.Endianness;
import binparse.Permission;
import java.math.BigInteger;
import java.util.Set;
import javalx.data.Option;
import javalx.numeric.BigInt;
import javalx.numeric.FiniteRange;

public class ContentCtx {
    private final String name;
    private final BigInt address;
    private final long size;
    private final Set<Permission> permissions;
    private final byte[] data;
    private final Endianness endianness;

    public ContentCtx(String name, BigInt address, long size, Set<Permission> permissions, byte[] data, Endianness endianness) {
        this(name, address, size, permissions, Option.fromNullable(data), Option.fromNullable(endianness));
    }

    private ContentCtx(String name, BigInt address, long size, Set<Permission> permissions, Option<byte[]> data, Option<Endianness> endianness) {
        this.name = name;
        this.address = address;
        this.size = size;
        this.permissions = permissions;
        this.data = data.getOrElse(new byte[0]);
        this.endianness = endianness.getOrElse(Endianness.BIG);
    }

    public BigInt getAddress() {
        return this.address;
    }

    public BigInt getEndAddress() {
        return this.address.add(BigInt.of(this.size));
    }

    public long getSize() {
        return this.size;
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "SegmentCtx{name=" + this.name + ", address=" + this.address + ", size=" + this.size + ", permissions=" + this.permissions + ", data=" + this.data + ", endianness=" + (Object)((Object)this.endianness) + '}';
    }

    public BigInt read(int offset, int size, Endianness endianness) {
        byte[] slice = this.slice(offset, size);
        if (endianness == Endianness.LITTLE) {
            Endianness.reverseByteOrder(slice);
        }
        return BigInt.of(new BigInteger(slice));
    }

    private byte[] slice(int byteOffset, int byteLength) {
        byte[] slice = new byte[byteLength];
        assert (byteOffset >= 0);
        assert (this.data.length >= byteOffset + byteLength) : "Data length= " + this.data.length + " < offset + readAmount= " + byteOffset + " + " + byteLength + " in ctx " + this;
        System.arraycopy(this.data, byteOffset, slice, 0, byteLength);
        return slice;
    }

    public FiniteRange addressableSpaceInBytes() {
        return FiniteRange.of(this.getAddress(), this.getSize());
    }
}

