/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.combinators;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.Substitution;
import bindead.exceptions.Unreachable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P3;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Congruence;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import rreil.lang.util.Type;

public abstract class ZenoChildOp {
    public abstract <D extends ZenoDomain<D>> D apply(D var1);

    public static class Sequence
    implements Iterable<ZenoChildOp> {
        private final List<ZenoChildOp> childTrans = new ArrayList<ZenoChildOp>(6);

        private ZenoChildOp getLastElement() {
            return this.childTrans.get(this.childTrans.size() - 1);
        }

        private void removeLastElement() {
            this.childTrans.remove(this.childTrans.size() - 1);
        }

        @Override
        public Iterator<ZenoChildOp> iterator() {
            return this.childTrans.iterator();
        }

        public void hoist() {
            for (int hostIndex = this.childTrans.size() - 2; hostIndex >= 0; --hostIndex) {
                if (!(this.childTrans.get(hostIndex) instanceof CanHoist)) continue;
                CanHoist host = (CanHoist)((Object)this.childTrans.get(hostIndex));
                Sequence toHoist = new Sequence();
                List<ZenoChildOp> ops = this.childTrans.subList(hostIndex + 1, this.childTrans.size());
                toHoist.childTrans.addAll(ops);
                ops.clear();
                host.setHoisted(toHoist);
                this.hoist();
                return;
            }
        }

        public void addIntro(NumVar var) {
            this.childTrans.add(new Introduction(var));
        }

        public void addIntro(NumVar var, BigInt value) {
            this.childTrans.add(new Introduction(var, value));
        }

        @Deprecated
        public void addKill(NumVar var) {
            this.addKill(VarSet.of(var));
        }

        public void addKill(VarSet vars) {
            Introduction intro;
            if (vars.isEmpty()) {
                return;
            }
            if (!this.childTrans.isEmpty() && this.getLastElement() instanceof Kill) {
                Kill kill = (Kill)this.getLastElement();
                this.removeLastElement();
                this.addKill(kill.vars.union(vars));
                return;
            }
            if (!this.childTrans.isEmpty() && this.getLastElement() instanceof Introduction && vars.contains((intro = (Introduction)this.getLastElement()).var)) {
                this.removeLastElement();
                this.addKill(vars.remove(intro.var));
                return;
            }
            this.childTrans.add(new Kill(vars));
        }

        public void addDirectSubstitution(NumVar kill, NumVar add) {
            if (kill != add) {
                this.childTrans.add(new Subst(kill, add));
            }
        }

        public void addTest(Zeno.Test test) {
            this.childTrans.add(new Test(test));
        }

        public void addAssignment(Zeno.Assign stmt) {
            this.childTrans.add(new Assignment(stmt));
        }

        public void addAssignment(Zeno.Assign stmt, NumVar from, NumVar to) {
            if (from != to && to != null) {
                this.addIntro(to);
            }
            this.childTrans.add(new Assignment(stmt));
            if (from != to && from != null) {
                this.addKill(from);
            }
        }

        public void addAssignment(Substitution subst, NumVar to) {
            assert (to != null);
            BigInt toCoeff = subst.getExpr().getCoeff(to);
            Linear le = subst.getExpr().dropTerm(to).subTerm(subst.getFac(), subst.getVar());
            ZenoFactory f = ZenoFactory.getInstance();
            Zeno.Assign stmt = f.assign(f.variable(to), f.linear(le, toCoeff.negate()));
            this.addAssignment(stmt);
        }

        public void addBottom() {
            this.childTrans.clear();
            this.childTrans.add(new Bottom());
        }

        public void addEquality(Linear eq) {
            this.addLinearTransform(eq, null);
        }

        public void addLinearTransform(Linear eq, NumVar from) {
            NumVar to = eq.getKey();
            BigInt coeff = eq.getCoeff(to).negate();
            if ((eq = eq.dropTerm(to)).isConstantOnly()) {
                assert (from == null);
                BigInt c = eq.getConstant().div(coeff);
                if (c.mul(coeff).isEqualTo(eq.getConstant())) {
                    this.addIntro(to, c);
                } else {
                    this.addBottom();
                }
                return;
            }
            if (eq.isSingleTerm() && eq.getConstant().isZero() && eq.getKey() == from && eq.getCoeff(from).isEqualTo(coeff)) {
                this.addDirectSubstitution(from, to);
                return;
            }
            ZenoFactory f = ZenoFactory.getInstance();
            Zeno.Assign stmt = f.assign(f.variable(to), f.linear(eq, coeff));
            this.addAssignment(stmt, from, to);
        }

        public void addScale(NumVar var, Congruence oldC, Congruence newC) {
            if (oldC.equals(newC)) {
                return;
            }
            BigInt oldScale = oldC.getScale();
            BigInt newScale = newC.getScale();
            assert (oldScale.remainder(newScale).isZero() || newScale.remainder(oldScale).isZero()) : "The scales are not multiples of each other.";
            BigInt offset = oldC.getOffset().sub(newC.getOffset());
            Zeno.Assign stmt = new Zeno.Assign(new Zeno.Lhs(var), new Zeno.Rlin(Linear.linear(offset, Linear.term(oldScale, var)), newScale));
            this.addAssignment(stmt);
        }

        public void addScaleDown(NumVar var, Congruence c) {
            assert (!c.getScale().isZero());
            Zeno.Assign stmt = new Zeno.Assign(new Zeno.Lhs(var), new Zeno.Rlin(Linear.linear(c.getOffset().negate(), Linear.term(var)), c.getScale()));
            this.addAssignment(stmt);
        }

        public void addSubstitution(Substitution subst, NumVar to) {
            NumVar from = subst.getVar();
            assert (to != null);
            if (subst.isSimple()) {
                assert (to == subst.getExpr().getKey());
                this.addDirectSubstitution(from, to);
            } else {
                BigInt toCoeff = subst.getExpr().getCoeff(to);
                Linear le = subst.getExpr().dropTerm(to).subTerm(subst.getFac(), subst.getVar());
                ZenoFactory f = ZenoFactory.getInstance();
                Zeno.Assign stmt = f.assign(f.variable(to), f.linear(le, toCoeff.negate()));
                this.addAssignment(stmt, from, to);
            }
        }

        public void addWrap(NumVar var, Interval range, boolean saturating) {
            this.childTrans.add(new Wrap(var, range, saturating));
        }

        public void addAnd(NumVar var, Linear left, Linear right, int size) {
            this.childTrans.add(new And(var, left, right, size));
        }

        public void addOr(NumVar var, Linear left, Linear right, int size) {
            this.childTrans.add(new Or(var, left, right, size));
        }

        public void addXOr(NumVar var, Linear left, Linear right, int size) {
            this.childTrans.add(new XOr(var, left, right, size));
        }

        public int length() {
            return this.childTrans.size();
        }

        public boolean isEmpty() {
            return this.length() == 0;
        }

        public <D extends ZenoDomain<D>> D apply(D state) {
            D newState = state;
            for (ZenoChildOp action : this.childTrans) {
                newState = action.apply(newState);
                if (newState != null) continue;
                throw new Unreachable();
            }
            assert (newState != null);
            this.childTrans.clear();
            return newState;
        }

        public String toString() {
            String res = "";
            String sep = "";
            for (ZenoChildOp ct : this.childTrans) {
                res = res + sep + ct.toString();
                sep = "; ";
            }
            return res;
        }
    }

    private static class XOr
    extends ZenoChildOp {
        private final NumVar var;
        private final Linear left;
        private final Linear right;
        private final int size;

        protected XOr(NumVar var, Linear left, Linear right, int size) {
            this.var = var;
            this.left = left;
            this.right = right;
            this.size = size;
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            ZenoFactory zeno = ZenoFactory.getInstance();
            Zeno.Lhs lhs = zeno.variable(this.var);
            Range l = state.queryRange(this.left);
            Range r = state.queryRange(this.right);
            return state.eval(zeno.assign(lhs, zeno.range(l.unsignedXor(r, this.size))));
        }

        public String toString() {
            return this.var + "= xor(" + this.left + "," + this.right + ")";
        }
    }

    private static class Or
    extends ZenoChildOp {
        private final NumVar var;
        private final Linear left;
        private final Linear right;
        private final int size;

        protected Or(NumVar var, Linear left, Linear right, int size) {
            this.var = var;
            this.left = left;
            this.right = right;
            this.size = size;
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            ZenoFactory zeno = ZenoFactory.getInstance();
            Zeno.Lhs lhs = zeno.variable(this.var);
            Range l = state.queryRange(this.left);
            Range r = state.queryRange(this.right);
            return state.eval(zeno.assign(lhs, zeno.range(l.unsignedOr(r, this.size))));
        }

        public String toString() {
            return this.var + "= or(" + this.left + "," + this.right + ")";
        }
    }

    private static class And
    extends ZenoChildOp {
        private final NumVar var;
        private final Linear l;
        private final Linear r;
        private final int size;

        protected And(NumVar var, Linear left, Linear right, int size) {
            this.var = var;
            this.l = left;
            this.r = right;
            this.size = size;
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            Range maskRange;
            Range argRange;
            Linear arg;
            ZenoFactory zeno = ZenoFactory.getInstance();
            Zeno.Lhs lhs = zeno.variable(this.var);
            Range lRange = state.queryRange(this.l);
            Range rRange = state.queryRange(this.r);
            if (rRange.isConstant()) {
                if (lRange.isConstant()) {
                    return state.eval(zeno.assign(lhs, zeno.literal(lRange.getConstantOrNull().and(rRange.getConstantOrNull()))));
                }
                arg = this.l;
                argRange = lRange;
                maskRange = rRange;
            } else if (lRange.isConstant()) {
                arg = this.r;
                argRange = rRange;
                maskRange = lRange;
            } else {
                int lowerZero = Math.min(lRange.lowerZeroBits(this.size), rRange.lowerZeroBits(this.size));
                int upperOne = this.size - Math.max(lRange.upperZeroBits(this.size), rRange.upperOneBits(this.size));
                if (lowerZero == 0) {
                    Zeno.RangeRhs rhs = zeno.range(Range.from(Interval.unsignedTop(upperOne)));
                    return state.eval(zeno.assign(lhs, rhs));
                }
                Interval interval = Interval.unsignedTop(upperOne - lowerZero);
                state = state.eval(zeno.assign(lhs, zeno.range(Range.from(interval))));
                Linear lin = Linear.linear(Linear.term(BigInt.powerOfTwo(lowerZero), this.var));
                return state.eval(zeno.assign(lhs, zeno.linear(lin)));
            }
            int maskLowerZero = maskRange.lowerZeroBits(this.size);
            int maskFirstOne = this.size - maskRange.upperZeroBits(this.size);
            if (maskFirstOne <= 0) {
                return state.eval(zeno.assign(lhs, zeno.literal(Bound.ZERO)));
            }
            int argFirstOne = this.size - argRange.upperZeroBits(this.size);
            int argOnes = argRange.upperOneBits(argFirstOne);
            if ((argOnes = Math.min(argOnes, argFirstOne - maskFirstOne)) > 0) {
                BigInt subVal = BigInt.powerOfTwo(argOnes).sub(1L).shl(argFirstOne - argOnes);
                arg = arg.sub(subVal);
            }
            state = state.eval(zeno.assign(lhs, zeno.linear(arg)));
            if (maskLowerZero > 0) {
                int shift = maskLowerZero;
                BigInt fac = Bound.TWO.pow(shift);
                Zeno.Bin ass = zeno.binary(zeno.linear(arg), Zeno.ZenoBinOp.Shr, zeno.literal(BigInt.of(shift)));
                state = state.eval(zeno.assign(lhs, ass));
                state = state.eval(zeno.assign(lhs, zeno.linear(Linear.linear(fac, this.var))));
            }
            return state;
        }

        public String toString() {
            return this.var + "= and(" + this.l + "," + this.r + ")";
        }
    }

    private static class Wrap
    extends ZenoChildOp
    implements CanHoist {
        private final NumVar var;
        private final Interval range;
        private final boolean saturating;
        private Sequence nested = null;

        public Wrap(NumVar var, Interval range, boolean saturating) {
            this.var = var;
            this.range = range;
            this.saturating = saturating;
        }

        private <D extends ZenoDomain<D>> D restrictToQuadrant(D inState) {
            Zeno.Test test;
            Linear lin;
            D newState = inState;
            ZenoFactory zeno = ZenoFactory.getInstance();
            BigInt lower = this.range.low().asInteger();
            BigInt upper = this.range.high().asInteger();
            try {
                lin = Linear.linear(upper.negate(), Linear.term(this.var));
                test = zeno.comparison(lin, Zeno.ZenoTestOp.LessThanOrEqualToZero);
                newState = newState.eval(test);
            }
            catch (Unreachable _) {
                return null;
            }
            try {
                lin = Linear.linear(lower, Linear.term(BigInt.MINUSONE, this.var));
                test = zeno.comparison(lin, Zeno.ZenoTestOp.LessThanOrEqualToZero);
                newState = newState.eval(test);
            }
            catch (Unreachable _) {
                return null;
            }
            return newState;
        }

        private <D extends ZenoDomain<D>> D setToLower(D state) {
            if (state == null) {
                return null;
            }
            ZenoFactory zeno = ZenoFactory.getInstance();
            Zeno.Assign setToLower = zeno.assign(zeno.variable(this.var), zeno.linear(Linear.linear(this.range.low().asInteger())));
            return state.eval(setToLower);
        }

        private <D extends ZenoDomain<D>> D setToUpper(D state) {
            if (state == null) {
                return null;
            }
            ZenoFactory zeno = ZenoFactory.getInstance();
            Zeno.Assign setToUpper = zeno.assign(zeno.variable(this.var), zeno.linear(Linear.linear(this.range.high().asInteger())));
            return state.eval(setToUpper);
        }

        private <D extends ZenoDomain<D>> D setToRange(D state) {
            if (state == null) {
                return null;
            }
            ZenoFactory zeno = ZenoFactory.getInstance();
            Zeno.Assign setToUpper = zeno.assign(zeno.variable(this.var), zeno.range(this.range));
            return state.eval(setToUpper);
        }

        private <D extends ZenoDomain<D>> D applyNested(D state) {
            if (state == null) {
                return null;
            }
            if (this.nested == null) {
                return state;
            }
            try {
                for (ZenoChildOp action : this.nested.childTrans) {
                    state = action.apply(state);
                }
            }
            catch (Unreachable _) {
                state = null;
            }
            return state;
        }

        private static Zeno.Assign sub(NumVar variable, BigInt value) {
            return Wrap.add(variable, value.negate());
        }

        private static Zeno.Assign add(NumVar variable, BigInt value) {
            ZenoFactory zeno = ZenoFactory.getInstance();
            return zeno.assign(zeno.variable(variable), zeno.linear(Linear.linear(value, Linear.term(variable))));
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            BigInt span = this.range.getSpan();
            D stateRes = this.restrictToQuadrant(state);
            if (stateRes == null) {
                BigInt steps;
                Interval variableValue = state.queryRange(this.var).convexHull();
                if (variableValue.low().isFinite()) {
                    steps = variableValue.low().sub(this.range.low()).asInteger().divRoundDown(span);
                } else if (variableValue.high().isFinite()) {
                    steps = variableValue.high().sub(this.range.low()).asInteger().divRoundDown(span);
                } else {
                    return this.setToRange(state);
                }
                if (!span.isZero() && !steps.isZero()) {
                    Zeno.Assign shift = Wrap.sub(this.var, steps.mul(span));
                    state = state.eval(shift);
                }
                if ((stateRes = this.restrictToQuadrant(state)) == null) {
                    return null;
                }
            }
            D stateRef = stateRes = this.applyNested(stateRes);
            D stateNext = state;
            D statePrev = state;
            P3<D, D, D> result = this.addFromNeighbourQuadrants(stateRes, stateNext, statePrev);
            if ((stateRes = result._1()) == null) {
                throw new Unreachable();
            }
            if (stateRef != null && stateRef != stateRes) {
                stateRes = stateRef.join(stateRes);
            }
            if (stateRef != null && stateRes.subsetOrEqual(stateRef)) {
                return stateRes;
            }
            stateRef = stateRes;
            stateNext = result._2();
            if ((stateRes = (result = this.addFromNeighbourQuadrants(stateRes, stateNext, statePrev = result._3()))._1()) == null) {
                throw new Unreachable();
            }
            if (stateRes.subsetOrEqual(stateRef)) {
                return stateRes;
            }
            stateRes = this.setToRange(stateRes);
            return this.applyNested(stateRes);
        }

        private <D extends ZenoDomain<D>> P3<D, D, D> addFromNeighbourQuadrants(D stateRes, D stateNext, D statePrev) {
            BigInt span = this.range.getSpan();
            Zeno.Assign shiftUp = Wrap.add(this.var, span);
            Zeno.Assign shiftDown = Wrap.sub(this.var, span);
            stateNext = stateNext.eval(shiftDown);
            D toAdd = this.restrictToQuadrant(stateNext);
            if (this.saturating) {
                toAdd = this.setToUpper(toAdd);
            }
            if ((toAdd = this.applyNested(toAdd)) != null) {
                stateRes = stateRes == null ? toAdd : stateRes.join(toAdd);
            }
            statePrev = statePrev.eval(shiftUp);
            toAdd = this.restrictToQuadrant(statePrev);
            if (this.saturating) {
                toAdd = this.setToLower(toAdd);
            }
            if ((toAdd = this.applyNested(toAdd)) != null) {
                stateRes = stateRes == null ? toAdd : stateRes.join(toAdd);
            }
            return P3.tuple3(stateRes, stateNext, statePrev);
        }

        public String toString() {
            String res = "wrap(" + this.var + ", " + this.range;
            if (this.saturating) {
                res = res + "(saturate)";
            }
            if (this.nested != null) {
                res = res + "{ " + this.nested + " }";
            }
            res = res + ")";
            return res;
        }

        @Override
        public void setHoisted(Sequence op) {
            this.nested = op;
        }
    }

    private static class Test
    extends ZenoChildOp {
        private final Zeno.Test test;

        public Test(Zeno.Test test) {
            this.test = test;
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            return state.eval(this.test);
        }

        public String toString() {
            return this.test.toString();
        }
    }

    private static class Bottom
    extends ZenoChildOp {
        private Bottom() {
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            throw new Unreachable();
        }

        public String toString() {
            return "<unreachable>";
        }
    }

    private static class Assignment
    extends ZenoChildOp {
        private final Zeno.Assign stmt;

        protected Assignment(Zeno.Assign stmt) {
            this.stmt = stmt;
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            return state.eval(this.stmt);
        }

        public String toString() {
            return this.stmt.toString();
        }
    }

    private static class Subst
    extends ZenoChildOp {
        private final NumVar from;
        private final NumVar to;

        protected Subst(NumVar from, NumVar to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            return state.substitute(this.from, this.to);
        }

        public String toString() {
            return "[" + this.from + "\\" + this.to + "]";
        }
    }

    private static class Kill
    extends ZenoChildOp {
        private final VarSet vars;

        protected Kill(VarSet kill) {
            this.vars = kill;
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            return state.project(this.vars);
        }

        public String toString() {
            return "kill " + this.vars;
        }
    }

    private static class Introduction
    extends ZenoChildOp {
        private final NumVar var;
        private BigInt value = null;

        protected Introduction(NumVar var) {
            this.var = var;
        }

        protected Introduction(NumVar var, BigInt value) {
            this.var = var;
            this.value = value;
        }

        @Override
        public <D extends ZenoDomain<D>> D apply(D state) {
            return state.introduce(this.var, Type.Zeno, Option.fromNullable(this.value));
        }

        public String toString() {
            return "intro " + this.var + (this.value == null ? "" : " := " + this.value);
        }
    }

    private static interface CanHoist {
        public void setHoisted(Sequence var1);
    }
}

