/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.combinators;

import bindead.abstractsyntax.finite.Finite;
import bindead.data.ListVarPair;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.exceptions.Unreachable;
import javalx.data.Option;
import javalx.numeric.BigInt;
import rreil.lang.util.Type;

public abstract class FiniteChildOp {
    public abstract <D extends FiniteDomain<D>> D apply(D var1);

    public Kill isKill() {
        return null;
    }

    static class Bottom
    extends FiniteChildOp {
        Bottom() {
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            throw new Unreachable();
        }

        public String toString() {
            return "unreachable";
        }
    }

    static class DerefTarget
    extends FiniteChildOp {
        private final Finite.Rlin reference;
        private final NumVar.AddrVar target;
        private final VarSet contents;

        protected DerefTarget(Finite.Rlin pointerNumVar, NumVar.AddrVar target, VarSet c) {
            this.reference = pointerNumVar;
            this.target = target;
            this.contents = c;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.assumePointsToAndConcretize(this.reference, this.target, this.contents);
        }

        public String toString() {
            return "derefTarget(" + this.reference + ", " + this.contents + ")";
        }
    }

    static class BendBackGhostEdgesNG
    extends FiniteChildOp {
        private final NumVar.AddrVar summary;
        private final NumVar.AddrVar concrete;
        private VarSet svs;
        private VarSet cvs;
        private VarSet pts;
        private VarSet ptc;

        protected BendBackGhostEdgesNG(NumVar.AddrVar s, NumVar.AddrVar c, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
            this.concrete = c;
            this.summary = s;
            this.svs = svs;
            this.cvs = cvs;
            this.pts = pts;
            this.ptc = ptc;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.bendBackGhostEdgesNG(this.summary, this.concrete, this.svs, this.cvs, this.pts, this.ptc);
        }

        public String toString() {
            return "[bendBackGhostEdges<" + this.summary + ";" + this.concrete + "> " + this.svs + ", " + this.cvs + "]";
        }
    }

    static class BendGhostEdgesNG
    extends FiniteChildOp {
        private final NumVar.AddrVar summary;
        private final NumVar.AddrVar concrete;
        private final VarSet svs;
        private final VarSet cvs;
        private final VarSet pts;
        private final VarSet ptc;

        protected BendGhostEdgesNG(NumVar.AddrVar s, NumVar.AddrVar c, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
            this.concrete = c;
            this.summary = s;
            this.svs = svs;
            this.cvs = cvs;
            this.pts = pts;
            this.ptc = ptc;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.bendGhostEdgesNG(this.summary, this.concrete, this.svs, this.cvs, this.pts, this.ptc);
        }

        public String toString() {
            return "[bendGhostEdges s:" + this.summary + this.svs + " c:" + this.concrete + this.cvs + "]";
        }
    }

    static class ConcretizeAndDisconnectNG
    extends FiniteChildOp {
        private final NumVar.AddrVar summary;
        private final VarSet concreteVars;

        protected ConcretizeAndDisconnectNG(NumVar.AddrVar s, VarSet cs) {
            this.summary = s;
            this.concreteVars = cs;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            D expanded = state.concretizeAndDisconnectNG(this.summary, this.concreteVars);
            return expanded;
        }

        public String toString() {
            return "[concretise " + this.concreteVars + " and disconnect " + this.summary + "]";
        }
    }

    static class FoldNG
    extends FiniteChildOp {
        private final NumVar.AddrVar p;
        private final NumVar.AddrVar e;
        private final ListVarPair nvps;

        protected FoldNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
            this.p = p;
            this.e = e;
            this.nvps = nvps;
        }

        public FoldNG(ListVarPair numVars) {
            this(null, null, numVars);
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            if (this.p == null) {
                assert (this.e == null);
                D folded = state.foldNG(this.nvps);
                return folded;
            }
            assert (this.e != null);
            D folded = state.foldNG(this.p, this.e, this.nvps);
            return folded;
        }

        public String toString() {
            String addrTrans = this.p == null ? "" : this.p + "->" + this.e + " ";
            return "[fold " + addrTrans + "on " + this.nvps + "]";
        }
    }

    static class ExpandNG
    extends FiniteChildOp {
        private final NumVar.AddrVar p;
        private final NumVar.AddrVar e;
        private final ListVarPair nvps;

        protected ExpandNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
            this.p = p;
            this.e = e;
            this.nvps = nvps;
        }

        public ExpandNG(ListVarPair numVars) {
            this(null, null, numVars);
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            if (this.p == null) {
                assert (this.e == null);
                D expanded = state.expandNG(this.nvps);
                return expanded;
            }
            assert (this.e != null);
            D expanded = state.expandNG(this.p, this.e, this.nvps);
            return expanded;
        }

        public String toString() {
            String addrTrans = this.p == null ? "" : this.p + "->" + this.e + " ";
            return "[expand " + addrTrans + "on " + this.nvps + "]";
        }
    }

    static class AssumeEdgeNG
    extends FiniteChildOp {
        private final Finite.Rlin pointerVar;
        private final NumVar.AddrVar targetAddr;

        protected AssumeEdgeNG(Finite.Rlin pointerNumVar, NumVar.AddrVar address) {
            this.pointerVar = pointerNumVar;
            this.targetAddr = address;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.assumeEdgeNG(this.pointerVar, this.targetAddr);
        }

        public String toString() {
            return "[assumeEdge " + this.pointerVar + "->" + this.targetAddr + "]";
        }
    }

    static class Test
    extends FiniteChildOp {
        private final Finite.Test test;

        protected Test(Finite.Test test) {
            this.test = test;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.eval(this.test);
        }

        public String toString() {
            return "[" + this.test + "]";
        }
    }

    static class Subst
    extends FiniteChildOp {
        private final NumVar from;
        private final NumVar to;

        protected Subst(NumVar from, NumVar to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.substitute(this.from, this.to);
        }

        public String toString() {
            return "[" + this.from + "\\" + this.to + "]";
        }
    }

    static class CopyAndPaste<T extends FiniteDomain<T>>
    extends FiniteChildOp {
        VarSet variables;
        private final T otherState;

        protected CopyAndPaste(VarSet variables, T otherState) {
            this.variables = variables;
            this.otherState = otherState;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.copyAndPaste(this.variables, this.otherState);
        }

        public String toString() {
            return "copyAndPaste: " + this.variables;
        }
    }

    static class Hardcopy
    extends FiniteChildOp {
        private final NumVar to;
        private final NumVar from;

        protected Hardcopy(NumVar t, NumVar f) {
            this.to = t;
            this.from = f;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.copyVariable(this.to, this.from);
        }

        public String toString() {
            return "copy(" + this.to + "<-" + this.from + ")";
        }
    }

    static class Assignment
    extends FiniteChildOp {
        private final Finite.Assign stmt;

        protected Assignment(Finite.Assign stmt) {
            this.stmt = stmt;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.eval(this.stmt);
        }

        public String toString() {
            return this.stmt.toString();
        }
    }

    public static class Kill
    extends FiniteChildOp {
        private final NumVar victim;

        protected Kill(NumVar kill) {
            this.victim = kill;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.project(this.victim);
        }

        public String toString() {
            return "kill " + this.victim.toString();
        }

        @Override
        public Kill isKill() {
            return this;
        }

        public NumVar getVar() {
            return this.victim;
        }
    }

    static class Introduction
    extends FiniteChildOp {
        private final NumVar var;
        private final BigInt value;

        protected Introduction(NumVar var) {
            this(var, null);
        }

        protected Introduction(NumVar var, BigInt value) {
            this.var = var;
            this.value = value;
        }

        @Override
        public <D extends FiniteDomain<D>> D apply(D state) {
            return state.introduce(this.var, Type.Zeno, Option.fromNullable(this.value));
        }

        public String toString() {
            return "intro " + this.var.toString() + (this.value == null ? "" : " := " + this.value);
        }
    }
}

