/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.channels;

import bindead.data.Linear;
import bindead.data.VarSet;
import java.util.Iterator;
import javalx.data.Option;
import javalx.persistentcollections.AVLSet;

public class SetOfEquations
implements Iterable<Linear> {
    private static final SetOfEquations EMPTY = new SetOfEquations();
    private final AVLSet<Linear> equalities;

    private SetOfEquations() {
        this(AVLSet.empty());
    }

    private SetOfEquations(AVLSet<Linear> eqs) {
        this.equalities = eqs;
    }

    public static SetOfEquations empty() {
        return EMPTY;
    }

    public Option<Linear> getFirst() {
        return this.equalities.getMin();
    }

    public VarSet getVars() {
        VarSet vars = VarSet.empty();
        for (Linear eq : this) {
            vars = vars.union(eq.getVars());
        }
        return vars;
    }

    public SetOfEquations removeVariables(VarSet toRemove) {
        AVLSet<Linear> eqs = AVLSet.empty();
        for (Linear eq : this) {
            if (!eq.getVars().intersection(toRemove).isEmpty()) continue;
            eqs = eqs.add(eq);
        }
        return new SetOfEquations(eqs);
    }

    public SetOfEquations add(Linear equation) {
        return new SetOfEquations(this.equalities.add(equation));
    }

    public boolean isEmpty() {
        return this.equalities.isEmpty();
    }

    public SetOfEquations difference(SetOfEquations other) {
        return new SetOfEquations(this.equalities.difference(other.equalities));
    }

    public SetOfEquations union(SetOfEquations other) {
        return new SetOfEquations(this.equalities.union(other.equalities));
    }

    public SetOfEquations intersect(SetOfEquations other) {
        return new SetOfEquations(this.equalities.intersection(other.equalities));
    }

    @Override
    public Iterator<Linear> iterator() {
        return this.equalities.iterator();
    }

    public String toString() {
        return this.equalities.toString();
    }
}

