/*
 * Decompiled with CFR 0.152.
 */
package bindead.debug;

import bindead.debug.StringHelpers;
import bindead.debug.XmlToHtml;
import bindead.domainnetwork.interfaces.RootDomain;
import com.googlecode.jatl.Html;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlDomainStateParser {
    private final RootDomain<?> domain;
    private StateParserResult result;

    public XmlDomainStateParser(RootDomain<?> domain) {
        this.domain = domain;
    }

    private void init() {
        if (this.result == null) {
            this.result = XmlDomainStateParser.parse(this.domain.toXml());
        }
    }

    public RootDomain<?> getDomain() {
        return this.domain;
    }

    private static StateParserResult parse(String domain) {
        StateParserResult result = null;
        try {
            result = new StateParser().run(domain);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return result;
    }

    public String renderAsString() {
        return this.renderAsString(".*");
    }

    public String renderAsString(String regionsFilter) {
        return this.renderAsHtml(regionsFilter);
    }

    public String renderAsStringOldBroken(String regionsFilter) {
        this.init();
        StringBuilder output = new StringBuilder();
        for (Map.Entry category : this.result.valuesTables.entrySet()) {
            if (((Map)category.getValue()).isEmpty()) continue;
            for (Table table : ((Map)category.getValue()).values()) {
                String name = table.getName();
                if (!name.matches(regionsFilter)) continue;
                output.append(name);
                output.append("\n");
                table.asFormattedString(output, true);
                output.append("\n");
            }
            String separator = StringHelpers.repeatString("=", 80);
            output.append(separator);
            output.append("\n");
            output.append("\n");
        }
        for (Table table : this.result.auxilliaryTables.values()) {
            output.append(table.getName());
            output.append("\n");
            table.asFormattedString(output, true);
            output.append("\n");
        }
        String separator = StringHelpers.repeatString("*", 80);
        output.append(separator);
        output.append("\n");
        return output.toString();
    }

    public String renderAsHtml() {
        return this.renderAsHtml(".*");
    }

    public String renderAsHtml(String regionsFilter) {
        String htmlOutput = XmlToHtml.renderAsHtml(this.domain.toXml());
        return htmlOutput;
    }

    public String renderAsHtmlOldBroken(String regionsFilter) {
        this.init();
        StringWriter output = new StringWriter();
        Html html = (Html)new Html(output).html();
        html = (Html)((Html)((Html)html.head()).style()).attr("type", "text/css");
        html = (Html)html.text("body {font-size: small; font-family: sans serif; text-align: left;margin: auto 20px auto 20px;}");
        html = (Html)html.text("table {border-width: 0px;border-spacing: 0px;border-style: solid;border-color: black;border-collapse: collapse;background-color: white;}");
        html = (Html)html.text("th {border-width: 1px;padding: 3px;border-style: solid;border-color: gray;background-color: #B8CFE5;font-weight: normal;white-space:nowrap;}");
        html = (Html)html.text("td {border-width: 1px;padding: 3px;border-style: solid;border-color: gray;background-color: white;white-space:nowrap;}");
        html = (Html)html.end(2);
        html = (Html)html.body();
        for (Map.Entry category : this.result.valuesTables.entrySet()) {
            if (((Map)category.getValue()).isEmpty()) continue;
            for (Table table : ((Map)category.getValue()).values()) {
                String name = table.getName();
                if (!name.matches(regionsFilter)) continue;
                html = (Html)((Html)((Html)((Html)html.p()).b()).text(name)).end();
                html = table.asHtml(html);
                html = (Html)html.end();
            }
            html = (Html)((Html)((Html)html.br()).br()).hr();
        }
        for (Table table : this.result.auxilliaryTables.values()) {
            html = (Html)((Html)((Html)((Html)html.p()).b()).text(table.getName())).end();
            html = table.asHtml(html);
            html = (Html)html.end();
        }
        html = (Html)html.end(2);
        return output.toString();
    }

    private static String removeBraces(String string) {
        return string.substring(1, string.length() - 1);
    }

    private static class RReilFlagNamesSorter
    extends StringHelpers.ArrayOrderedStringsComparator {
        private static final String[] flags = new String[]{"CF", "BE", "LT", "LE", "ZF", "SF", "OF"};

        public RReilFlagNamesSorter() {
            super(flags);
        }
    }

    private static class X86RegisterNamesSorter
    extends StringHelpers.ArrayOrderedStringsComparator {
        private static final String[] registers = new String[]{"ah", "al", "ax", "eax", "rax", "bh", "bl", "bx", "ebx", "rbx", "ch", "cl", "cx", "ecx", "rcx", "dh", "dl", "dx", "edx", "rdx", "spl", "sp", "esp", "rsp", "bpl", "bp", "ebp", "rbp", "sil", "si", "esi", "rsi", "dil", "di", "edi", "rdi", "r8b", "r8w", "r8d", "r8", "r9b", "r9w", "r9d", "r9", "r10b", "r10w", "r10d", "r10", "r11b", "r11w", "r11d", "r11", "r12b", "r12w", "r12d", "r12", "r13b", "r13w", "r13d", "r13", "r14b", "r14w", "r14d", "r14", "r15b", "r15w", "r15d", "r15", "ip", "eip", "rip", "cs", "ds", "es", "fs", "gs", "ss"};

        public X86RegisterNamesSorter() {
            super(registers);
        }
    }

    private static class Columns {
        private final Map<String, Object> columns = new HashMap<String, Object>();

        private Columns() {
        }

        public void bind(String name, Object o) {
            this.columns.put(name, o);
        }

        public void bindToSet(String name, Object o) {
            Set values = (Set)this.columns.get(name);
            if (values == null) {
                values = new HashSet<Object>(){

                    @Override
                    public String toString() {
                        return XmlDomainStateParser.removeBraces(super.toString());
                    }
                };
            }
            values.add(o);
            this.columns.put(name, values);
        }

        public Object get(String column) {
            return this.columns.get(column);
        }

        public String toString() {
            return "Columns{columns=" + this.columns + '}';
        }
    }

    private static class Table {
        private final String name;
        private final List<String> columnNames = new ArrayList<String>();
        private final Map<String, Columns> rows = new LinkedHashMap<String, Columns>();

        public Table(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addColumn(String name) {
            this.columnNames.add(name);
        }

        public Columns getRow(String name) {
            Columns columns = this.rows.get(name);
            if (columns != null) {
                return columns;
            }
            columns = new Columns();
            this.rows.put(name, columns);
            return columns;
        }

        public boolean containsRow(String name) {
            return this.rows.containsKey(name);
        }

        public Set<String> getRowIds() {
            return this.rows.keySet();
        }

        public void bind(String row, String column, Object data) {
            this.getRow(row).bind(column, data);
        }

        public void bindToSet(String row, String column, Object data) {
            this.getRow(row).bindToSet(column, data);
        }

        public Html asHtml(Html html) {
            html = (Html)((Html)html.table()).tr();
            for (String colName : this.columnNames) {
                html = (Html)((Html)((Html)html.th()).text(colName)).end();
            }
            html = (Html)html.end();
            for (Columns columns : this.rows.values()) {
                html = (Html)html.tr();
                for (String columnName : this.columnNames) {
                    Object data = columns.get(columnName);
                    data = data != null ? data : "";
                    html = (Html)((Html)((Html)html.td()).text(data.toString())).end();
                }
                html = (Html)html.end();
            }
            return (Html)html.end();
        }

        public StringBuilder asFormattedString(StringBuilder builder) {
            return this.asFormattedString(builder, false);
        }

        public StringBuilder asFormattedString(StringBuilder builder, boolean cellsContentLeftAligned) {
            String[][] table = new String[this.rows.keySet().size() + 1][this.columnNames.size()];
            int rowIndex = 1;
            int columnIndex = 0;
            Iterator<Object> i$ = this.columnNames.iterator();
            while (i$.hasNext()) {
                String columnName;
                table[0][columnIndex] = columnName = i$.next();
                ++columnIndex;
            }
            columnIndex = 0;
            for (Columns columns : this.rows.values()) {
                for (String columnName : this.columnNames) {
                    Object data = columns.get(columnName);
                    data = data != null ? data : "";
                    table[rowIndex][columnIndex] = data.toString();
                    ++columnIndex;
                }
                ++rowIndex;
                columnIndex = 0;
            }
            StringHelpers.printFormattedTable(table, "\u2016", "\u2013", cellsContentLeftAligned, builder);
            return builder;
        }

        public String toString() {
            return this.asFormattedString(new StringBuilder(), true).toString();
        }
    }

    private static class StateParserResult {
        private final Map<String, Map<String, Table>> valuesTables = new LinkedHashMap<String, Map<String, Table>>();
        private final Map<String, Table> auxilliaryTables = new LinkedHashMap<String, Table>();
        private static final StringHelpers.ArrayOrderedStringsComparator flagSorter = new RReilFlagNamesSorter();
        private static final StringHelpers.ArrayOrderedStringsComparator registerSorter = new X86RegisterNamesSorter();

        public StateParserResult() {
            TreeMap registers = new TreeMap(registerSorter);
            TreeMap flags = new TreeMap(flagSorter);
            TreeMap temporaries = new TreeMap();
            TreeMap dataSections = new TreeMap();
            TreeMap rest = new TreeMap();
            this.valuesTables.put("registers", registers);
            this.valuesTables.put("temporaries", temporaries);
            this.valuesTables.put("rest", rest);
            this.valuesTables.put("dataSections", dataSections);
            this.valuesTables.put("flags", flags);
        }

        public Table createValueTable(String name) {
            Table t = new Table(name);
            if (registerSorter.containsString(name)) {
                this.valuesTables.get("registers").put(name, t);
            } else if (flagSorter.containsString(name)) {
                this.valuesTables.get("flags").put(name, t);
            } else if (name.startsWith("t")) {
                this.valuesTables.get("temporaries").put(name, t);
            } else if (name.startsWith(".")) {
                this.valuesTables.get("dataSections").put(name, t);
            } else {
                this.valuesTables.get("rest").put(name, t);
            }
            return t;
        }

        public Table createAuxilliaryTable(String name) {
            Table t = new Table(name);
            this.auxilliaryTables.put(name, t);
            return t;
        }

        public String toString() {
            return "StateParserResult{valuesTables=" + this.valuesTables + "auxilliaryTables=" + this.auxilliaryTables + '}';
        }
    }

    private static class StateParser {
        private final XPathFactory factory = XPathFactory.newInstance();
        private final XPath xPath = this.factory.newXPath();
        private XPathExpression queryRegions;
        private XPathExpression queryNameOfBinding;
        private XPathExpression queryKeyOfBinding;
        private XPathExpression queryValueOfBinding;
        private XPathExpression queryIntervalBindings;
        private XPathExpression queryIntervalDomain;
        private XPathExpression queryNarrowingDomain;
        private XPathExpression queryAffineDomain;
        private XPathExpression queryPointsToDomain;
        private XPathExpression querySymbolicAddresses;
        private XPathExpression queryIntervalValueOfBinding;
        private XPathExpression querySetValueOfBinding;
        private XPathExpression queryPredicatesDomain;
        private XPathExpression queryPredicateValueOfBinding;
        private XPathExpression queryLivenessDomain;
        private XPathExpression queryStripesDomain;
        private XPathExpression queryCongruencesDomain;
        private XPathExpression queryCongruencesValueOfBinding;
        private XPathExpression queryVariableName;

        public StateParser() throws XPathExpressionException {
            this.setupQueryExpressions();
        }

        private void setupQueryExpressions() throws XPathExpressionException {
            this.queryNameOfBinding = this.xPath.compile("Name/text()");
            this.queryKeyOfBinding = this.xPath.compile("Key/text()");
            this.queryVariableName = this.xPath.compile("Variable/text()");
            this.queryValueOfBinding = this.xPath.compile("Value/text()");
            this.querySetValueOfBinding = this.xPath.compile("Value/Set/text()");
            this.queryIntervalValueOfBinding = this.xPath.compile("Value/Interval/text()");
            this.queryCongruencesValueOfBinding = this.xPath.compile("Value/Congruence/text()");
            this.queryPredicateValueOfBinding = this.xPath.compile("Value/FiniteTest/text()");
            this.queryIntervalBindings = this.xPath.compile("IntervalTree/Binding");
            this.queryRegions = this.xPath.compile("//Memory[@name='FIELDS']/REGIONS/Region");
            this.queryCongruencesDomain = this.xPath.compile(StateParser.zeno("CONGRUENCES") + "/Binding");
            this.queryIntervalDomain = this.xPath.compile("INTERVALS/Entry");
            this.queryNarrowingDomain = this.xPath.compile(StateParser.zeno("THRESHOLDSWIDENING(OLD)") + "/Set");
            this.queryPredicatesDomain = this.xPath.compile(StateParser.finite("PREDICATES(F)") + "/Binding");
            this.queryAffineDomain = this.xPath.compile(StateParser.zeno("AFFINE") + "/Binding/Value/Linear/text()");
            this.queryStripesDomain = this.xPath.compile(StateParser.zeno("STRIPES") + "/Linear/text()");
        }

        private static String zeno(String name) {
            return "//Zeno[@name='" + name + "']";
        }

        private static String finite(String name) {
            return "//Finite[@name='" + name + "']";
        }

        public StateParserResult run(String xml) throws XPathExpressionException {
            StateParserResult result = new StateParserResult();
            NodeList affineTerms = (NodeList)this.queryAffineDomain.evaluate(StateParser.createInputSource(xml), XPathConstants.NODESET);
            NodeList stripesTerms = (NodeList)this.queryStripesDomain.evaluate(StateParser.createInputSource(xml), XPathConstants.NODESET);
            Map<String, String> pointsTo = this.getPointsToSets((NodeList)this.queryPointsToDomain.evaluate(StateParser.createInputSource(xml), XPathConstants.NODESET));
            Map<String, String> congruences = this.getMapping((NodeList)this.queryCongruencesDomain.evaluate(StateParser.createInputSource(xml), XPathConstants.NODESET), this.queryCongruencesValueOfBinding);
            Map<String, String> intervals = this.getMapping((NodeList)this.queryIntervalDomain.evaluate(StateParser.createInputSource(xml), XPathConstants.NODESET), this.queryIntervalValueOfBinding);
            Map<String, String> predicates = this.getMapping((NodeList)this.queryPredicatesDomain.evaluate(StateParser.createInputSource(xml), XPathConstants.NODESET), this.queryPredicateValueOfBinding);
            result = this.createVariableTables(xml, result, intervals, congruences, affineTerms, stripesTerms, pointsTo, predicates);
            result = this.createAuxilliaryTables(xml, result, intervals, congruences, affineTerms, stripesTerms);
            return result;
        }

        private StateParserResult createVariableTables(String xml, StateParserResult result, Map<String, String> intervals, Map<String, String> congruences, NodeList affineTerms, NodeList stripesTerms, Map<String, String> pointsToSets, Map<String, String> predicates) throws XPathExpressionException {
            Pattern pattern = Pattern.compile("\\((.*)\\)");
            NodeList regions = (NodeList)this.queryRegions.evaluate(StateParser.createInputSource(xml), XPathConstants.NODESET);
            for (int i = 0; i < regions.getLength(); ++i) {
                NodeList bindings;
                Node region = regions.item(i);
                String name = this.queryNameOfBinding.evaluate(region);
                if (name.trim().isEmpty() || (bindings = (NodeList)this.queryIntervalBindings.evaluate(region, XPathConstants.NODESET)).getLength() == 0) continue;
                Table table = result.createValueTable(name);
                table.addColumn("Name");
                table.addColumn("Range");
                for (int j = 0; j < bindings.getLength(); ++j) {
                    Node kv = bindings.item(j);
                    String key = this.queryKeyOfBinding.evaluate(kv);
                    String value = this.queryValueOfBinding.evaluate(kv);
                    String columnID = value.split(":")[0];
                    Matcher matcher = pattern.matcher(value);
                    matcher.find();
                    String variableName = matcher.group(1);
                    table.bind(columnID, "Name", variableName);
                    table.bind(columnID, "Range", StateParser.prettyPrintInterval(key));
                }
                StateParser.fillIntervalsColumn(table, intervals);
                StateParser.fillCongruencesColumn(table, congruences);
                StateParser.fillAffineColumn(table, affineTerms);
                StateParser.fillStripesColumn(table, stripesTerms);
                StateParser.fillPointsToColumn(table, pointsToSets);
                StateParser.fillPredicatesColumn(table, predicates);
            }
            return result;
        }

        private StateParserResult createAuxilliaryTables(String xml, StateParserResult result, Map<String, String> intervals, Map<String, String> congruences, NodeList affineTerms, NodeList stripesTerms) throws XPathExpressionException {
            String liveVariables;
            String narrowing;
            String symbolicAddresses = (String)this.querySymbolicAddresses.evaluate(StateParser.createInputSource(xml), XPathConstants.STRING);
            if (!symbolicAddresses.trim().isEmpty()) {
                symbolicAddresses = XmlDomainStateParser.removeBraces(symbolicAddresses);
                String[] addresses = symbolicAddresses.split(", ");
                Table symbolicTable = result.createAuxilliaryTable("Symbolic Addresses");
                symbolicTable.addColumn("Name");
                for (String address : addresses) {
                    symbolicTable.bind(address, "Name", address);
                }
                StateParser.fillIntervalsColumn(symbolicTable, intervals);
                StateParser.fillCongruencesColumn(symbolicTable, congruences);
                StateParser.fillAffineColumn(symbolicTable, affineTerms);
                StateParser.fillStripesColumn(symbolicTable, stripesTerms);
            }
            if (!(narrowing = (String)this.queryNarrowingDomain.evaluate(StateParser.createInputSource(xml), XPathConstants.STRING)).trim().isEmpty()) {
                narrowing = XmlDomainStateParser.removeBraces(narrowing);
                String[] predicates = narrowing.split(", ");
                Table narrowingTable = result.createAuxilliaryTable("Narrowing");
                narrowingTable.addColumn("Predicate");
                for (String predicate : predicates) {
                    narrowingTable.bind(predicate, "Predicate", predicate);
                }
            }
            if (!(liveVariables = (String)this.queryLivenessDomain.evaluate(StateParser.createInputSource(xml), XPathConstants.STRING)).trim().isEmpty()) {
                Table liveVariablesTable = result.createAuxilliaryTable("Live Variables");
                liveVariablesTable.addColumn("Variables");
                liveVariablesTable.bind("", "Variables", liveVariables);
            }
            return result;
        }

        private Map<String, String> getMapping(NodeList keysAndValues, XPathExpression valueQuery) throws XPathExpressionException {
            HashMap<String, String> mapping = new HashMap<String, String>();
            for (int i = 0; i < keysAndValues.getLength(); ++i) {
                Node kv = keysAndValues.item(i);
                String key = this.queryVariableName.evaluate(kv);
                String value = valueQuery.evaluate(kv);
                mapping.put(key, value);
            }
            return mapping;
        }

        private Map<String, String> getPointsToSets(NodeList pointsToSet) throws XPathExpressionException {
            HashMap<String, String> pointsToSetsMap = new HashMap<String, String>();
            for (int i = 0; i < pointsToSet.getLength(); ++i) {
                Node kv = pointsToSet.item(i);
                String key = this.queryKeyOfBinding.evaluate(kv);
                String value = XmlDomainStateParser.removeBraces(this.querySetValueOfBinding.evaluate(kv));
                pointsToSetsMap.put(key, value);
            }
            return pointsToSetsMap;
        }

        private static void fillValueColumn(Table table, String columnName, Map<String, String> variableValues) throws XPathExpressionException {
            table.addColumn(columnName);
            for (String variable : table.getRowIds()) {
                if (!variableValues.containsKey(variable)) continue;
                table.bind(variable, columnName, variableValues.get(variable));
            }
        }

        private static void fillValueSetColumn(Table table, String columnName, NodeList linearTerms) {
            table.addColumn(columnName);
            for (String variable : table.getRowIds()) {
                for (int i = 0; i < linearTerms.getLength(); ++i) {
                    String linear = linearTerms.item(i).getNodeValue();
                    if (!linear.contains(variable)) continue;
                    table.bindToSet(variable, columnName, linear);
                }
            }
        }

        private static void fillCongruencesColumn(Table table, Map<String, String> congruences) throws XPathExpressionException {
            StateParser.fillValueColumn(table, "Congruence", congruences);
        }

        private static void fillIntervalsColumn(Table table, Map<String, String> intervals) throws XPathExpressionException {
            StateParser.fillValueColumn(table, "Interval", intervals);
        }

        private static void fillPredicatesColumn(Table table, Map<String, String> predicates) throws XPathExpressionException {
            StateParser.fillValueColumn(table, "Predicate", predicates);
        }

        private static void fillPointsToColumn(Table table, Map<String, String> pointsToSets) throws XPathExpressionException {
            StateParser.fillValueColumn(table, "Points to", pointsToSets);
        }

        private static void fillAffineColumn(Table table, NodeList linearTerms) {
            StateParser.fillValueSetColumn(table, "Affine", linearTerms);
        }

        private static void fillStripesColumn(Table table, NodeList linearTerms) {
            StateParser.fillValueSetColumn(table, "Stripes", linearTerms);
        }

        private static InputSource createInputSource(String xml) {
            return new InputSource(new StringReader(xml));
        }

        private static String prettyPrintInterval(String value) {
            value = XmlDomainStateParser.removeBraces(value);
            value = value.replaceFirst(", ", "-");
            return value;
        }
    }
}

