/*
 * Decompiled with CFR 0.152.
 */
package bindead.debug;

import bindead.abstractsyntax.finite.Finite;
import bindead.data.Linear;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.domains.pointsto.PointsToSet;
import bindead.environment.platform.Platform;
import java.util.NoSuchElementException;
import javalx.numeric.Range;
import rreil.lang.MemVar;
import rreil.lang.Rhs;

public class DomainQueryHelpers {
    public static <D extends RootDomain<D>> Rhs.Rvar resolveVariable(String variableName, D domain, Platform platform) {
        Rhs.Rvar variable = DomainQueryHelpers.resolvePlatformRegister(variableName, platform);
        if (variable == null) {
            variable = DomainQueryHelpers.resolveTemporaryRegister(variableName, domain, platform.defaultArchitectureSize());
        }
        return variable;
    }

    private static Rhs.Rvar resolvePlatformRegister(String variableName, Platform platform) {
        Rhs.Rvar variable = null;
        try {
            variable = platform.getRegisterAsVariable(variableName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return variable;
    }

    private static <D extends RootDomain<D>> Rhs.Rvar resolveTemporaryRegister(String variableName, D domain, int defaultSize) {
        int[] possibleRegisterSizes;
        MemVar regionId = MemVar.getVarOrNull(variableName);
        if (regionId == null) {
            return null;
        }
        Rhs.Rvar variable = null;
        for (int size : possibleRegisterSizes = new int[]{defaultSize, 128, 64, 32, 16, 8, 1}) {
            variable = new Rhs.Rvar(size, 0, regionId);
            try {
                if (domain.getDebugChannel().resolve(variable) == null) continue;
                return variable;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        return variable;
    }

    public static <D extends RootDomain<D>> Range queryRange(String variableName, D domain, Platform platform) {
        Rhs.Rvar variable = DomainQueryHelpers.resolveVariable(variableName, domain, platform);
        if (variable == null) {
            return null;
        }
        return DomainQueryHelpers.queryRange(variable, domain);
    }

    public static <D extends RootDomain<D>> Range queryRange(String pointerName, int offset, int sizeInBits, D domain, Platform platform) {
        Rhs.Rvar variable = DomainQueryHelpers.resolveVariable(pointerName, domain, platform);
        if (variable == null) {
            return null;
        }
        String tempReg1 = "treg1";
        String addOffset = String.format("add.%d %s, %s, %d", variable.getSize(), tempReg1, pointerName, offset);
        String tempReg2 = "treg2";
        String load = String.format("load.%d.%d %s, %s", sizeInBits, variable.getSize(), tempReg2, tempReg1);
        RootDomain resultDomain = (RootDomain)domain.eval(addOffset, load);
        Rhs.Rvar resultVariable = DomainQueryHelpers.resolveTemporaryRegister(tempReg2, resultDomain, platform.defaultArchitectureSize());
        if (resultVariable == null) {
            return null;
        }
        return DomainQueryHelpers.queryRange(resultVariable, domain);
    }

    public static <D extends RootDomain<D>> Range queryRange(Rhs.Rvar variable, D domainState) {
        try {
            return domainState.queryRange(variable);
        }
        catch (AssertionError | Exception e) {
            return null;
        }
    }

    public static <D extends RootDomain<D>> SetOfEquations queryEqualities(Rhs.Rvar variable, D domainState) {
        Finite.Rlin resolvedVariable = null;
        try {
            resolvedVariable = domainState.getDebugChannel().resolve(variable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resolvedVariable == null) {
            return null;
        }
        try {
            return domainState.queryEqualities(resolvedVariable.getLinearTerm().getKey());
        }
        catch (AssertionError | Exception e) {
            return null;
        }
    }

    public static <D extends RootDomain<D>> PointsToSet queryPointsToSet(Rhs.Rvar variable, D domainState) {
        Finite.Rlin resolvedVariable = null;
        try {
            resolvedVariable = domainState.getDebugChannel().resolve(variable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resolvedVariable == null) {
            return null;
        }
        try {
            return domainState.getDebugChannel().queryPointsToSet(resolvedVariable.getLinearTerm().getKey());
        }
        catch (AssertionError | Exception e) {
            return null;
        }
    }

    public static String formatLinearEqualities(SetOfEquations equalities) {
        StringBuilder builder = new StringBuilder();
        for (Linear linear : equalities) {
            builder.append(linear.toEquationString());
            builder.append(", ");
        }
        if (!equalities.isEmpty()) {
            builder.setLength(builder.length() - 2);
        }
        return builder.toString();
    }
}

