/*
 * Decompiled with CFR 0.152.
 */
package bindead.debug;

import bindead.analyses.Analysis;
import bindead.analyses.AnalysisFactory;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.NumVar;
import bindead.debug.DomainPrintProperties;
import bindead.debug.DomainQueryHelpers;
import bindead.debug.DomainStringBuilder;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.domains.affine.AffineProperties;
import bindead.domains.congruences.CongruenceProperties;
import bindead.domains.gauge.GaugeProperties;
import bindead.domains.intervals.IntervalProperties;
import bindead.domains.pointsto.PointsToSet;
import bindead.domains.widening.delayed.DelayedWideningProperties;
import bindead.domains.widening.thresholds.ThresholdsWideningProperties;
import bindis.gdsl.GdslNativeDisassembler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javalx.data.products.P3;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RvarExtractor;

public class DebugHelper {
    private static boolean printLogMessages = false;
    private static PrintStream printer = System.out;
    public static final DebugKnobs analysisKnobs = new DebugKnobs();
    public static final DebugPrinters printers = new DebugPrinters();
    public static final DebugBreakpoints breakpoints = new DebugBreakpoints();
    private static PrintStream originalOutPrintStream;
    private static final PrintStream nullPrintStream;

    public static void noopBreakpointFunction() {
    }

    public static void muteSystemOut() {
        originalOutPrintStream = System.out;
        System.setOut(nullPrintStream);
    }

    public static void unmuteSystemOut() {
        if (originalOutPrintStream != null) {
            System.setOut(originalOutPrintStream);
        }
    }

    public static void log(Object ... obj) {
        if (printLogMessages) {
            for (Object o : obj) {
                printer.print(o);
            }
        }
    }

    public static void logln(Object ... obj) {
        if (printLogMessages) {
            DebugHelper.log(obj);
            printer.println();
        }
    }

    public static AnalysisFactory.AnalysisDebugHooks combine(final AnalysisFactory.AnalysisDebugHooks ... hooks) {
        return new AnalysisFactory.AnalysisDebugHooks(){

            @Override
            public <D extends RootDomain<D>> void beforeEval(RReil insn, ProgramPoint ctx, D domainState, Analysis<D> analysis) {
                for (AnalysisFactory.AnalysisDebugHooks hook : hooks) {
                    if (hook == null) continue;
                    hook.beforeEval(insn, ctx, domainState, analysis);
                }
            }

            @Override
            public <D extends RootDomain<D>> void afterEval(RReil insn, ProgramPoint ctx, RReilAddr target, D domainState, Analysis<D> analysis) {
                for (AnalysisFactory.AnalysisDebugHooks hook : hooks) {
                    if (hook == null) continue;
                    hook.afterEval(insn, ctx, target, domainState, analysis);
                }
            }
        };
    }

    static {
        nullPrintStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
    }

    public static class DebugPrinters {
        private static String indentForDomains = StringHelpers.repeatString(" ", 15);
        private static String indentForValues = StringHelpers.repeatString(" ", 30);

        private static final WatcherAction<Interval> printValueAction(final boolean onChangeOnly) {
            return new WatcherAction<Interval>(){

                @Override
                public <D extends RootDomain<D>> void valueUnchanged(String variableName, Interval value, D domainState) {
                    if (!onChangeOnly) {
                        printer.printf("  %s = %s", variableName, value);
                    }
                }

                @Override
                public <D extends RootDomain<D>> void valueChanged(String variableName, Interval oldValue, Interval newValue, D domainState) {
                    printer.printf("  %s = %s", variableName, newValue);
                }
            };
        }

        private static final WatcherAction<SetOfEquations> printEqualitiesAction(final boolean onChangeOnly) {
            return new WatcherAction<SetOfEquations>(){

                @Override
                public <D extends RootDomain<D>> void valueUnchanged(String variableName, SetOfEquations value, D domainState) {
                    if (!onChangeOnly) {
                        printer.printf(" eqs: %s", DomainQueryHelpers.formatLinearEqualities(value));
                    }
                }

                @Override
                public <D extends RootDomain<D>> void valueChanged(String variableName, SetOfEquations oldValue, SetOfEquations newValue, D domainState) {
                    printer.printf(" eqs: %s", DomainQueryHelpers.formatLinearEqualities(newValue));
                }
            };
        }

        private static AnalysisFactory.AnalysisDebugHooks dumpDomainBeforeEval() {
            return new DebugHooksSkeleton(){

                @Override
                public <D extends RootDomain<D>> void beforeEval(RReil insn, ProgramPoint point, D domainState, Analysis<D> analysis) {
                    printer.println();
                    printer.println(StringHelpers.indentMultiline(indentForDomains + "@ " + point.getAddress() + ": ", domainState.toString()));
                    printer.println();
                }
            };
        }

        private static AnalysisFactory.AnalysisDebugHooks dumpDomainAfterEval() {
            return new DebugHooksSkeleton(){

                @Override
                public <D extends RootDomain<D>> void afterEval(RReil insn, ProgramPoint point, RReilAddr target, D domainState, Analysis<D> analysis) {
                    printer.println();
                    printer.println(StringHelpers.indentMultiline(indentForDomains + "@ " + point.getAddress() + " -> " + target + ": ", domainState.toString()));
                    printer.println();
                }
            };
        }

        private static AnalysisFactory.AnalysisDebugHooks dumpDomainFilteredBeforeEval(final String ... domainsToShow) {
            return new DebugHooksSkeleton(){

                @Override
                public <D extends RootDomain<D>> void beforeEval(RReil insn, ProgramPoint point, D domainState, Analysis<D> analysis) {
                    PrintStream outStream = printer;
                    String indentationString = indentForDomains + "@ " + point.getAddress() + ": ";
                    this.printOut(domainState, outStream, indentationString, domainsToShow);
                }

                private <D extends RootDomain<D>> void printOut(D domainState, PrintStream outStream, String indentationString, String ... domainsToShow2) {
                    DomainStringBuilder builder = new DomainStringBuilder();
                    domainState.toString(builder);
                    outStream.println();
                    outStream.println(StringHelpers.indentMultiline(indentationString, builder.toFilteredString(domainsToShow2).toString()));
                    outStream.println();
                }
            };
        }

        public AnalysisFactory.AnalysisDebugHooks instructionEffect() {
            return this.instructionEffect(null, null);
        }

        public AnalysisFactory.AnalysisDebugHooks instructionEffect(RReilAddr enableAddress, RReilAddr disableAddress) {
            ArrayList<AnalysisFactory.AnalysisDebugHooks> watchers = new ArrayList<AnalysisFactory.AnalysisDebugHooks>();
            watchers.add(new InstructionVariablesPrinter());
            return new AddressRangeDebugger(watchers, enableAddress, disableAddress, false);
        }

        public AnalysisFactory.AnalysisDebugHooks variablesDump(RReilAddr enableAddress, RReilAddr disableAddress, String ... variableNames) {
            ArrayList<AnalysisFactory.AnalysisDebugHooks> watchers = new ArrayList<AnalysisFactory.AnalysisDebugHooks>();
            for (String variable : variableNames) {
                watchers.add(new VariableWatcher(variable, false));
            }
            return new AddressRangeDebugger(watchers, enableAddress, disableAddress, false);
        }

        public AnalysisFactory.AnalysisDebugHooks variablesWatcher(RReilAddr enableAddress, RReilAddr disableAddress, String ... variableNames) {
            ArrayList<AnalysisFactory.AnalysisDebugHooks> watchers = new ArrayList<AnalysisFactory.AnalysisDebugHooks>();
            for (String variable : variableNames) {
                watchers.add(new VariableWatcher(variable, true));
            }
            return new AddressRangeDebugger(watchers, enableAddress, disableAddress, false);
        }

        public AnalysisFactory.AnalysisDebugHooks memoryWatcher(RReilAddr enableAddress, RReilAddr disableAddress, P3<String, Integer, Integer> ... memoryLocations) {
            ArrayList<AnalysisFactory.AnalysisDebugHooks> watchers = new ArrayList<AnalysisFactory.AnalysisDebugHooks>();
            for (P3<String, Integer, Integer> tripel : memoryLocations) {
                String pointerName = tripel._1();
                Integer offset = tripel._2();
                Integer accessSize = tripel._3();
                watchers.add(new MemoryVariableValueWatcher(pointerName, offset, accessSize, DebugPrinters.printValueAction(true)));
            }
            return new AddressRangeDebugger(watchers, enableAddress, disableAddress, false);
        }

        public AnalysisFactory.AnalysisDebugHooks domainDump() {
            return this.domainDump(null, null);
        }

        public AnalysisFactory.AnalysisDebugHooks domainDumpBoth() {
            return new AddressRangeDebugger(Arrays.asList(DebugPrinters.dumpDomainBeforeEval(), DebugPrinters.dumpDomainAfterEval()), null, null, false);
        }

        public AnalysisFactory.AnalysisDebugHooks domainDump(RReilAddr enableAddress, RReilAddr disableAddress) {
            return new AddressRangeDebugger(Arrays.asList(DebugPrinters.dumpDomainBeforeEval()), enableAddress, disableAddress, false);
        }

        public AnalysisFactory.AnalysisDebugHooks domainDumpFiltered(String ... domainsToShow) {
            return this.domainDumpFiltered((RReilAddr)null, (RReilAddr)null, domainsToShow);
        }

        public AnalysisFactory.AnalysisDebugHooks domainDumpFiltered(RReilAddr enableAddress, RReilAddr disableAddress, String ... domainsToShow) {
            return new AddressRangeDebugger(Arrays.asList(DebugPrinters.dumpDomainFilteredBeforeEval(domainsToShow)), enableAddress, disableAddress, false);
        }

        private static class AddressRangeDebugger
        implements AnalysisFactory.AnalysisDebugHooks {
            boolean enabled = false;
            boolean disabled = false;
            private final List<AnalysisFactory.AnalysisDebugHooks> callbacks;
            private final RReilAddr enableAddress;
            private final RReilAddr disableAddress;
            private final boolean onceOnly;

            public AddressRangeDebugger(List<AnalysisFactory.AnalysisDebugHooks> callbacks, RReilAddr enableAddress, RReilAddr disableAddress, boolean onceOnly) {
                this.callbacks = callbacks;
                this.enableAddress = enableAddress;
                this.disableAddress = disableAddress;
                this.onceOnly = onceOnly;
            }

            @Override
            public <D extends RootDomain<D>> void beforeEval(RReil insn, ProgramPoint ctx, D domainState, Analysis<D> analysis) {
                if (this.onceOnly && this.disabled) {
                    return;
                }
                RReilAddr currentAddress = insn.getRReilAddress();
                if (!this.enabled) {
                    this.tryTransitionToEnabledState(currentAddress);
                }
                if (this.enabled) {
                    this.executeBeforeCallbacks(insn, ctx, domainState, analysis);
                }
            }

            @Override
            public <D extends RootDomain<D>> void afterEval(RReil insn, ProgramPoint point, RReilAddr target, D domainState, Analysis<D> analysis) {
                if (this.onceOnly && this.disabled) {
                    return;
                }
                RReilAddr currentAddress = insn.getRReilAddress();
                if (this.enabled) {
                    this.executeAfterCallbacks(insn, point, target, domainState, analysis);
                    this.tryTransitionToDisabledState(currentAddress);
                }
            }

            private void tryTransitionToEnabledState(RReilAddr currentAddress) {
                this.enabled = AddressRangeDebugger.isEnableTrigger(currentAddress, this.enableAddress);
            }

            private void tryTransitionToDisabledState(RReilAddr currentAddress) {
                this.disabled = AddressRangeDebugger.isDisableTrigger(currentAddress, this.disableAddress);
                if (this.disabled) {
                    this.enabled = false;
                }
            }

            private <D extends RootDomain<D>> void executeBeforeCallbacks(RReil insn, ProgramPoint ctx, D domainState, Analysis<D> analysis) {
                for (AnalysisFactory.AnalysisDebugHooks callback : this.callbacks) {
                    callback.beforeEval(insn, ctx, domainState, analysis);
                }
            }

            private <D extends RootDomain<D>> void executeAfterCallbacks(RReil insn, ProgramPoint ctx, RReilAddr target, D domainState, Analysis<D> analysis) {
                for (AnalysisFactory.AnalysisDebugHooks callback : this.callbacks) {
                    callback.afterEval(insn, ctx, target, domainState, analysis);
                }
            }

            private static boolean isDisableTrigger(RReilAddr currentAddress, RReilAddr disableAddress) {
                if (disableAddress == null) {
                    return false;
                }
                return currentAddress.equals(disableAddress);
            }

            private static boolean isEnableTrigger(RReilAddr currentAddress, RReilAddr enableAddress) {
                if (enableAddress == null) {
                    return true;
                }
                return currentAddress.equals(enableAddress);
            }
        }

        private static class MemoryVariableValueWatcher
        extends DebugHooksSkeleton {
            private final String pointerName;
            private final WatcherAction<Interval> actions;
            private final int offset;
            private final int sizeInBits;
            private Interval oldValue = null;

            public MemoryVariableValueWatcher(String pointerName, int offset, int sizeInBits, WatcherAction<Interval> actions) {
                this.pointerName = pointerName;
                this.offset = offset;
                this.sizeInBits = sizeInBits;
                this.actions = actions;
            }

            @Override
            public <D extends RootDomain<D>> void beforeEval(RReil insn, ProgramPoint ctx, D domainState, Analysis<D> analysis) {
                this.watchMemory(domainState, analysis);
            }

            @Override
            public <D extends RootDomain<D>> void afterEval(RReil insn, ProgramPoint point, RReilAddr target, D domainState, Analysis<D> analysis) {
                this.watchMemory(domainState, analysis);
            }

            private <D extends RootDomain<D>> void watchMemory(D domainState, Analysis<D> analysis) {
                Range range = DomainQueryHelpers.queryRange(this.pointerName, this.offset, this.sizeInBits, domainState, analysis.getPlatform());
                if (range == null) {
                    return;
                }
                Interval newValue = range.convexHull();
                String operator = "";
                if (this.offset > 0) {
                    operator = "+";
                }
                String locationName = "[" + this.pointerName + operator + this.offset + "]";
                if (!newValue.equals(this.oldValue)) {
                    this.actions.valueChanged(locationName, this.oldValue, newValue, domainState);
                    this.oldValue = newValue;
                } else {
                    this.actions.valueUnchanged(locationName, newValue, domainState);
                }
            }
        }

        private static class VariableWatcher
        extends DebugHooksSkeleton {
            private SetOfEquations oldEqualities = null;
            private Interval oldValue = null;
            private final String variableName;
            private final WatcherAction<SetOfEquations> equalitiesAction;
            private final WatcherAction<Interval> valueAction;

            public VariableWatcher(String variableName, boolean onChangeOnly) {
                this.variableName = variableName;
                this.valueAction = DebugPrinters.printValueAction(onChangeOnly);
                this.equalitiesAction = DebugPrinters.printEqualitiesAction(onChangeOnly);
            }

            @Override
            public <D extends RootDomain<D>> void beforeEval(RReil insn, ProgramPoint ctx, D domainState, Analysis<D> analysis) {
                this.watchValue(domainState, analysis);
                this.watchEqualities(domainState, analysis);
                printer.println();
            }

            @Override
            public <D extends RootDomain<D>> void afterEval(RReil insn, ProgramPoint point, RReilAddr target, D domainState, Analysis<D> analysis) {
                this.watchValue(domainState, analysis);
                this.watchEqualities(domainState, analysis);
                printer.println();
            }

            private <D extends RootDomain<D>> void watchValue(D domainState, Analysis<D> analysis) {
                Range range = DomainQueryHelpers.queryRange(this.variableName, domainState, analysis.getPlatform());
                if (range == null) {
                    return;
                }
                Interval newValue = range.convexHull();
                if (!newValue.equals(this.oldValue)) {
                    this.valueAction.valueChanged(this.variableName, this.oldValue, newValue, domainState);
                    this.oldValue = newValue;
                } else {
                    this.valueAction.valueUnchanged(this.variableName, newValue, domainState);
                }
            }

            private <D extends RootDomain<D>> void watchEqualities(D domainState, Analysis<D> analysis) {
                Rhs.Rvar variable = DomainQueryHelpers.resolveVariable(this.variableName, domainState, analysis.getPlatform());
                if (variable == null) {
                    return;
                }
                SetOfEquations newValue = DomainQueryHelpers.queryEqualities(variable, domainState);
                if (newValue == null) {
                    return;
                }
                if (this.oldEqualities == null) {
                    this.equalitiesAction.valueChanged(this.variableName, this.oldEqualities, newValue, domainState);
                    this.oldEqualities = newValue;
                } else if (!newValue.difference(this.oldEqualities).isEmpty()) {
                    this.equalitiesAction.valueChanged(this.variableName, this.oldEqualities, newValue, domainState);
                    this.oldEqualities = newValue;
                } else {
                    this.equalitiesAction.valueUnchanged(this.variableName, newValue, domainState);
                }
            }
        }

        private static class InstructionVariablesPrinter
        extends DebugHooksSkeleton {
            private InstructionVariablesPrinter() {
            }

            @Override
            public <D extends RootDomain<D>> void beforeEval(RReil insn, ProgramPoint point, D domainState, Analysis<D> analysis) {
                List<Rhs.Rvar> variables = RvarExtractor.getRhs(insn);
                InstructionVariablesPrinter.printValues(domainState, variables);
            }

            @Override
            public <D extends RootDomain<D>> void afterEval(RReil insn, ProgramPoint point, RReilAddr target, D domainState, Analysis<D> analysis) {
                List<Rhs.Rvar> variables = RvarExtractor.getLhs(insn);
                InstructionVariablesPrinter.printValues(domainState, variables);
            }

            private static <D extends RootDomain<D>> void printValues(D domainState, List<Rhs.Rvar> variables) {
                if (!variables.isEmpty()) {
                    printer.print(indentForValues);
                }
                for (Rhs.Rvar variable : variables) {
                    Range value = DomainQueryHelpers.queryRange(variable, domainState);
                    SetOfEquations equalities = DomainQueryHelpers.queryEqualities(variable, domainState);
                    PointsToSet pointsTo = DomainQueryHelpers.queryPointsToSet(variable, domainState);
                    if (value == null) continue;
                    printer.printf("%s = %s", variable.getRegionId(), value);
                    if (equalities != null && !equalities.isEmpty()) {
                        printer.print("\t");
                        printer.printf("eqs: %s", DomainQueryHelpers.formatLinearEqualities(equalities));
                    }
                    if (pointsTo != null) {
                        printer.print("\t");
                        printer.printf("pts: %s", pointsTo);
                    }
                    printer.print("\t");
                }
                if (!variables.isEmpty()) {
                    printer.println();
                }
            }
        }

        private static interface WatcherAction<T> {
            public <D extends RootDomain<D>> void valueUnchanged(String var1, T var2, D var3);

            public <D extends RootDomain<D>> void valueChanged(String var1, T var2, T var3, D var4);
        }
    }

    public static class DebugKnobs {
        public void printCompactDomain() {
            DomainPrintProperties.INSTANCE.printCompact.setValue(true);
        }

        public void printFullDomain() {
            DomainPrintProperties.INSTANCE.printCompact.setValue(false);
        }

        public void printInstructions() {
            AnalysisProperties.INSTANCE.debugAssignments.setValue(true);
        }

        public void printSummary() {
            AnalysisProperties.INSTANCE.debugSummary.setValue(true);
        }

        public void printWarnings() {
            AnalysisProperties.INSTANCE.debugWarnings.setValue(true);
        }

        public void printLogging() {
            printLogMessages = true;
        }

        public void printCodeListing() {
            this.printRReilCodeListing();
            this.printNativeCodeListing();
        }

        public void printRReilCodeListing() {
            AnalysisProperties.INSTANCE.debugRReilCode.setValue(true);
        }

        public void printNativeCodeListing() {
            AnalysisProperties.INSTANCE.debugNativeCode.setValue(true);
        }

        public void printSubsetOrEqual() {
            AnalysisProperties.INSTANCE.debugSubsetOrEqual.setValue(true);
        }

        public void printWidening() {
            AnalysisProperties.INSTANCE.debugWidening.setValue(true);
            ThresholdsWideningProperties.INSTANCE.debugWidening.setValue(true);
            DelayedWideningProperties.INSTANCE.debugWidening.setValue(true);
            IntervalProperties.INSTANCE.debugWidening.setValue(true);
        }

        public void printMemVarOnly() {
            NumVar.printMemVarOnly(true);
        }

        public void printNumVarOnly() {
            NumVar.printNumVarOnly(true);
        }

        public void printMemVarAndNumVar() {
            NumVar.printMemVarOnly(false);
            NumVar.printNumVarOnly(false);
        }

        public void useGDSLasFrontend() {
            AnalysisProperties.INSTANCE.useGDSLDisassembler.setValue(true);
            AnalysisProperties.INSTANCE.disassembleBlockWise.setValue(false);
            GdslNativeDisassembler.disableOptimizations();
        }

        public void useGDSLasFrontendAndOptimize() {
            AnalysisProperties.INSTANCE.useGDSLDisassembler.setValue(true);
            AnalysisProperties.INSTANCE.disassembleBlockWise.setValue(true);
            GdslNativeDisassembler.enableOptimizations();
        }

        public void useLegacyFrontend() {
            AnalysisProperties.INSTANCE.useGDSLDisassembler.setValue(false);
            AnalysisProperties.INSTANCE.disassembleBlockWise.setValue(false);
            GdslNativeDisassembler.disableOptimizations();
        }

        public void enableCommon() {
            this.printLogging();
            this.printCodeListing();
            this.printInstructions();
            this.printWarnings();
            this.printSummary();
        }

        public void disableAll() {
            AnalysisProperties.INSTANCE.disableAllDebugSwitches();
            AnalysisProperties.INSTANCE.debugNativeCode.setValue(false);
            AnalysisProperties.INSTANCE.debugRReilCode.setValue(false);
            AnalysisProperties.INSTANCE.debugWarnings.setValue(false);
            AffineProperties.INSTANCE.disableAllDebugSwitches();
            IntervalProperties.INSTANCE.disableAllDebugSwitches();
            GaugeProperties.INSTANCE.disableAllDebugSwitches();
            CongruenceProperties.INSTANCE.disableAllDebugSwitches();
            ThresholdsWideningProperties.INSTANCE.disableAllDebugSwitches();
            DelayedWideningProperties.INSTANCE.disableAllDebugSwitches();
            this.printMemVarAndNumVar();
            this.printFullDomain();
            printLogMessages = false;
        }
    }

    public static class DebugBreakpoints {
        public AnalysisFactory.AnalysisDebugHooks triggerBeforeInsn(String address) {
            final RReilAddr addressValue = RReilAddr.valueOf(address);
            return new DebugHooksSkeleton(){

                @Override
                public <D extends RootDomain<D>> void beforeEval(RReil insn, ProgramPoint point, D domainState, Analysis<D> analysis) {
                    if (insn.getRReilAddress().equals(addressValue)) {
                        DebugHelper.noopBreakpointFunction();
                    }
                }
            };
        }

        public AnalysisFactory.AnalysisDebugHooks triggerAfterInsn(String address) {
            final RReilAddr addressValue = RReilAddr.valueOf(address);
            return new DebugHooksSkeleton(){

                @Override
                public <D extends RootDomain<D>> void afterEval(RReil insn, ProgramPoint point, RReilAddr target, D domainState, Analysis<D> analysis) {
                    if (insn.getRReilAddress().equals(addressValue)) {
                        DebugHelper.noopBreakpointFunction();
                    }
                }
            };
        }
    }

    private static abstract class DebugHooksSkeleton
    implements AnalysisFactory.AnalysisDebugHooks {
        private DebugHooksSkeleton() {
        }

        @Override
        public <D extends RootDomain<D>> void beforeEval(RReil insn, ProgramPoint point, D domainState, Analysis<D> analysis) {
        }

        @Override
        public <D extends RootDomain<D>> void afterEval(RReil insn, ProgramPoint point, RReilAddr target, D domainState, Analysis<D> analysis) {
        }
    }
}

