/*
 * Decompiled with CFR 0.152.
 */
package bindead.data.properties;

import bindead.data.properties.PropertyException;

abstract class Property<A> {
    private final String key;
    private final String defaultValue;

    Property(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
        System.setProperty(this.key, defaultValue);
    }

    protected A getValue() throws PropertyException {
        String value = System.getProperty(this.key, this.defaultValue);
        return this.fromString(value);
    }

    public void setValue(A value) {
        System.setProperty(this.key, this.asString(value));
    }

    public abstract A fromString(String var1) throws PropertyException;

    public abstract String asString(A var1);
}

