/*
 * Decompiled with CFR 0.152.
 */
package bindead.data;

import bindead.data.FoldMap;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domains.affine.Equation;
import bindead.domains.affine.Substitution;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.xml.XmlPrintable;

public class Linear
implements Comparable<Linear>,
Iterable<Term>,
XmlPrintable {
    private final Term[] terms;
    private final VarSet variables;
    private static final Term[] EMPTY = new Term[0];
    private static final NumVar constVar = new NumVar(-1);
    public static final Linear ZERO = new Linear(EMPTY);
    public static final Linear ONE = Linear.linear(Bound.ONE);

    private Linear(Term[] newTerms) {
        this.terms = newTerms.length == 0 ? EMPTY : newTerms;
        assert (this.sane());
        VarSet vs = VarSet.empty();
        for (Term t : this.terms) {
            if (t.id == constVar) continue;
            vs = vs.add(t.id);
        }
        this.variables = vs;
    }

    private boolean isNormalized() {
        for (Term term : this.terms) {
            if (!term.getCoeff().isZero()) continue;
            return false;
        }
        return true;
    }

    public boolean sane() {
        if (!this.isNormalized()) {
            return false;
        }
        for (int i = 1; i < this.terms.length; ++i) {
            if (this.terms[i].id.getStamp() >= this.terms[i - 1].id.getStamp()) continue;
            return false;
        }
        return true;
    }

    private static void sortTerms(Term[] termsArray) {
        if (termsArray.length > 0) {
            Arrays.sort(termsArray);
        }
    }

    public Linear toEquality() {
        NumVar key = this.getKey();
        if (key == null) {
            return this;
        }
        if (this.getCoeff(key).isPositive()) {
            return this.lowestForm();
        }
        Term[] newTerms = new Term[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            newTerms[i] = this.terms[i].negate();
        }
        return new Linear(newTerms).lowestForm();
    }

    public Equation toEquation(HashMap<Integer, NumVar> intToVar) {
        int cIdx = this.getConstIdx();
        if (cIdx >= 0 && this.terms[cIdx].coeff.isZero()) {
            return this.dropConstant().toEquation(intToVar);
        }
        int len = this.terms.length;
        Equation.Term[] newTerms = new Equation.Term[len];
        int newTermPos = 0;
        if (cIdx >= 0) {
            newTerms[newTermPos++] = new Equation.Term(this.terms[cIdx].coeff, 0);
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].id == constVar) continue;
            newTerms[newTermPos++] = new Equation.Term(this.terms[i].getCoeff(), this.terms[i].getId().getStamp());
            intToVar.put(this.terms[i].getId().getStamp(), this.terms[i].getId());
        }
        return new Equation(newTerms);
    }

    public static Linear linear(Equation eq, HashMap<Integer, NumVar> intToVar) {
        Term[] newTerms = new Term[eq.getTerms().length];
        int newTermsPos = 0;
        for (Equation.Term t : eq.getTerms()) {
            newTerms[newTermsPos++] = t.getId() == 0 ? Linear.term(t.getCoeff()) : Linear.term(t.getCoeff(), intToVar.get(t.getId()));
        }
        Linear.sortTerms(newTerms);
        return new Linear(newTerms);
    }

    public Linear lowestForm(Divisor div) {
        assert (div != null);
        BigInt d = this.findTermsGCD();
        if (d == null) {
            return this;
        }
        if ((d = d.gcd(div.divisor)).isOne()) {
            return this;
        }
        div.div(d);
        return this.divTerms(d);
    }

    public Linear lowestForm() {
        BigInt d = this.findTermsGCD();
        if (d == null) {
            return this;
        }
        if (d.isOne()) {
            return this;
        }
        return this.divTerms(d);
    }

    private Linear divTerms(BigInt d) {
        Term[] newTerms = new Term[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            newTerms[i] = this.terms[i].div(d);
        }
        return Linear.linear(newTerms);
    }

    private BigInt findTermsGCD() {
        BigInt d = null;
        for (Term t : this.terms) {
            BigInt coeff = t.coeff.abs();
            if (d == null) {
                d = coeff;
                continue;
            }
            if (d.isOne()) break;
            d = d.gcd(coeff);
        }
        return d;
    }

    public BigInt getCoeff(NumVar id) {
        int i = this.findVarIdx(id);
        if (i < this.terms.length && this.terms[i].getId() == id) {
            return this.terms[i].getCoeff();
        }
        return Bound.ZERO;
    }

    public NumVar getKey() {
        if (this.terms.length == 0) {
            return null;
        }
        if (this.terms[0].getId() != constVar) {
            return this.terms[0].getId();
        }
        if (this.terms.length > 1) {
            return this.terms[1].getId();
        }
        return null;
    }

    public VarSet getVars() {
        return this.variables;
    }

    public boolean contains(NumVar variable) {
        return this.getVars().contains(variable);
    }

    private boolean constantIsImplicit() {
        return this.getConstIdx() == -1;
    }

    private int getConstIdx() {
        int i;
        for (i = 0; i < this.terms.length && this.terms[i].getId() != constVar; ++i) {
        }
        if (i < this.terms.length) {
            return i;
        }
        return -1;
    }

    public boolean isZero() {
        if (this.constantIsImplicit() && this.terms.length == 0) {
            return true;
        }
        if (this.terms.length != 1) {
            return false;
        }
        Term constTerm = this.terms[0];
        return constTerm.coeff.isZero();
    }

    public boolean isConstantOnly() {
        return this.constantIsImplicit() ? this.terms.length == 0 : this.terms.length == 1;
    }

    public BigInt getConstant() {
        int cIdx = this.getConstIdx();
        if (cIdx == -1) {
            return Bound.ZERO;
        }
        return this.terms[cIdx].coeff;
    }

    public boolean isSingleTerm() {
        return this.constantIsImplicit() ? this.terms.length == 1 : this.terms.length == 2;
    }

    public NumVar getSingleVarOrNull() {
        if (this.constantIsImplicit() && this.terms.length == 1 && this.terms[0].coeff.isOne()) {
            return this.terms[0].getId();
        }
        return null;
    }

    public Linear smul(BigInt scalar) {
        if (scalar.isZero()) {
            return ZERO;
        }
        if (scalar.isOne()) {
            return this;
        }
        Term[] ts = new Term[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            ts[i] = this.terms[i].mul(scalar);
        }
        return new Linear(ts);
    }

    public Linear add(Linear offset) {
        return Linear.mulAdd(Bound.ONE, this, Bound.ONE, offset);
    }

    public Linear sub(Linear offset) {
        return Linear.mulAdd(Bound.ONE, this, Bound.MINUSONE, offset);
    }

    public Linear sub(BigInt offset) {
        return this.add(offset.negate());
    }

    public Linear add(BigInt offset) {
        if (offset.isZero()) {
            return this;
        }
        return this.addTerm(offset, constVar);
    }

    public Linear sub(NumVar var) {
        return this.addTerm(Bound.MINUSONE, var);
    }

    public Linear add(NumVar var) {
        return this.addTerm(Bound.ONE, var);
    }

    public Linear subTerm(BigInt coeff, NumVar var) {
        return this.addTerm(coeff.negate(), var);
    }

    public Linear addTerm(BigInt coeff, NumVar var) {
        if (coeff.isZero()) {
            return this;
        }
        int prefixEnd = this.findVarIdx(var);
        if (prefixEnd < this.terms.length && this.terms[prefixEnd].getId().equalTo(var)) {
            BigInt newCoeff = this.terms[prefixEnd].getCoeff().add(coeff);
            if (newCoeff.isZero()) {
                return new Linear(this.dropTermAt(prefixEnd));
            }
            Term newTerm = Linear.term(newCoeff, var);
            return new Linear(this.replaceTermAt(prefixEnd, newTerm));
        }
        Term newTerm = Linear.term(coeff, var);
        return new Linear(this.insertTermAt(prefixEnd, newTerm));
    }

    public Linear negate() {
        return this.smul(BigInt.MINUSONE);
    }

    private Term[] insertTermAt(int position, Term newTerm) {
        Term[] newTerms = new Term[this.terms.length + 1];
        System.arraycopy(this.terms, 0, newTerms, 0, position);
        newTerms[position] = newTerm;
        System.arraycopy(this.terms, position, newTerms, position + 1, this.terms.length - position);
        return newTerms;
    }

    private Term[] replaceTermAt(int position, Term newTerm) {
        Term[] newTerms = Arrays.copyOf(this.terms, this.terms.length);
        newTerms[position] = newTerm;
        return newTerms;
    }

    public Linear dropTerm(NumVar var) {
        int idx = this.findVarIdx(var);
        if (idx == this.terms.length || !this.terms[idx].id.equalTo(var)) {
            return this;
        }
        Term[] newTerms = this.dropTermAt(idx);
        return new Linear(newTerms);
    }

    private Term[] dropTermAt(int idx) {
        Term[] newTerms = new Term[this.terms.length - 1];
        System.arraycopy(this.terms, 0, newTerms, 0, idx);
        System.arraycopy(this.terms, idx + 1, newTerms, idx, this.terms.length - idx - 1);
        return newTerms;
    }

    private int findVarIdx(NumVar var) {
        assert (var != null);
        int lower = 0;
        int upper = this.terms.length;
        while (lower < upper) {
            int mid = (lower + upper) / 2;
            if (this.terms[mid].getId().compareTo(var) < 0) {
                lower = mid + 1;
                continue;
            }
            upper = mid;
        }
        return lower;
    }

    public Linear dropConstant() {
        return this.dropTerm(constVar);
    }

    public static Linear mulAdd(BigInt thisFac, Linear thisLin, BigInt otherFac, Linear otherLin) {
        return Linear.weightedSum(thisFac, thisLin.terms, otherFac, otherLin.terms);
    }

    private static Linear weightedSum(BigInt f1, Term[] ts1, BigInt f2, Term[] ts2) {
        assert (!f1.isZero());
        assert (!f2.isZero());
        Term[] res = new Term[ts1.length + ts2.length];
        int i = 0;
        int i1 = 0;
        int i2 = 0;
        while (i1 < ts1.length && i2 < ts2.length) {
            BigInt coeff;
            int varDiff = ts1[i1].id.compareTo(ts2[i2].id);
            if (varDiff < 0) {
                res[i++] = ts1[i1++].mul(f1);
                continue;
            }
            if (varDiff > 0) {
                res[i++] = ts2[i2++].mul(f2);
                continue;
            }
            NumVar var = ts1[i1].id;
            if ((coeff = ts1[i1++].coeff.mul(f1).add(ts2[i2++].coeff.mul(f2))).isZero()) continue;
            res[i++] = Linear.term(coeff, var);
        }
        while (i1 < ts1.length) {
            res[i++] = ts1[i1++].mul(f1);
        }
        while (i2 < ts2.length) {
            res[i++] = ts2[i2++].mul(f2);
        }
        if (i < res.length) {
            res = Arrays.copyOf(res, i);
        }
        return new Linear(res);
    }

    public Substitution genSubstitution(NumVar kill) {
        assert (this.getVars().contains(kill)) : "The linear expression must contain the variable to substitute.";
        BigInt varFac = null;
        Term[] newTs = new Term[this.terms.length - 1];
        int j = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].getId() != kill) {
                newTs[j++] = this.terms[i];
                continue;
            }
            varFac = this.terms[i].coeff;
        }
        assert (varFac != null);
        return new Substitution(kill, new Linear(newTs), varFac.negate());
    }

    public Substitution genSubstitutionOrNull(NumVar kill) {
        if (!this.getVars().contains(kill)) {
            return null;
        }
        return this.genSubstitution(kill);
    }

    public Linear applySubstitution(NumVar y, NumVar x) {
        BigInt coeff = this.getCoeff(x);
        Linear newLin = this.dropTerm(x);
        newLin = newLin.addTerm(coeff, y);
        return newLin;
    }

    public Linear applySubstitution(Substitution subst) {
        int thisIdx;
        NumVar var = subst.getVar();
        for (thisIdx = 0; thisIdx < this.terms.length && this.terms[thisIdx].id != var; ++thisIdx) {
        }
        if (thisIdx == this.terms.length) {
            return this;
        }
        BigInt thisFac = this.terms[thisIdx].coeff;
        Term[] theseTerms = this.dropTermAt(thisIdx);
        Linear ts = !subst.getFac().isNegative() ? Linear.weightedSum(subst.getFac(), theseTerms, thisFac, subst.getExpr().terms) : Linear.weightedSum(subst.getFac().negate(), theseTerms, thisFac.negate(), subst.getExpr().terms);
        return ts;
    }

    private Term[] lazyReplaceAt(int idx, NumVar newVarName, Term[] newTerms) {
        if (newTerms == null) {
            newTerms = Arrays.copyOf(this.terms, this.terms.length);
        }
        newTerms[idx] = Linear.term(newTerms[idx].coeff, newVarName);
        return newTerms;
    }

    public Linear renameVar(FoldMap vars) {
        Term[] newTerms = null;
        Term[] oldTerms = this.terms;
        for (VarPair vp : vars) {
            NumVar one = (NumVar)vp.getEphemeral();
            NumVar two = (NumVar)vp.getPermanent();
            assert (one != two);
            for (int idx = 0; idx < this.terms.length; ++idx) {
                if (oldTerms[idx].id == one) {
                    newTerms = this.lazyReplaceAt(idx, two, newTerms);
                    oldTerms = newTerms;
                    continue;
                }
                if (oldTerms[idx].id != two) continue;
                newTerms = this.lazyReplaceAt(idx, one, newTerms);
                oldTerms = newTerms;
            }
        }
        if (newTerms != null) {
            Linear.sortTerms(newTerms);
            return new Linear(newTerms);
        }
        return null;
    }

    public static BigInt num(long c) {
        return BigInt.of(c);
    }

    private static Term term(BigInt constant) {
        return Linear.term(constant, constVar);
    }

    public static Term term(NumVar id) {
        return Linear.term(Bound.ONE, id);
    }

    public static Term term(BigInt coeff, NumVar id) {
        return new Term(coeff, id);
    }

    public static Linear linear(BigInt constant) {
        if (constant.isZero()) {
            return ZERO;
        }
        return Linear.linear(Linear.term(constant));
    }

    public static Linear linear(NumVar variable) {
        return Linear.linear(Linear.term(variable));
    }

    public static Linear linear(BigInt coefficient, NumVar variable) {
        return Linear.linear(Linear.term(coefficient, variable));
    }

    public static Linear linear(Term ... terms) {
        Linear.sortTerms(terms);
        Term[] result = new Term[terms.length];
        int j = -1;
        for (int i = 0; i < terms.length; ++i) {
            BigInt coeff;
            if (j > -1 && terms[i].getId() == result[j].getId()) {
                coeff = result[j].getCoeff().add(terms[i].getCoeff());
                if (coeff.isZero()) {
                    result[j--] = null;
                    continue;
                }
                result[j] = Linear.term(coeff, result[j].getId());
                continue;
            }
            coeff = terms[i].getCoeff();
            if (coeff.isZero()) continue;
            result[++j] = terms[i];
        }
        if (++j < result.length) {
            result = Arrays.copyOf(result, j);
        }
        return new Linear(result);
    }

    public static Linear linear(BigInt constant, Term ... terms) {
        return Linear.linear(terms).add(constant);
    }

    public static Vector<P2<Boolean, NumVar>> diffVars(Linear pos, Linear neg) {
        Vector<P2<Boolean, NumVar>> diff = new Vector<P2<Boolean, NumVar>>(pos.terms.length + neg.terms.length);
        int pIdx = 0;
        int nIdx = 0;
        while (true) {
            if (nIdx == neg.terms.length) {
                while (pIdx < pos.terms.length) {
                    if (pos.terms[pIdx].id == constVar) {
                        ++pIdx;
                        continue;
                    }
                    diff.add(P2.tuple2(Boolean.FALSE, pos.terms[pIdx++].id));
                }
                break;
            }
            if (pIdx == pos.terms.length) {
                while (nIdx < neg.terms.length) {
                    if (neg.terms[nIdx].id == constVar) {
                        ++nIdx;
                        continue;
                    }
                    diff.add(P2.tuple2(Boolean.TRUE, neg.terms[nIdx++].id));
                }
                break;
            }
            if (pos.terms[pIdx].id == constVar) {
                ++pIdx;
                continue;
            }
            if (neg.terms[nIdx].id == constVar) {
                ++nIdx;
                continue;
            }
            if (pos.terms[pIdx].id == neg.terms[nIdx].id) {
                ++pIdx;
                ++nIdx;
                continue;
            }
            if (pos.terms[pIdx].id.compareTo(neg.terms[nIdx].id) < 0) {
                diff.add(P2.tuple2(Boolean.FALSE, pos.terms[pIdx++].id));
                continue;
            }
            diff.add(P2.tuple2(Boolean.TRUE, neg.terms[nIdx++].id));
        }
        return diff;
    }

    public static Vector<Linear> eliminate(Vector<Linear> eqs, VarSet vars) {
        Vector<Linear> res = new Vector<Linear>(vars.size());
        for (int i = eqs.size() - 1; i >= 0; --i) {
            Linear eq = eqs.get(i);
            VarSet toKillVars = eq.getVars().intersection(vars);
            if (toKillVars.size() == 0) continue;
            NumVar toKill = toKillVars.get(toKillVars.size() - 1);
            eqs.set(i, null);
            res.add(eq);
            Substitution subst = eq.genSubstitution(toKill);
            for (int j = 0; j < eqs.size(); ++j) {
                Linear cur = eqs.get(j);
                if (cur == null) continue;
                eqs.set(j, cur.applySubstitution(subst));
            }
        }
        int lastIdx = 0;
        for (int i = 0; i < eqs.size(); ++i) {
            Linear cur = eqs.get(i);
            if (cur == null) continue;
            eqs.set(lastIdx++, cur);
        }
        eqs.setSize(lastIdx);
        return res;
    }

    public static Linear sumOf(VarSet vars) {
        Term[] ts = new Term[vars.size()];
        int i = 0;
        for (NumVar v : vars) {
            ts[i++] = Linear.term(v);
        }
        return new Linear(ts);
    }

    @Override
    public Iterator<Term> iterator() {
        return new TermIter();
    }

    public Term[] getTerms() {
        if (this.constantIsImplicit()) {
            return this.terms;
        }
        Term[] newTs = new Term[this.terms.length - 1];
        int j = 0;
        for (Term t : this.terms) {
            if (t.isConstTerm()) continue;
            newTs[j++] = t;
        }
        assert (j == newTs.length);
        return newTs;
    }

    @Override
    public int compareTo(Linear l) {
        int cmp = Integer.signum(this.terms.length - l.terms.length);
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            cmp = this.terms[i].compareTo(l.terms[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Linear)) {
            return false;
        }
        Linear l = (Linear)o;
        Linear result = this.sub(l);
        return result.terms.length == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Arrays.deepHashCode(this.terms);
        return hash;
    }

    public String toString() {
        return this.toTermsString();
    }

    public String toTermsString() {
        if (this.terms.length == 0) {
            return "0";
        }
        StringBuilder builder = new StringBuilder();
        BigInt constant = Bound.ZERO;
        boolean printedFirstVariable = false;
        boolean printConst = false;
        for (Term t : this.terms) {
            if (t.getId() == constVar) {
                constant = t.getCoeff();
                if (constant.isZero()) continue;
                printConst = true;
                continue;
            }
            if (!t.getCoeff().isNegative() && printedFirstVariable) {
                builder = builder.append("+");
            }
            builder = builder.append(t.toString());
            printedFirstVariable = true;
        }
        if (printConst) {
            if (!constant.isNegative() && !this.isConstantOnly()) {
                builder.append("+");
            }
            builder = builder.append(constant);
        }
        return builder.toString();
    }

    public String toEquationString() {
        StringBuilder builder = new StringBuilder();
        if (this.terms.length == 0) {
            builder.append("0");
        } else {
            BigInt constant = Bound.ZERO;
            boolean printedFirstVariable = false;
            for (Term term : this.terms) {
                if (term.getId() == constVar) {
                    constant = term.getCoeff();
                    continue;
                }
                if (!term.getCoeff().isNegative() && printedFirstVariable) {
                    builder = builder.append("+");
                }
                builder = builder.append(term.toString());
                printedFirstVariable = true;
            }
            builder.append("=");
            builder.append(constant.negate());
        }
        return builder.toString();
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        for (Term term : this) {
            builder = builder.e("Term").e("Variable").t(term.getId().toString()).up().e("Coefficient").t(term.getCoeff().toString());
            builder = builder.up().up();
        }
        builder = builder.e("Constant").t(this.getConstant().toString()).up();
        return builder;
    }

    private class TermIter
    implements Iterator<Term> {
        int idx = 0;

        @Override
        public boolean hasNext() {
            if (this.idx >= Linear.this.terms.length) {
                return false;
            }
            if (this.idx == Linear.this.terms.length - 1) {
                return Linear.this.terms[this.idx].getId() != constVar;
            }
            return true;
        }

        @Override
        public Term next() {
            while (Linear.this.terms[this.idx].getId() == constVar) {
                ++this.idx;
            }
            return Linear.this.terms[this.idx++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Terms cannot be removed from a Linear expression using an iterator");
        }
    }

    public static final class Term
    implements Comparable<Term> {
        private final NumVar id;
        private final BigInt coeff;

        private Term(BigInt coeff, NumVar id) {
            this.id = id;
            this.coeff = coeff;
        }

        public boolean isConstTerm() {
            return this.getId() == constVar;
        }

        public NumVar getId() {
            return this.id;
        }

        public BigInt getCoeff() {
            return this.coeff;
        }

        public Term mul(BigInt scalar) {
            return Linear.term(this.coeff.mul(scalar), this.id);
        }

        public String toString() {
            String idstring = this.id.toString();
            String result = this.coeff.isOne() ? idstring : (this.coeff.isEqualTo(Bound.MINUSONE) ? "-" + idstring : this.coeff + idstring);
            return result;
        }

        @Override
        public int compareTo(Term other) {
            int cmp = this.id.compareTo(other.id);
            if (cmp == 0) {
                return this.coeff.compareTo(other.coeff);
            }
            return cmp;
        }

        Term div(BigInt d) {
            return Linear.term(this.getCoeff().div(d), this.getId());
        }

        Term negate() {
            return Linear.term(this.getCoeff().negate(), this.getId());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.coeff == null ? 0 : this.coeff.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Term)) {
                return false;
            }
            Term other = (Term)obj;
            if (this.coeff == null ? other.coeff != null : !this.coeff.equals(other.coeff)) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equalTo(other.id));
        }
    }

    public static class Divisor {
        private BigInt divisor;

        public Divisor(BigInt fac) {
            this.divisor = fac;
        }

        public static Divisor one() {
            return new Divisor(Bound.ONE);
        }

        public BigInt get() {
            return this.divisor;
        }

        public void mul(BigInt c) {
            this.divisor = this.divisor.mul(c);
        }

        private void div(BigInt c) {
            this.divisor = this.divisor.div(c);
        }

        public String toString() {
            return this.divisor.toString();
        }

        public void negate() {
            this.divisor = this.divisor.negate();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.divisor == null ? 0 : this.divisor.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Divisor)) {
                return false;
            }
            Divisor other = (Divisor)obj;
            return !(this.divisor == null ? other.divisor != null : !this.divisor.equals(other.divisor));
        }
    }
}

