/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.warnings;

import bindead.domainnetwork.channels.WarningMessage;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domainnetwork.interfaces.ProgramPoint;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class WarningsMap {
    private final Map<ProgramPoint, WarningsContainer> map = new TreeMap<ProgramPoint, WarningsContainer>();
    private final Map<ProgramPoint, Integer> iterationOfOccurrence = new HashMap<ProgramPoint, Integer>();

    public WarningsContainer get(ProgramPoint location) {
        WarningsContainer value = this.map.get(location);
        if (value == null) {
            value = new WarningsContainer();
        }
        return value;
    }

    public int getIterationOfWarnings(ProgramPoint location) {
        return this.iterationOfOccurrence.get(location);
    }

    public void put(ProgramPoint location, int iteration, WarningsContainer warnings) {
        this.map.put(location, warnings);
        if (this.iterationOfOccurrence.get(location) == null) {
            this.iterationOfOccurrence.put(location, iteration);
        } else assert (this.map.get(location).size() == warnings.size());
    }

    public Collection<WarningsContainer> values() {
        return this.map.values();
    }

    public Set<Map.Entry<ProgramPoint, WarningsContainer>> entrySet() {
        return this.map.entrySet();
    }

    public int totalNumberOfWarnings() {
        int numberOfWarnings = 0;
        for (WarningsContainer entry : this.values()) {
            numberOfWarnings += entry.size();
        }
        return numberOfWarnings;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Warnings: " + this.totalNumberOfWarnings());
        builder.append('\n');
        for (Map.Entry<ProgramPoint, WarningsContainer> entry : this.entrySet()) {
            ProgramPoint point = entry.getKey();
            WarningsContainer warningsHere = entry.getValue();
            if (warningsHere.isEmpty()) continue;
            builder.append("@ " + point);
            if (this.iterationOfOccurrence.containsKey(point)) {
                builder.append(" in iter. " + this.iterationOfOccurrence.get(point));
            }
            builder.append('\n');
            for (WarningMessage message : warningsHere) {
                builder.append("  " + message.detailedMessage());
                builder.append('\n');
            }
        }
        return builder.toString();
    }
}

