/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.systems.natives;

import bindead.analyses.systems.natives.DefinitionId;
import bindead.analyses.systems.natives.FunctionDefinition;
import bindead.analyses.systems.natives.IDefinitionProvider;
import bindead.analyses.systems.natives.TemplateArguments;
import java.util.HashMap;
import java.util.Map;
import javalx.data.Option;

public class ProviderCacheDecorator
implements IDefinitionProvider {
    private final IDefinitionProvider provider;
    private final Map<DefinitionId, Map<TemplateArguments, Option<FunctionDefinition>>> cache = new HashMap<DefinitionId, Map<TemplateArguments, Option<FunctionDefinition>>>();

    public ProviderCacheDecorator(IDefinitionProvider provider) {
        this.provider = provider;
    }

    @Override
    public boolean hasNativeFunction(DefinitionId id) {
        Map<TemplateArguments, Option<FunctionDefinition>> data = this.cache.get(id);
        if (data == null) {
            return this.provider.hasNativeFunction(id);
        }
        for (Option<FunctionDefinition> optFunc : data.values()) {
            if (!optFunc.isSome()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Option<FunctionDefinition> getNativeFunction(DefinitionId id, TemplateArguments args) {
        Option<FunctionDefinition> function;
        Map<TemplateArguments, Option<FunctionDefinition>> data = this.cache.get(id);
        if (data == null) {
            function = this.provider.getNativeFunction(id, args);
            data = new HashMap<TemplateArguments, Option<FunctionDefinition>>();
            data.put(args, function);
            this.cache.put(id, data);
        } else {
            function = data.get(args);
            if (function == null) {
                function = this.provider.getNativeFunction(id, args);
                data.put(args, function);
            }
        }
        return function;
    }

    @Override
    public IDefinitionProvider cached() {
        return this;
    }
}

