/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.systems.natives;

import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;

public class FunctionDefinition {
    private final SortedMap<RReilAddr, RReil> instructions;

    public FunctionDefinition(SortedMap<RReilAddr, RReil> instructions) {
        this.instructions = instructions;
    }

    public SortedMap<RReilAddr, RReil> getInstructions() {
        return this.instructions;
    }

    public boolean reachedEnd(RReilAddr addr) {
        return addr.equals(this.instructions.lastKey().nextBase());
    }

    public FunctionDefinition prepend(List<RReil> prolog) {
        SortedMap<RReilAddr, RReil> instructions = this.getInstructions();
        TreeMap<RReilAddr, RReil> newInstructions = new TreeMap<RReilAddr, RReil>();
        long addrBase = 0L;
        addrBase = FunctionDefinition.addInstructions(prolog, addrBase, newInstructions);
        addrBase = FunctionDefinition.addInstructions(instructions.values(), addrBase, newInstructions);
        return new FunctionDefinition(newInstructions);
    }

    public FunctionDefinition append(List<RReil> prolog) {
        SortedMap<RReilAddr, RReil> instructions = this.getInstructions();
        TreeMap<RReilAddr, RReil> newInstructions = new TreeMap<RReilAddr, RReil>();
        long addrBase = instructions.lastKey().base() + 1L;
        addrBase = FunctionDefinition.addInstructions(prolog, addrBase, newInstructions);
        return new FunctionDefinition(newInstructions);
    }

    private static long addInstructions(Collection<RReil> instructions, long newAddrBase, SortedMap<RReilAddr, RReil> to) {
        for (RReil rreil : instructions) {
            RReilAddr newAddr = RReilAddr.valueOf(newAddrBase);
            RReil newRreil = FunctionDefinition.copyWithNewAddr(rreil, newAddr);
            to.put(newAddr, newRreil);
            ++newAddrBase;
        }
        return newAddrBase;
    }

    private static RReil copyWithNewAddr(RReil rreil, RReilAddr addr) {
        RReil newRreil = null;
        if (rreil instanceof RReil.Assign) {
            RReil.Assign assign = (RReil.Assign)rreil;
            newRreil = new RReil.Assign(addr, assign.getLhs(), assign.getRhs());
        } else if (rreil instanceof RReil.Load) {
            RReil.Load load = (RReil.Load)rreil;
            newRreil = new RReil.Load(addr, load.getLhs(), load.getReadAddress());
        } else if (rreil instanceof RReil.Store) {
            RReil.Store store = (RReil.Store)rreil;
            newRreil = new RReil.Store(addr, store.getWriteAddress(), store.getRhs());
        } else if (rreil instanceof RReil.Branch) {
            RReil.Branch branch = (RReil.Branch)rreil;
            newRreil = new RReil.Branch(addr, branch.getTarget(), branch.getBranchType());
        } else if (rreil instanceof RReil.PrimOp) {
            RReil.PrimOp primOp = (RReil.PrimOp)rreil;
            newRreil = new RReil.PrimOp(addr, primOp.getName(), primOp.getOutArgs(), primOp.getInArgs());
        } else if (rreil instanceof RReil.Native) {
            RReil.Native nativee = (RReil.Native)rreil;
            newRreil = new RReil.Native(addr, nativee.getName(), nativee.getOpnd());
        } else if (!(rreil instanceof RReil.Assertion)) {
            if (rreil instanceof RReil.Nop) {
                newRreil = new RReil.Nop(addr);
            } else {
                throw new UnsupportedOperationException("RReil type not supported yet!");
            }
        }
        return newRreil;
    }
}

