/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.systems.natives;

import bindead.analyses.systems.natives.DefinitionId;
import bindead.analyses.systems.natives.IDefinitionLoader;
import bindead.analyses.systems.natives.RawDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javalx.data.Option;

public class FileSystemLoader
implements IDefinitionLoader {
    private static final String FILE_EXT = ".rr";
    private final List<String> basePaths = new ArrayList<String>();

    public FileSystemLoader(String ... basePaths) {
        for (String basePath : basePaths) {
            if (!basePath.endsWith(File.separator)) {
                this.basePaths.add(basePath + File.separator);
                continue;
            }
            this.basePaths.add(basePath);
        }
    }

    @Override
    public boolean hasEntry(DefinitionId id) {
        for (String basePath : this.basePaths) {
            File defFile = new File(FileSystemLoader.filename(basePath, id));
            if (!FileSystemLoader.check(defFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Option<RawDefinition> getEntry(DefinitionId id) {
        for (String basePath : this.basePaths) {
            File defFile = new File(FileSystemLoader.filename(basePath, id));
            if (!FileSystemLoader.check(defFile)) continue;
            ByteBuffer rawBuffer = ByteBuffer.allocate((int)defFile.length());
            try {
                FileInputStream fis = new FileInputStream(defFile);
                fis.getChannel().read(rawBuffer);
                rawBuffer.flip();
                fis.close();
                return Option.some(new RawDefinition(rawBuffer));
            }
            catch (FileNotFoundException err) {
                System.err.println("Cannot find native definition file '" + defFile.getAbsolutePath() + "':");
                err.printStackTrace();
            }
            catch (IOException err) {
                System.err.println("Error while reading native definition file:");
                err.printStackTrace();
            }
        }
        return Option.none();
    }

    private static boolean check(File file) {
        return file.exists() && !file.isDirectory();
    }

    private static String filename(String basePath, DefinitionId id) {
        return basePath + id.getBase() + FILE_EXT;
    }
}

