/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.callback;

import bindead.analyses.algorithms.data.Flows;
import bindead.analyses.callback.CallbackHandler;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.AnalysisEnvironment;
import java.util.HashMap;
import java.util.Map;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;

public class Callbacks {
    private final Map<RReilAddr, CallbackHandler> handlers = new HashMap<RReilAddr, CallbackHandler>();

    public void addHandler(RReilAddr address, CallbackHandler handler) {
        this.handlers.put(address, handler);
    }

    public <D extends RootDomain<D>> boolean tryCallback(RReil insn, D domainState, ProgramPoint point, AnalysisEnvironment env, Flows<D> flow) {
        CallbackHandler handler = this.handlers.get(point.getAddress());
        if (handler == null) {
            return false;
        }
        handler.run(insn, domainState, point, env, flow);
        return true;
    }
}

