/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms.data;

import bindead.analyses.algorithms.AnalysisProperties;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;

public class Worklist<T extends Comparable<? super T>> {
    private final boolean useGlobalOrdering;
    private final PriorityQueue<T> queue;
    private final ArrayDeque<T> oldQueue;
    private final Set<T> inQueue;

    public Worklist() {
        this.useGlobalOrdering = AnalysisProperties.INSTANCE.processAddressesInOrder.isTrue();
        this.queue = new PriorityQueue();
        this.oldQueue = new ArrayDeque();
        this.inQueue = new HashSet<T>();
    }

    public void enqueue(T element) {
        if (this.useGlobalOrdering) {
            this.enqueueOrdered(element);
        } else {
            this.enqueueUnordered(element);
        }
    }

    private void enqueueOrdered(T element) {
        if (this.inQueue.contains(element)) {
            return;
        }
        this.inQueue.add(element);
        this.queue.add(element);
    }

    private void enqueueUnordered(T element) {
        if (this.inQueue.contains(element)) {
            this.oldQueue.remove(element);
        }
        this.inQueue.add(element);
        this.oldQueue.push(element);
    }

    public T dequeue() {
        Comparable element = this.useGlobalOrdering ? (Comparable)this.queue.remove() : (Comparable)this.oldQueue.pop();
        this.inQueue.remove(element);
        return (T)element;
    }

    public boolean isEmpty() {
        if (this.useGlobalOrdering) {
            return this.queue.isEmpty();
        }
        return this.oldQueue.isEmpty();
    }

    public String toString() {
        if (this.useGlobalOrdering) {
            return "WORKLIST" + this.queue;
        }
        return "WORKLIST" + this.oldQueue;
    }
}

