/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms;

import bindead.analyses.algorithms.FixpointAnalysisEvaluator;
import bindead.analyses.algorithms.TraceIterator;
import bindead.analyses.algorithms.data.Flows;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.AnalysisEnvironment;
import javalx.data.products.P3;
import javalx.exceptions.UnimplementedException;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import rreil.RReilGrammarException;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RhsFactory;

class TraceEvaluator<D extends RootDomain<D>>
extends FixpointAnalysisEvaluator<D> {
    private final TraceIterator trace;

    public TraceEvaluator(TraceIterator trace) {
        super(57005L);
        this.trace = trace;
    }

    private D assignValueToRegister(String registerName, Rhs value, D domain) {
        AnalysisEnvironment env = domain.getContext().getEnvironment();
        Rhs.Rvar register = env.getPlatform().getRegisterAsVariable(registerName);
        RReil.Assign setTarget = new RReil.Assign(RReilAddr.ZERO, register, value);
        domain = (RootDomain)domain.eval(setTarget);
        return domain;
    }

    @Override
    public Flows<D> visit(RReil.Native stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        String[] registers;
        RootDomain domainState = (RootDomain)ctx._1();
        RhsFactory rhsFactory = RhsFactory.getInstance();
        Rhs.RangeRhs top = rhsFactory.arbitrary(64);
        for (String register : registers = new String[]{"rax", "rbx", "rcx", "rdx"}) {
            domainState = this.assignValueToRegister(register, top, domainState);
        }
        return Flows.next(ctx._3(), domainState);
    }

    @Override
    public Flows<D> visit(RReil.BranchToNative stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        throw new RReilGrammarException();
    }

    @Override
    public Flows<D> visit(RReil.Branch stmt, P3<D, ProgramPoint, RReilAddr> ctx) {
        throw new RReilGrammarException();
    }

    private D evalTrace(RReilAddr insnAddress, Rhs.Rval target, Rhs.Rval condition, D domainState) {
        if (this.trace.hasNext() && this.trace.nextBranchIsAt(insnAddress)) {
            if (target instanceof Rhs.Rvar) {
                domainState = this.setJumpTarget((Rhs.Rvar)target, domainState);
            }
            if (condition != null && condition instanceof Rhs.Rvar) {
                domainState = this.setConditionFlag((Rhs.Rvar)condition, domainState);
            }
            this.trace.advance();
        }
        return domainState;
    }

    private D setJumpTarget(Rhs.Rvar target, D domainState) {
        RReilAddr targetAddress = this.trace.getBranchTarget();
        BigInt value = BigInt.of(targetAddress.base());
        return this.setValue(domainState, target, value);
    }

    private D setConditionFlag(Rhs.Rvar condition, D domainState) {
        BigInt value = this.trace.getBranchConditionEvaluation() ? Bound.ONE : Bound.ZERO;
        return this.setValue(domainState, condition, value);
    }

    private D setValue(D state, Rhs.Rvar variable, BigInt value) {
        throw new UnimplementedException("Implement the TODO above when needed.");
    }
}

