/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses;

import bindead.domainnetwork.interfaces.RootDomain;
import rreil.lang.RReil;
import rreil.lang.util.RReilVisitor;

public class RReilRunner {
    public static <D extends RootDomain<D>> D eval(D state, String ... instructions) {
        Evaluator dispatcher = new Evaluator<D, D>(){

            @Override
            public D visit(RReil.Assign stmt, D state) {
                return (RootDomain)state.eval(stmt);
            }

            @Override
            public D visit(RReil.Load stmt, D state) {
                return (RootDomain)state.eval(stmt);
            }

            @Override
            public D visit(RReil.Store stmt, D state) {
                return (RootDomain)state.eval(stmt);
            }

            @Override
            public D visit(RReil.PrimOp stmt, D state) {
                return (RootDomain)state.eval(stmt);
            }

            @Override
            public D visit(RReil.Nop stmt, D state) {
                return state;
            }
        };
        Object resultState = state;
        for (String instruction : instructions) {
            RReil rreilInstruction = RReil.from(instruction);
            resultState = (RootDomain)rreilInstruction.accept(dispatcher, resultState);
        }
        return resultState;
    }

    private static class Evaluator<R, T>
    implements RReilVisitor<R, T> {
        protected R defaultVisit(RReil insn, T data) {
            throw new UnsupportedOperationException("Instruction not applicable to this eval on the state " + insn);
        }

        @Override
        public R visit(RReil.Assign stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.Load stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.Store stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.BranchToNative stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.BranchToRReil stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.Nop stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.Assertion stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.Branch stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.PrimOp stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.Native stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.Throw stmt, T data) {
            return this.defaultVisit(stmt, data);
        }

        @Override
        public R visit(RReil.Flop stmt, T data) {
            return this.defaultVisit(stmt, data);
        }
    }
}

