/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses;

import bindead.analyses.warnings.WarningsMap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;

public class ProgressReporter {
    private final Multiset<RReilAddr> iterationsCounter = HashMultiset.create();
    private final List<InstructionListener> listeners = new ArrayList<InstructionListener>();
    private final WarningsMap warnings;

    public ProgressReporter(WarningsMap warnings) {
        this.warnings = warnings;
    }

    public void evaluatingInstruction(RReil insn) {
        this.iterationsCounter.add(insn.getRReilAddress());
        for (InstructionListener listener : this.listeners) {
            listener.evaluatingInstruction(insn);
        }
    }

    public void addInstructionListener(InstructionListener listener) {
        this.listeners.add(listener);
    }

    public int getIterationCount(RReil insn) {
        return this.iterationsCounter.count(insn.getRReilAddress());
    }

    public int getIterationCount(RReilAddr address) {
        return this.iterationsCounter.count(address);
    }

    public WarningsMap getWarnings() {
        return this.warnings;
    }

    public static interface InstructionListener
    extends EventListener {
        public void evaluatingInstruction(RReil var1);
    }
}

