/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses;

import bindead.analyses.AnalysisFactory;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.Affine;
import bindead.domains.affine.RedundantAffine;
import bindead.domains.apron.ApronIntervals;
import bindead.domains.apron.ApronOctagons;
import bindead.domains.apron.ApronPolyhedra;
import bindead.domains.congruences.Congruences;
import bindead.domains.fields.Fields;
import bindead.domains.fields.FieldsDisjunction;
import bindead.domains.finiteDisjunction.FiniteDisjunction;
import bindead.domains.finitesupportset.FiniteSupportSet;
import bindead.domains.gauge.Gauge;
import bindead.domains.intervals.IntervalSets;
import bindead.domains.intervals.Intervals;
import bindead.domains.phased.Phased;
import bindead.domains.pointsto.PointsTo;
import bindead.domains.predicates.finite.Predicates;
import bindead.domains.root.Root;
import bindead.domains.sat.Sat;
import bindead.domains.segments.SegMem;
import bindead.domains.segments.basics.Segment;
import bindead.domains.segments.heap.HeapSegment;
import bindead.domains.segments.machine.DataSegments;
import bindead.domains.segments.machine.NullSegment;
import bindead.domains.segments.machine.Processor;
import bindead.domains.segments.machine.StackSegment;
import bindead.domains.segments.machine.ThreadLocalStorage;
import bindead.domains.syntacticstripes.Stripes;
import bindead.domains.undef.Undef;
import bindead.domains.widening.delayed.DelayedWidening;
import bindead.domains.widening.delayed.DelayedWideningWithThresholds;
import bindead.domains.widening.thresholds.ThresholdsWidening;
import bindead.domains.wrapping.Wrapping;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DomainFactory {
    private static final List<String> domainSeparators = Arrays.asList("/", ":", "!", ">", "\\|", " ");
    private static final String disableDomainToken = "-";
    private static final Map<String, DomainBuilder> domainBuilders = new HashMap<String, DomainBuilder>();

    static AnalysisFactory.DomainHierarchyFactory parseFactory(String domainHierarchy) {
        List<String> domains = DomainFactory.tokenize(domainHierarchy.trim());
        if (domains.isEmpty()) {
            throw new IllegalArgumentException("Could not parse the domain hierarchy string: " + domainHierarchy);
        }
        final Object cachedDomain = DomainFactory.buildNext(domains);
        return new AnalysisFactory.DomainHierarchyFactory(){

            @Override
            public <D extends RootDomain<D>> D build() {
                return (D)((RootDomain)cachedDomain);
            }
        };
    }

    public static FiniteDomain parseFiniteDomain(String domainHierarchy) {
        List<String> domains = DomainFactory.tokenize(domainHierarchy);
        if (domains.isEmpty()) {
            throw new IllegalArgumentException("Could not parse the domain hierarchy string: " + domainHierarchy);
        }
        return (FiniteDomain)DomainFactory.buildNext(domains);
    }

    public static ZenoDomain parseZenoDomain(String domainHierarchy) {
        List<String> domains = DomainFactory.tokenize(domainHierarchy);
        if (domains.isEmpty()) {
            throw new IllegalArgumentException("Could not parse the domain hierarchy string: " + domainHierarchy);
        }
        return (ZenoDomain)DomainFactory.buildNext(domains);
    }

    private static void registerDomainBuilders() {
        DomainFactory.addBuilder("ROOT", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Root<MemoryDomain>((MemoryDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("SEGMEM", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                Segment[] segArray = SegmentFactory.buildSegments(childHierarchy);
                return new SegMem<MemoryDomain>((MemoryDomain)DomainFactory.buildNext(childHierarchy), segArray);
            }
        });
        DomainFactory.addBuilder("FIELDS", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Fields<FiniteDomain>((FiniteDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("FIELDSDISJUNCTION", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new FieldsDisjunction<MemoryDomain>((MemoryDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("PREDICATES(F)", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Predicates<FiniteDomain>((FiniteDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("PREDICATES(Z)", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new bindead.domains.predicates.zeno.Predicates<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("UNDEF", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                FiniteDomain buildNext = (FiniteDomain)DomainFactory.buildNext(childHierarchy);
                return new Undef<FiniteDomain>(buildNext);
            }
        });
        DomainFactory.addBuilder("POINTSTO", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new PointsTo<FiniteDomain>((FiniteDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("SUPPORTSET", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new FiniteSupportSet<FiniteDomain>((FiniteDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("DISJUNCTION", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new FiniteDisjunction<FiniteDomain>((FiniteDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("SAT", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Sat<FiniteDomain>((FiniteDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("WRAPPING", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Wrapping<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("REDUNDANTAFFINE", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new RedundantAffine<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("THRESHOLDSWIDENING", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new ThresholdsWidening<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("PHASED", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Phased<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("DELAYEDWIDENING", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new DelayedWidening<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("DELAYEDWIDENING(Thresholds)", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new DelayedWideningWithThresholds<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("STRIPES", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Stripes<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("CONGRUENCES", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Congruences<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("INTERVALS", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Intervals();
            }
        });
        DomainFactory.addBuilder("GAUGE", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Gauge<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("INTERVALSETS", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new IntervalSets();
            }
        });
        DomainFactory.addBuilder("APRON(Intervals)", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new ApronIntervals();
            }
        });
        DomainFactory.addBuilder("APRON(Octagons)", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new ApronOctagons();
            }
        });
        DomainFactory.addBuilder("APRON(Polyhedra)", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new ApronPolyhedra();
            }
        });
        DomainFactory.addBuilder("AFFINE", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new Affine<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
        DomainFactory.addBuilder("THRESHOLDSWIDENING(OLD)", new DomainBuilder(){

            @Override
            public Object instantiate(List<String> childHierarchy) {
                return new bindead.domains.widening.oldthresholds.ThresholdsWidening<ZenoDomain>((ZenoDomain)DomainFactory.buildNext(childHierarchy));
            }
        });
    }

    private static Object buildNext(List<String> domains) {
        if (domains.isEmpty()) {
            throw new IllegalArgumentException("You did not specify the right domain for the bottom of the hierarchy. It still needs a child.");
        }
        String nextDomain = domains.remove(0);
        DomainBuilder builder = DomainFactory.getDomainBuilder(nextDomain);
        if (builder == null) {
            throw new IllegalArgumentException("Could not find a builder for domain: " + nextDomain);
        }
        return builder.instantiate(domains);
    }

    private static void addBuilder(String name, DomainBuilder domainBuilder) {
        domainBuilders.put(name.toLowerCase(), domainBuilder);
    }

    private static DomainBuilder getDomainBuilder(String domainName) {
        return domainBuilders.get(domainName);
    }

    private static List<String> tokenize(String domainHierarchy) {
        domainHierarchy = domainHierarchy.toLowerCase();
        for (String separator : domainSeparators) {
            String[] domainsArray = domainHierarchy.split(separator);
            if (domainsArray.length <= 1) continue;
            LinkedList<String> domains = new LinkedList<String>();
            for (String ds : domainsArray) {
                if (ds.startsWith(disableDomainToken)) continue;
                domains.add(ds);
            }
            return domains;
        }
        throw new IllegalArgumentException("cannot parse domain string: " + domainHierarchy);
    }

    static {
        DomainFactory.registerDomainBuilders();
        SegmentFactory.registerSegmentBuilders();
    }

    private static interface SegmentBuilder {
        public Segment instantiate();
    }

    private static interface DomainBuilder {
        public Object instantiate(List<String> var1);
    }

    private static class SegmentFactory {
        private static final Map<String, SegmentBuilder> segmentBuilders = new HashMap<String, SegmentBuilder>();

        private SegmentFactory() {
        }

        private static Segment[] buildSegments(List<String> childHierarchy) {
            LinkedList<Segment> segs = new LinkedList<Segment>();
            while (!childHierarchy.isEmpty() && SegmentFactory.isSegment(childHierarchy.get(0))) {
                String domainName = childHierarchy.remove(0);
                segs.add(segmentBuilders.get(domainName).instantiate());
            }
            Segment[] segArray = new Segment[]{};
            segArray = segs.toArray(segArray);
            return segArray;
        }

        private static boolean isSegment(String segName) {
            return segmentBuilders.containsKey(segName);
        }

        private static void addSegmentBuilder(String name, SegmentBuilder segmentBuilder) {
            segmentBuilders.put(name.toLowerCase(), segmentBuilder);
        }

        private static void registerSegmentBuilders() {
            SegmentFactory.addSegmentBuilder("Data", new SegmentBuilder(){

                @Override
                public Segment instantiate() {
                    return new DataSegments();
                }
            });
            SegmentFactory.addSegmentBuilder("Null", new SegmentBuilder(){

                @Override
                public Segment instantiate() {
                    return new NullSegment();
                }
            });
            SegmentFactory.addSegmentBuilder("Heap", new SegmentBuilder(){

                @Override
                public Segment instantiate() {
                    return new HeapSegment();
                }
            });
            SegmentFactory.addSegmentBuilder("Processor", new SegmentBuilder(){

                @Override
                public Segment instantiate() {
                    return new Processor();
                }
            });
            SegmentFactory.addSegmentBuilder("Stack", new SegmentBuilder(){

                @Override
                public Segment instantiate() {
                    return new StackSegment();
                }
            });
            SegmentFactory.addSegmentBuilder("ThreadLocalStorage", new SegmentBuilder(){

                @Override
                public Segment instantiate() {
                    return new ThreadLocalStorage();
                }
            });
        }
    }
}

