/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses;

import bindead.analyses.Analysis;
import bindead.analyses.DomainFactory;
import bindead.analyses.algorithms.CallStringAnalysis;
import bindead.analyses.algorithms.FixpointAnalysis;
import bindead.analyses.algorithms.RecursiveDisassembler;
import bindead.analyses.callback.Callbacks;
import bindead.analyses.systems.GenericSystemModel;
import bindead.analyses.systems.SystemModel;
import bindead.analyses.systems.SystemModelRegistry;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.AnalysisEnvironment;
import bindead.environment.platform.Platform;
import binparse.Binary;
import binparse.Symbol;
import binparse.rreil.RReilBinary;
import javalx.data.Option;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;

public class AnalysisFactory {
    private String domainHierarchy;
    public static final String defaultDomainHierarchy = "SegMem Processor Stack -Null Data -Heap Fields -Undef Predicates(F) -SupportSet PointsTo -Disjunction Wrapping DelayedWidening -DelayedWidening(Thresholds) -Phased ThresholdsWidening Predicates(Z) RedundantAffine -Affine Congruences Intervals -IntervalSets -Apron(Polyhedra) -Apron(Octagons) -Apron(Intervals) ";

    public AnalysisFactory() {
        this(defaultDomainHierarchy);
    }

    public AnalysisFactory(String domainHierarchy) {
        this.domainHierarchy = domainHierarchy;
    }

    public AnalysisFactory enableDomains(String ... domainNames) {
        String newDomainHierarchy = this.domainHierarchy.toLowerCase();
        for (String domainName : domainNames) {
            domainName = domainName.toLowerCase();
            newDomainHierarchy = newDomainHierarchy.replace(" -" + domainName + " ", " " + domainName + " ");
        }
        this.domainHierarchy = newDomainHierarchy;
        return this;
    }

    public AnalysisFactory disableDomains(String ... domainNames) {
        String newDomainHierarchy = this.domainHierarchy.toLowerCase();
        for (String domainName : domainNames) {
            domainName = domainName.toLowerCase();
            newDomainHierarchy = newDomainHierarchy.replace(" " + domainName + " ", " -" + domainName + " ");
        }
        this.domainHierarchy = newDomainHierarchy;
        return this;
    }

    public RootDomain initialDomain() {
        return DomainFactory.parseFactory(this.domainHierarchy).build();
    }

    public static RootDomain buildInitialDomain(String domainHierarchy) {
        DomainHierarchyFactory domain = DomainFactory.parseFactory(domainHierarchy);
        return domain.build();
    }

    public static RReilAddr getStartAddress(Binary binary) {
        Option<Symbol> mainFunction = binary.getMainFunction();
        long reconstructionStartAddress = mainFunction.isSome() ? mainFunction.get().getAddress() : binary.getEntryAddress();
        return RReilAddr.valueOf(reconstructionStartAddress);
    }

    public Analysis<?> getFixpointAnalysis(Binary binary) {
        GenericSystemModel systemModel = SystemModelRegistry.getLinuxModel(binary);
        AnalysisEnvironment environment = new AnalysisEnvironment(systemModel, null);
        return new FixpointAnalysis<RootDomain>(environment, binary, this.initialDomain());
    }

    public Analysis<?> getCallstringAnalysis(Binary binary) {
        GenericSystemModel systemModel = SystemModelRegistry.getLinuxModel(binary);
        AnalysisEnvironment environment = new AnalysisEnvironment(systemModel, null);
        return new CallStringAnalysis<RootDomain>(environment, binary, this.initialDomain());
    }

    public Analysis<?> getRecursiveDisassembler(Binary binary) {
        GenericSystemModel systemModel = SystemModelRegistry.getLinuxModel(binary);
        AnalysisEnvironment environment = new AnalysisEnvironment(systemModel, null);
        return new RecursiveDisassembler(environment, binary);
    }

    public Analysis<?> runAnalysis(String rreilAssembly) {
        return this.runAnalysis(rreilAssembly, null);
    }

    public Analysis<?> runAnalysis(String rreilAssembly, AnalysisDebugHooks debug) {
        RReilBinary binary = RReilBinary.fromString(rreilAssembly);
        return this.runAnalysis(binary, debug);
    }

    public Analysis<?> runAnalysis(Binary binary) {
        return this.runAnalysis(binary, null);
    }

    public Analysis<?> runAnalysis(Binary binary, AnalysisDebugHooks debug) {
        return this.runAnalysis(binary, debug, null);
    }

    public Analysis<?> runAnalysis(Binary binary, AnalysisDebugHooks debug, Callbacks registry) {
        RReilAddr startAddress = AnalysisFactory.getStartAddress(binary);
        GenericSystemModel systemModel = SystemModelRegistry.getLinuxModel(binary);
        return this.runAnalysis(binary, systemModel, startAddress, debug, registry);
    }

    private Analysis<?> runAnalysis(Binary binary, SystemModel model, RReilAddr startAddress, AnalysisDebugHooks debug, Callbacks registry) {
        AnalysisEnvironment environment = new AnalysisEnvironment(model, registry);
        FixpointAnalysis<RootDomain> analysis = new FixpointAnalysis<RootDomain>(environment, binary, this.initialDomain());
        analysis.setDebugHooks(debug);
        ((Analysis)analysis).runFrom(startAddress);
        return analysis;
    }

    public Analysis<?> runAnalysis(Binary binary, Platform platform, RReilAddr startAddress, AnalysisDebugHooks debug, Callbacks registry) {
        AnalysisEnvironment environment = new AnalysisEnvironment(platform, registry);
        FixpointAnalysis<RootDomain> analysis = new FixpointAnalysis<RootDomain>(environment, binary, this.initialDomain());
        analysis.setDebugHooks(debug);
        ((Analysis)analysis).runFrom(startAddress);
        return analysis;
    }

    public static interface AnalysisDebugHooks {
        public <D extends RootDomain<D>> void beforeEval(RReil var1, ProgramPoint var2, D var3, Analysis<D> var4);

        public <D extends RootDomain<D>> void afterEval(RReil var1, ProgramPoint var2, RReilAddr var3, D var4, Analysis<D> var5);
    }

    static interface DomainHierarchyFactory {
        public <D extends RootDomain<D>> D build();
    }
}

