/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses;

import bindead.analyses.AnalysisFactory;
import bindead.analyses.BinaryCodeCache;
import bindead.analyses.ProgressReporter;
import bindead.analyses.RReilCodeCache;
import bindead.analyses.algorithms.data.CallString;
import bindead.analyses.algorithms.data.TransitionSystem;
import bindead.analyses.warnings.WarningsMap;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.AnalysisEnvironment;
import bindead.environment.platform.Platform;
import javalx.data.Option;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import rreil.lang.Field;
import rreil.lang.MemVar;
import rreil.lang.RReilAddr;

public abstract class Analysis<D extends RootDomain<D>> {
    protected final AnalysisEnvironment environment;
    protected AnalysisFactory.AnalysisDebugHooks debugHooks;

    public Analysis(AnalysisEnvironment environment) {
        this.environment = environment;
    }

    public abstract void runFrom(RReilAddr var1);

    public void setDebugHooks(AnalysisFactory.AnalysisDebugHooks hooks) {
        this.debugHooks = hooks;
    }

    public Platform getPlatform() {
        return this.environment.getPlatform();
    }

    public ProgressReporter getProgressMonitoring() {
        return null;
    }

    public Option<Interval> query(RReilAddr address, String name, int size, int offset) {
        Option<Range> range = this.queryRange(address, name, size, offset);
        if (range.isNone()) {
            return Option.none();
        }
        return Option.some(range.get().convexHull());
    }

    public Option<Range> queryRange(RReilAddr address, String name, int size, int offset) {
        Option<D> state = this.getState(CallString.root(), address);
        if (state.isNone()) {
            return Option.none();
        }
        return Option.some(((RootDomain)state.get()).queryRange(MemVar.getVarOrFresh(name), Field.finiteRangeKey(offset, size)));
    }

    public abstract Option<D> getState(CallString var1, RReilAddr var2);

    public abstract BinaryCodeCache getBinaryCode();

    public abstract RReilCodeCache getRReilCode();

    public abstract TransitionSystem getTransitionSystem();

    public abstract WarningsMap getWarnings();
}

