/*
 * Decompiled with CFR 0.152.
 */
package bindead.abstractsyntax.finite.util;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteExprVisitor;
import bindead.data.VarSet;

public class VarExtractor {
    private static Collector collector = new Collector();

    public static VarSet get(Finite.Assign stmt) {
        VarSet data = VarSet.empty();
        data = data.add(stmt.getLhs().getId());
        data = stmt.getRhs().accept(collector, data);
        return data;
    }

    public static VarSet get(Finite.Test stmt) {
        return stmt.getVars();
    }

    public static VarSet get(Finite.Lhs expr) {
        VarSet data = VarSet.empty();
        return data.add(expr.getId());
    }

    public static VarSet get(Finite.Rhs expr) {
        return expr.accept(collector, VarSet.empty());
    }

    public static class Collector
    implements FiniteExprVisitor<VarSet, VarSet> {
        @Override
        public VarSet visit(Finite.Bin expr, VarSet data) {
            return expr.getLeft().accept(this, expr.getRight().accept(this, data));
        }

        @Override
        public VarSet visit(Finite.Cmp expr, VarSet data) {
            return expr.getLeft().accept(this, expr.getRight().accept(this, data));
        }

        @Override
        public VarSet visit(Finite.SignExtend expr, VarSet data) {
            return expr.getExpr().accept(this, data);
        }

        @Override
        public VarSet visit(Finite.Convert expr, VarSet data) {
            return expr.getExpr().accept(this, data);
        }

        @Override
        public VarSet visit(Finite.Rlin expr, VarSet data) {
            return data.union(expr.getLinearTerm().getVars());
        }

        @Override
        public VarSet visit(Finite.FiniteRangeRhs expr, VarSet data) {
            return data;
        }
    }
}

