/*
 * Decompiled with CFR 0.152.
 */
package bindead.abstractsyntax.finite.util;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.Linear;
import bindead.exceptions.Unreachable;
import javalx.numeric.BigInt;

public class FiniteTestSimplifier {
    private static final FiniteFactory finite = FiniteFactory.getInstance();
    private static final Finite.Test trueTest = finite.equalTo(1, Linear.ONE, Linear.ONE);
    private static final Finite.Test falseTest = finite.equalTo(1, Linear.ZERO, Linear.ONE);

    public static Finite.Test normalizeTautology(Finite.Test test) {
        Linear rhs;
        Linear lhs = test.getLeftExpr();
        if (lhs.equals(rhs = test.getRightExpr())) {
            return FiniteTestSimplifier.hasEqualSides(test);
        }
        return test;
    }

    private static Finite.Test hasEqualSides(Finite.Test test) {
        switch (test.getOperator()) {
            case Equal: {
                return trueTest;
            }
            case NotEqual: {
                return falseTest;
            }
            case SignedLessThan: {
                return falseTest;
            }
            case SignedLessThanOrEqual: {
                return trueTest;
            }
            case UnsignedLessThan: {
                return falseTest;
            }
            case UnsignedLessThanOrEqual: {
                return trueTest;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isTautology(Finite.Test test) {
        try {
            return FiniteTestSimplifier.isTautologyReportUnreachable(test);
        }
        catch (Unreachable e) {
            return true;
        }
    }

    public static boolean isTautologyReportUnreachable(Finite.Test test) throws Unreachable {
        Linear lhs = test.getLeftExpr();
        Linear rhs = test.getRightExpr();
        if (lhs.isConstantOnly() && rhs.isConstantOnly()) {
            BigInt lhsValue = lhs.getConstant();
            BigInt rhsValue = rhs.getConstant();
            switch (test.getOperator()) {
                case Equal: {
                    if (lhsValue.isEqualTo(rhsValue)) {
                        return true;
                    }
                    throw new Unreachable();
                }
                case NotEqual: {
                    if (!lhsValue.isEqualTo(rhsValue)) {
                        return true;
                    }
                    throw new Unreachable();
                }
            }
            return false;
        }
        return false;
    }
}

