/*
 * Decompiled with CFR 0.152.
 */
package bindead.abstractsyntax.finite;

import bindead.abstractsyntax.finite.Finite;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domains.fields.VariableCtx;
import javalx.numeric.BigInt;
import javalx.numeric.Interval;
import rreil.lang.BinOp;
import rreil.lang.ComparisonOp;

public class FiniteFactory {
    private static final FiniteFactory INSTANCE = new FiniteFactory();

    private FiniteFactory() {
    }

    public static FiniteFactory getInstance() {
        return INSTANCE;
    }

    public Finite.Bin binary(Finite.Rlin left, BinOp op, Finite.Rlin right) {
        return new Finite.Bin(left, op, right);
    }

    public Finite.Cmp comparison(Finite.Rlin left, ComparisonOp op, Finite.Rlin right) {
        return new Finite.Cmp(left, op, right);
    }

    public Finite.SignExtend signExtend(Finite.Rlin rhs) {
        return new Finite.SignExtend(rhs);
    }

    public Finite.Convert convert(Finite.Rlin rhs) {
        return new Finite.Convert(rhs);
    }

    public Finite.FiniteRangeRhs range(int size, Interval range) {
        return new Finite.FiniteRangeRhs(size, range);
    }

    public Finite.Assign assign(Finite.Lhs lhs, Finite.Rhs rhs) {
        return new Finite.Assign(lhs, rhs);
    }

    public Finite.Rlin linear(int size, NumVar id) {
        return new Finite.Rlin(size, Linear.linear(id));
    }

    public Finite.Rlin linear(int size, Linear linear) {
        return new Finite.Rlin(size, linear);
    }

    public Finite.Rlin linear(VariableCtx ctx) {
        return this.linear(ctx.getSize(), ctx.getVariable());
    }

    public Finite.Rlin literal(int size, BigInt value) {
        return new Finite.Rlin(size, Linear.linear(value));
    }

    public Finite.Lhs variable(int size, NumVar id) {
        return new Finite.Lhs(size, id);
    }

    public Finite.Test equalToZero(int size, NumVar id) {
        return this.equalTo(size, Linear.linear(id), Linear.ZERO);
    }

    public Finite.Test equalToZero(Finite.Rlin rhs) {
        return this.equalTo(rhs.getSize(), rhs.getLinearTerm(), Linear.ZERO);
    }

    public Finite.Test notEqualTo(int size, Linear left, Linear right) {
        return new Finite.Test(size, left, Finite.TestOp.NotEqual, right);
    }

    public Finite.Test notEqualToZero(int size, NumVar id) {
        return this.notEqualTo(size, Linear.linear(id), Linear.ZERO);
    }

    public Finite.Test notEqualToZero(Finite.Rlin rhs) {
        return this.notEqualTo(rhs.getSize(), rhs.getLinearTerm(), Linear.ZERO);
    }

    public Finite.Test equalToOne(int size, NumVar id) {
        return this.equalTo(size, Linear.linear(id), Linear.ONE);
    }

    public Finite.Test equalTo(int size, Linear left, Linear right) {
        return new Finite.Test(size, left, Finite.TestOp.Equal, right);
    }

    public Finite.Test equalTo(int size, NumVar left, NumVar right) {
        return new Finite.Test(size, Linear.linear(left), Finite.TestOp.Equal, Linear.linear(right));
    }

    public Finite.Test signedLessThanOrEqualTo(int size, Linear left, Linear right) {
        return new Finite.Test(size, left, Finite.TestOp.SignedLessThanOrEqual, right);
    }

    public Finite.Test signedLessThan(int size, Linear left, Linear right) {
        return new Finite.Test(size, left, Finite.TestOp.SignedLessThan, right);
    }

    public Finite.Test unsignedLessThanOrEqualTo(int size, Linear left, Linear right) {
        return new Finite.Test(size, left, Finite.TestOp.UnsignedLessThanOrEqual, right);
    }

    public Finite.Test unsignedLessThan(int size, Linear left, Linear right) {
        return new Finite.Test(size, left, Finite.TestOp.UnsignedLessThan, right);
    }

    public Finite.Test test(Finite.Cmp cmp) {
        return cmp.asTest();
    }
}

