/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.DoubleScalar;
import apron.MpfrScalar;
import apron.Scalar;
import gmp.Mpfr;
import gmp.Mpq;
import gmp.Mpz;
import java.io.Serializable;
import java.math.BigInteger;

public class MpqScalar
extends Scalar
implements Cloneable,
Serializable {
    public Mpq val;

    public MpqScalar() {
        this.val = new Mpq();
    }

    public MpqScalar(MpqScalar mpqScalar) {
        this.val = new Mpq(mpqScalar.val);
    }

    public MpqScalar(Mpq mpq) {
        this.val = new Mpq(mpq);
    }

    public MpqScalar(Mpz mpz) {
        this.val = new Mpq(mpz);
    }

    public MpqScalar(int n) {
        this.val = new Mpq(n);
    }

    public MpqScalar(int n, int n2) {
        this.val = new Mpq(n, n2);
    }

    public MpqScalar(Mpz mpz, Mpz mpz2) {
        this.val = new Mpq(mpz, mpz2);
    }

    public MpqScalar(BigInteger bigInteger) {
        this.val = new Mpq(bigInteger);
    }

    public MpqScalar(BigInteger bigInteger, BigInteger bigInteger2) {
        this.val = new Mpq(bigInteger, bigInteger2);
    }

    @Override
    public MpqScalar copy() {
        return new MpqScalar(this);
    }

    public void set(MpqScalar mpqScalar) {
        this.val.set(mpqScalar.val);
    }

    public void set(Mpq mpq) {
        this.val.set(mpq);
    }

    public void set(Mpz mpz) {
        this.val.set(mpz);
    }

    @Override
    public void set(int n) {
        this.val.set(n);
    }

    public void set(int n, int n2) {
        this.val.set(n, n2);
        if (n2 != 0) {
            this.val.canonicalize();
        }
    }

    public void set(BigInteger bigInteger) {
        this.val.set(bigInteger);
    }

    public void set(BigInteger bigInteger, BigInteger bigInteger2) {
        this.val.set(bigInteger, bigInteger2);
        if (bigInteger2.signum() != 0) {
            this.val.canonicalize();
        }
    }

    @Override
    public void setInfty(int n) {
        if (n > 0) {
            this.val.set(1, 0);
        } else if (n < 0) {
            this.val.set(-1, 0);
        } else {
            this.val.set(0);
        }
    }

    public Mpq get() {
        return this.val;
    }

    @Override
    public int toMpq(Mpq mpq, int n) {
        int n2 = this.isInfty();
        if (n2 > 0) {
            mpq.set(1, 0);
        } else if (n2 < 0) {
            mpq.set(-1, 0);
        } else {
            mpq.set(this.val);
        }
        return 0;
    }

    @Override
    public int toMpfr(Mpfr mpfr, int n) {
        int n2 = this.isInfty();
        if (n2 != 0) {
            mpfr.setInf(n2);
            return 0;
        }
        return mpfr.set(this.val, n);
    }

    @Override
    public int toDouble(double[] dArray, int n) {
        int n2 = this.isInfty();
        if (n2 > 0) {
            dArray[0] = Double.POSITIVE_INFINITY;
            return 0;
        }
        if (n2 < 0) {
            dArray[0] = Double.NEGATIVE_INFINITY;
            return 0;
        }
        Mpfr mpfr = new Mpfr(53);
        int n3 = mpfr.set(this.val, n);
        dArray[0] = mpfr.doubleValue(n);
        return n3;
    }

    @Override
    public String toString() {
        int n = this.isInfty();
        if (n > 0) {
            return "+oo";
        }
        if (n < 0) {
            return "-oo";
        }
        return this.val.toString();
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public int isInfty() {
        if (this.val.getDen().sgn() == 0) {
            return this.val.sgn();
        }
        return 0;
    }

    @Override
    public boolean isZero() {
        return this.val.sgn() == 0;
    }

    public int cmp(MpqScalar mpqScalar) {
        int n;
        int n2 = this.isInfty();
        if (n2 > (n = mpqScalar.isInfty())) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        if (n2 != 0) {
            return 0;
        }
        return this.val.cmp(mpqScalar.val);
    }

    @Override
    public int cmp(Scalar scalar) {
        int n;
        int n2 = this.isInfty();
        if (n2 > (n = scalar.isInfty())) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        if (n2 != 0) {
            return 0;
        }
        if (scalar instanceof MpqScalar) {
            return this.val.cmp(((MpqScalar)scalar).val);
        }
        if (scalar instanceof MpfrScalar) {
            return -((MpfrScalar)scalar).val.cmp(this.val);
        }
        if (scalar instanceof DoubleScalar) {
            Mpfr mpfr = new Mpfr(53);
            mpfr.set(((DoubleScalar)scalar).val, 0);
            return -mpfr.cmp(this.val);
        }
        throw new IllegalArgumentException("unknown Scalar subtype");
    }

    @Override
    public int cmp(int n) {
        int n2 = this.isInfty();
        if (n2 != 0) {
            return n2;
        }
        return this.val.cmp(n, 1);
    }

    public boolean isEqual(MpqScalar mpqScalar) {
        int n;
        int n2 = this.isInfty();
        if (n2 != (n = mpqScalar.isInfty())) {
            return false;
        }
        if (n2 != 0) {
            return true;
        }
        return this.val.isEqual(mpqScalar.val);
    }

    @Override
    public boolean isEqual(Scalar scalar) {
        int n;
        int n2 = this.isInfty();
        if (n2 != (n = scalar.isInfty())) {
            return false;
        }
        if (n2 != 0) {
            return true;
        }
        if (scalar instanceof MpqScalar) {
            return this.val.isEqual(((MpqScalar)scalar).val);
        }
        if (scalar instanceof MpfrScalar) {
            return ((MpfrScalar)scalar).val.cmp(this.val) == 0;
        }
        if (scalar instanceof DoubleScalar) {
            Mpfr mpfr = new Mpfr(53);
            mpfr.set(((DoubleScalar)scalar).val, 0);
            return mpfr.cmp(this.val) == 0;
        }
        throw new IllegalArgumentException("unknown Scalar subtype");
    }

    @Override
    public boolean isEqual(int n) {
        if (this.isInfty() != 0) {
            return false;
        }
        return this.val.cmp(n, 1) == 0;
    }

    @Override
    public int sgn() {
        return this.val.sgn();
    }

    @Override
    public void neg() {
        this.val.neg();
    }

    @Override
    public void inv() {
        this.val.inv();
    }

    public MpqScalar clone() throws CloneNotSupportedException {
        return this.copy();
    }
}

