/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.DoubleScalar;
import apron.MpqScalar;
import apron.Scalar;
import gmp.Mpfr;
import gmp.Mpq;
import gmp.Mpz;
import java.io.Serializable;

public class MpfrScalar
extends Scalar
implements Cloneable,
Serializable {
    public Mpfr val;

    public MpfrScalar() {
        this.val = new Mpfr();
    }

    public MpfrScalar(int n) {
        this.val = new Mpfr(n);
    }

    public MpfrScalar(MpfrScalar mpfrScalar) {
        this.val = new Mpfr(mpfrScalar.val);
    }

    public MpfrScalar(Mpfr mpfr) {
        this.val = new Mpfr(mpfr);
    }

    public MpfrScalar(double d, int n) {
        this.val = new Mpfr(d, n);
    }

    @Override
    public MpfrScalar copy() {
        return new MpfrScalar(this);
    }

    public void set(MpfrScalar mpfrScalar) {
        this.val.set(mpfrScalar.val);
    }

    public void set(Mpfr mpfr) {
        this.val.set(mpfr);
    }

    public void set(Mpfr mpfr, int n) {
        this.val.set(mpfr, n);
    }

    public void set(double d, int n) {
        this.val.set(d, n);
    }

    @Override
    public void set(int n) {
        this.val.set(n, 0);
    }

    @Override
    public void setInfty(int n) {
        this.val.setInf(n);
    }

    public Mpfr get() {
        return this.val;
    }

    @Override
    public int toMpq(Mpq mpq, int n) {
        if (this.val.isNaN()) {
            mpq.set(0);
            return 1;
        }
        if (this.val.isInf()) {
            if (this.val.sgn() > 0) {
                mpq.set(1, 0);
            } else {
                mpq.set(-1, 0);
            }
            return 0;
        }
        Mpz mpz = new Mpz();
        int n2 = this.val.MpzExponentValue(mpz);
        mpq.set(mpz);
        mpq.mul2exp(n2);
        return 0;
    }

    @Override
    public int toMpfr(Mpfr mpfr, int n) {
        mpfr.setPrec(this.val.getPrec());
        mpfr.set(this.val);
        return 0;
    }

    @Override
    public int toDouble(double[] dArray, int n) {
        dArray[0] = this.val.doubleValue(n);
        return this.val.cmp(dArray[0]);
    }

    @Override
    public String toString() {
        return this.val.toString();
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public int isInfty() {
        if (this.val.isInf()) {
            return this.val.sgn();
        }
        return 0;
    }

    @Override
    public boolean isZero() {
        return this.val.cmp(0) == 0;
    }

    public int cmp(MpfrScalar mpfrScalar) {
        return this.val.cmp(mpfrScalar.val);
    }

    @Override
    public int cmp(int n) {
        return this.val.cmp(n);
    }

    @Override
    public int cmp(Scalar scalar) {
        if (scalar instanceof MpfrScalar) {
            return this.val.cmp(((MpfrScalar)scalar).val);
        }
        if (scalar instanceof DoubleScalar) {
            return this.val.cmp(((DoubleScalar)scalar).val);
        }
        if (scalar instanceof MpqScalar) {
            int n;
            int n2 = this.isInfty();
            if (n2 > (n = scalar.isInfty())) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            if (n2 != 0) {
                return 0;
            }
            return this.val.cmp(((MpqScalar)scalar).val);
        }
        throw new IllegalArgumentException("unknown Scalar subtype");
    }

    public boolean isEqual(MpfrScalar mpfrScalar) {
        return this.val.isEqual(mpfrScalar.val);
    }

    @Override
    public boolean isEqual(int n) {
        return this.val.cmp(n) == 0;
    }

    @Override
    public boolean isEqual(Scalar scalar) {
        if (scalar instanceof MpfrScalar) {
            return this.val.isEqual(((MpfrScalar)scalar).val);
        }
        if (scalar instanceof DoubleScalar) {
            return this.val.cmp(((DoubleScalar)scalar).val) == 0;
        }
        if (scalar instanceof MpqScalar) {
            int n;
            int n2 = this.isInfty();
            if (n2 != (n = scalar.isInfty())) {
                return false;
            }
            if (n2 != 0) {
                return true;
            }
            return this.val.cmp(((MpqScalar)scalar).val) == 0;
        }
        throw new IllegalArgumentException("unknown Scalar subtype");
    }

    @Override
    public int sgn() {
        return this.val.sgn();
    }

    @Override
    public void neg() {
        this.val.neg(0);
    }

    @Override
    public void inv() {
        this.val.div(1, this.val, 0);
    }

    public MpfrScalar clone() throws CloneNotSupportedException {
        return this.copy();
    }
}

