/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Coeff;
import apron.Environment;
import apron.Lincons0;
import apron.Linexpr1;
import apron.Linterm0;
import apron.Linterm1;
import apron.Scalar;
import java.io.Serializable;

public class Lincons1
implements Cloneable,
Serializable {
    protected Lincons0 cons;
    protected Environment env;
    public static final int EQ = 0;
    public static final int SUPEQ = 1;
    public static final int SUP = 2;
    public static final int EQMOD = 3;
    public static final int DISEQ = 4;

    private Lincons1() {
    }

    public static Lincons1 make(Environment environment, Lincons0 lincons0) {
        Lincons1 lincons1 = new Lincons1();
        lincons1.cons = lincons0;
        lincons1.env = environment;
        return lincons1;
    }

    public Lincons1(Environment environment) {
        this.cons = new Lincons0();
        this.env = environment;
    }

    public Lincons1(Environment environment, boolean bl) {
        this.cons = new Lincons0(bl);
        this.env = environment;
    }

    public Lincons1(int n, Linexpr1 linexpr1) {
        this.cons = new Lincons0(n, linexpr1.getLinexpr0());
        this.env = linexpr1.getEnvironment();
    }

    public Lincons1(int n, Linexpr1 linexpr1, Scalar scalar) {
        this.cons = new Lincons0(n, linexpr1.getLinexpr0(), scalar);
        this.env = linexpr1.getEnvironment();
    }

    public Lincons1(Lincons1 lincons1) {
        this.cons = new Lincons0(lincons1.cons);
        this.env = lincons1.env;
    }

    public Lincons1(Environment environment, Lincons0 lincons0) {
        if (environment.getSize() < lincons0.maxDim()) {
            throw new IllegalArgumentException("environment is too small");
        }
        this.cons = new Lincons0(lincons0);
        this.env = environment;
    }

    public void setCst(Coeff coeff) {
        this.cons.setCst(coeff);
    }

    public void setCoeff(String string, Coeff coeff) {
        this.cons.setCoeff(this.env.dimOfVar(string), coeff);
    }

    public void setCoeff(Linterm1[] linterm1Array) {
        for (int i = 0; i < linterm1Array.length; ++i) {
            this.setCoeff(linterm1Array[i].var, linterm1Array[i].coeff);
        }
    }

    public void setKind(int n) {
        this.cons.kind = n;
    }

    public void setScalar(Scalar scalar) {
        this.cons.scalar = scalar == null ? null : scalar.copy();
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public int getKind() {
        return this.cons.kind;
    }

    public Scalar getScalar() {
        return this.cons.scalar;
    }

    public Lincons0 getLincons0() {
        return new Lincons0(this.cons);
    }

    public Lincons0 getLincons0Ref() {
        return this.cons;
    }

    public Coeff getCst() {
        return this.cons.getCst();
    }

    public Coeff getCoeff(String string) {
        return this.cons.getCoeff(this.env.dimOfVar(string));
    }

    public Linterm1[] getLinterms() {
        Linterm0[] linterm0Array = this.cons.getLinterms();
        Linterm1[] linterm1Array = new Linterm1[linterm0Array.length];
        for (int i = 0; i < linterm0Array.length; ++i) {
            linterm1Array[i] = new Linterm1(this.env.varOfDim(linterm0Array[i].dim), linterm0Array[i].coeff);
        }
        return linterm1Array;
    }

    public Coeff[] getCoeffs() {
        return this.cons.getCoeffs();
    }

    public String toString() {
        return this.cons.toString(this.env.getVars());
    }

    public int hashCode() {
        return this.cons.hashCode() ^ this.env.hashCode();
    }

    public boolean isSparse() {
        return this.cons.isSparse();
    }

    public boolean isInteger() {
        return this.cons.isInteger(this.env.getDimension().intDim);
    }

    public boolean isReal() {
        return this.cons.isReal(this.env.getDimension().intDim);
    }

    public boolean isLinear() {
        return this.cons.isLinear();
    }

    public boolean isQuasilinear() {
        return this.cons.isQuasilinear();
    }

    public boolean isUnsat() {
        return this.cons.isUnsat();
    }

    public boolean isEqual(Lincons1 lincons1) {
        return this.env.isEqual(lincons1.env) && this.cons.isEqual(lincons1.cons);
    }

    public void minimize() {
        this.cons.minimize();
    }

    public void extendEnvironment(Environment environment) {
        this.cons.addDimensions(this.env.dimchange(environment));
        this.env = environment;
    }

    public Lincons1 extendEnvironmentCopy(Environment environment) {
        return Lincons1.make(environment, this.cons.addDimensionsCopy(this.env.dimchange(environment)));
    }

    public Lincons1 clone() throws CloneNotSupportedException {
        return new Lincons1(this);
    }

    public boolean equals(Object object) {
        return object instanceof Lincons1 && this.isEqual((Lincons1)object);
    }
}

