/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import nb.barmie.util.support.ClassDataDesc;
import nb.barmie.util.support.ClassDetails;
import nb.barmie.util.support.ClassField;

public class SerializationDumper {
    private final LinkedList<Byte> _data = new LinkedList();
    private String _indent = "";
    private int _handleValue = 0x7E0000;
    private final ArrayList<ClassDataDesc> _classDataDescriptions = new ArrayList();

    public static void main(String[] args) throws Exception {
        SerializationDumper sd = new SerializationDumper();
        if (args.length == 0 || args.length > 2) {
            System.out.println("Usage:");
            System.out.println("\tSerializationDumper <hex-ascii-data>");
            System.out.println("\tSerializationDumper -f <file-containing-hex-ascii>");
            System.out.println("\tSerializationDumper -r <file-containing-raw-data>");
        }
        if (args.length == 1) {
            for (int i = 0; i < args[0].length() / 2; ++i) {
                sd._data.add((byte)((Character.digit(args[0].charAt(i * 2), 16) << 4) + Character.digit(args[0].charAt(i * 2 + 1), 16)));
            }
        } else {
            File f = new File(args[1]);
            FileInputStream fis = new FileInputStream(f);
            byte[] fileContents = new byte[(int)f.length()];
            fis.read(fileContents);
            fis.close();
            if (args[0].toLowerCase().equals("-f")) {
                for (int i = 0; i < fileContents.length / 2; ++i) {
                    sd._data.add((byte)((Character.digit(fileContents[i * 2], 16) << 4) + Character.digit(fileContents[i * 2 + 1], 16)));
                }
            } else if (args[0].toLowerCase().equals("-r")) {
                for (int i = 0; i < fileContents.length; ++i) {
                    sd._data.add(fileContents[i]);
                }
            }
        }
        System.out.println("");
        sd.parseStream();
    }

    private void print(String s) {
        System.out.println(this._indent + s);
    }

    private void increaseIndent() {
        this._indent = this._indent + "  ";
    }

    private void decreaseIndent() {
        if (this._indent.length() < 2) {
            throw new RuntimeException("Error: Illegal indentation decrease.");
        }
        this._indent = this._indent.substring(0, this._indent.length() - 2);
    }

    private String byteToHex(byte b) {
        return String.format("%02x", b);
    }

    private String intToHex(int i) {
        return String.format("%02x", (i & 0xFF000000) >> 24) + String.format(" %02x", (i & 0xFF0000) >> 16) + String.format(" %02x", (i & 0xFF00) >> 8) + String.format(" %02x", i & 0xFF);
    }

    private int newHandle() {
        int handleValue = this._handleValue++;
        this.print("newHandle 0x" + this.intToHex(handleValue));
        return handleValue;
    }

    private void parseStream() throws Exception {
        byte b1;
        if (this._data.peek() != -84) {
            b1 = this._data.pop();
            switch (b1) {
                case 80: {
                    this.print("RMI Call - 0x50");
                    break;
                }
                case 81: {
                    this.print("RMI ReturnData - 0x51");
                    break;
                }
                case 82: {
                    this.print("RMI Ping - 0x52");
                    break;
                }
                case 83: {
                    this.print("RMI PingAck - 0x53");
                    break;
                }
                case 84: {
                    this.print("RMI DgcAck - 0x54");
                    break;
                }
                default: {
                    this.print("Unknown RMI packet type - 0x" + this.byteToHex(b1));
                }
            }
        }
        b1 = this._data.pop();
        byte b2 = this._data.pop();
        this.print("STREAM_MAGIC - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2));
        if (b1 != -84 || b2 != -19) {
            this.print("Invalid STREAM_MAGIC, should be 0xac ed");
            return;
        }
        b1 = this._data.pop();
        b2 = this._data.pop();
        this.print("STREAM_VERSION - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2));
        if (b1 != 0 || b2 != 5) {
            this.print("Invalid STREAM_VERSION, should be 0x00 05");
        }
        this.print("Contents");
        this.increaseIndent();
        while (this._data.size() > 0) {
            this.readContentElement();
        }
        this.decreaseIndent();
    }

    private void readContentElement() {
        switch (this._data.peek()) {
            case 115: {
                this.readNewObject();
                break;
            }
            case 118: {
                this.readNewClass();
                break;
            }
            case 117: {
                this.readNewArray();
                break;
            }
            case 116: 
            case 124: {
                this.readNewString();
                break;
            }
            case 126: {
                this.readNewEnum();
                break;
            }
            case 114: 
            case 125: {
                this.readNewClassDesc();
                break;
            }
            case 113: {
                this.readPrevObject();
                break;
            }
            case 112: {
                this.readNullReference();
                break;
            }
            case 119: {
                this.readBlockData();
                break;
            }
            case 122: {
                this.readLongBlockData();
                break;
            }
            default: {
                this.print("Invalid content element type 0x" + this.byteToHex(this._data.peek()));
                throw new RuntimeException("Error: Illegal content element type.");
            }
        }
    }

    private void readNewEnum() {
        byte b1 = this._data.pop();
        this.print("TC_ENUM - 0x" + this.byteToHex(b1));
        if (b1 != 126) {
            throw new RuntimeException("Error: Illegal value for TC_ENUM (should be 0x7e)");
        }
        this.increaseIndent();
        this.readClassDesc();
        this.newHandle();
        this.readNewString();
        this.decreaseIndent();
    }

    private void readNewObject() {
        byte b1 = this._data.pop();
        this.print("TC_OBJECT - 0x" + this.byteToHex(b1));
        if (b1 != 115) {
            throw new RuntimeException("Error: Illegal value for TC_OBJECT (should be 0x73)");
        }
        this.increaseIndent();
        ClassDataDesc cdd = this.readClassDesc();
        this.newHandle();
        this.readClassData(cdd);
        this.decreaseIndent();
    }

    private ClassDataDesc readClassDesc() {
        switch (this._data.peek()) {
            case 114: 
            case 125: {
                return this.readNewClassDesc();
            }
            case 112: {
                this.readNullReference();
                return null;
            }
            case 113: {
                int refHandle = this.readPrevObject();
                for (ClassDataDesc cdd : this._classDataDescriptions) {
                    for (int classIndex = 0; classIndex < cdd.getClassCount(); ++classIndex) {
                        if (cdd.getClassDetails(classIndex).getHandle() != refHandle) continue;
                        return cdd.buildClassDataDescFromIndex(classIndex);
                    }
                }
                throw new RuntimeException("Error: Invalid classDesc reference (0x" + this.intToHex(refHandle));
            }
        }
        this.print("Invalid classDesc type 0x" + this.byteToHex(this._data.peek()));
        throw new RuntimeException("Error illegal classDesc type.");
    }

    private ClassDataDesc readNewClassDesc() {
        switch (this._data.peek()) {
            case 114: {
                ClassDataDesc cdd = this.readTC_CLASSDESC();
                this._classDataDescriptions.add(cdd);
                return cdd;
            }
            case 125: {
                return this.readTC_PROXYCLASSDESC();
            }
        }
        this.print("Invalid newClassDesc type 0x" + this.byteToHex(this._data.peek()));
        throw new RuntimeException("Error illegal newClassDesc type.");
    }

    private ClassDataDesc readTC_CLASSDESC() {
        ClassDataDesc cdd = new ClassDataDesc();
        byte b1 = this._data.pop();
        this.print("TC_CLASSDESC - 0x" + this.byteToHex(b1));
        if (b1 != 114) {
            throw new RuntimeException("Error: Illegal value for TC_CLASSDESC (should be 0x72)");
        }
        this.increaseIndent();
        this.print("className");
        this.increaseIndent();
        cdd.addClass(this.readUtf());
        this.decreaseIndent();
        this.print("serialVersionUID - 0x" + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()));
        cdd.setLastClassHandle(this.newHandle());
        this.readClassDescInfo(cdd);
        this.decreaseIndent();
        return cdd;
    }

    private ClassDataDesc readTC_PROXYCLASSDESC() {
        ClassDataDesc cdd = new ClassDataDesc();
        byte b1 = this._data.pop();
        this.print("TC_PROXYCLASSDESC - 0x" + this.byteToHex(b1));
        if (b1 != 125) {
            throw new RuntimeException("Error: Illegal value for TC_PROXYCLASSDESC (should be 0x7d)");
        }
        this.increaseIndent();
        this.newHandle();
        this.readProxyClassDescInfo(cdd);
        this.decreaseIndent();
        return cdd;
    }

    private void readClassDescInfo(ClassDataDesc cdd) {
        String classDescFlags = "";
        byte b1 = this._data.pop();
        if ((b1 & 1) == 1) {
            classDescFlags = classDescFlags + "SC_WRITE_METHOD | ";
        }
        if ((b1 & 2) == 2) {
            classDescFlags = classDescFlags + "SC_SERIALIZABLE | ";
        }
        if ((b1 & 4) == 4) {
            classDescFlags = classDescFlags + "SC_EXTERNALIZABLE | ";
        }
        if ((b1 & 8) == 8) {
            classDescFlags = classDescFlags + "SC_BLOCKDATA | ";
        }
        if (classDescFlags.length() > 0) {
            classDescFlags = classDescFlags.substring(0, classDescFlags.length() - 3);
        }
        this.print("classDescFlags - 0x" + this.byteToHex(b1) + " - " + classDescFlags);
        cdd.setLastClassDescFlags(b1);
        if ((b1 & 2) == 2) {
            if ((b1 & 4) == 4) {
                throw new RuntimeException("Error: Illegal classDescFlags, SC_SERIALIZABLE is not compatible with SC_EXTERNALIZABLE.");
            }
            if ((b1 & 8) == 8) {
                throw new RuntimeException("Error: Illegal classDescFlags, SC_SERIALIZABLE is not compatible with SC_BLOCKDATA.");
            }
        } else if ((b1 & 4) == 4) {
            if ((b1 & 1) == 1) {
                throw new RuntimeException("Error: Illegal classDescFlags, SC_EXTERNALIZABLE is not compatible with SC_WRITE_METHOD.");
            }
        } else if (b1 != 0) {
            throw new RuntimeException("Error: Illegal classDescFlags, must include either SC_SERIALIZABLE or SC_EXTERNALIZABLE.");
        }
        this.readFields(cdd);
        this.readClassAnnotation();
        cdd.addSuperClassDesc(this.readSuperClassDesc());
    }

    private void readProxyClassDescInfo(ClassDataDesc cdd) {
        byte b1 = this._data.pop();
        byte b2 = this._data.pop();
        byte b3 = this._data.pop();
        byte b4 = this._data.pop();
        int count = (b1 << 24 & 0xFF000000) + (b2 << 16 & 0xFF0000) + (b3 << 8 & 0xFF00) + (b4 & 0xFF);
        this.print("Interface count - " + count + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2) + " " + this.byteToHex(b3) + " " + this.byteToHex(b4));
        this.print("proxyInterfaceNames");
        this.increaseIndent();
        for (int i = 0; i < count; ++i) {
            this.print(i + ":");
            this.increaseIndent();
            this.readUtf();
            this.decreaseIndent();
        }
        this.decreaseIndent();
        this.readClassAnnotation();
        cdd.addSuperClassDesc(this.readSuperClassDesc());
    }

    private void readClassAnnotation() {
        this.print("classAnnotations");
        this.increaseIndent();
        while (this._data.peek() != 120) {
            this.readContentElement();
        }
        this._data.pop();
        this.print("TC_ENDBLOCKDATA - 0x78");
        this.decreaseIndent();
    }

    private ClassDataDesc readSuperClassDesc() {
        this.print("superClassDesc");
        this.increaseIndent();
        ClassDataDesc cdd = this.readClassDesc();
        this.decreaseIndent();
        return cdd;
    }

    private void readFields(ClassDataDesc cdd) {
        byte b1 = this._data.pop();
        byte b2 = this._data.pop();
        int count = (b1 << 8 & 0xFF00) + (b2 & 0xFF);
        this.print("fieldCount - " + count + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2));
        if (count > 0) {
            this.print("Fields");
            this.increaseIndent();
            for (int i = 0; i < count; ++i) {
                this.print(i + ":");
                this.increaseIndent();
                this.readFieldDesc(cdd);
                this.decreaseIndent();
            }
            this.decreaseIndent();
        }
    }

    private void readFieldDesc(ClassDataDesc cdd) {
        byte b1 = this._data.pop();
        cdd.addFieldToLastClass(b1);
        switch ((char)b1) {
            case 'B': {
                this.print("Byte - B - 0x" + this.byteToHex(b1));
                break;
            }
            case 'C': {
                this.print("Char - C - 0x" + this.byteToHex(b1));
                break;
            }
            case 'D': {
                this.print("Double - D - 0x" + this.byteToHex(b1));
                break;
            }
            case 'F': {
                this.print("Float - F - 0x" + this.byteToHex(b1));
                break;
            }
            case 'I': {
                this.print("Int - I - 0x" + this.byteToHex(b1));
                break;
            }
            case 'J': {
                this.print("Long - L - 0x" + this.byteToHex(b1));
                break;
            }
            case 'S': {
                this.print("Short - S - 0x" + this.byteToHex(b1));
                break;
            }
            case 'Z': {
                this.print("Boolea - Z - 0x" + this.byteToHex(b1));
                break;
            }
            case '[': {
                this.print("Array - [ - 0x" + this.byteToHex(b1));
                break;
            }
            case 'L': {
                this.print("Object - L - 0x" + this.byteToHex(b1));
                break;
            }
            default: {
                throw new RuntimeException("Error: Illegal field type code ('" + (char)b1 + "', 0x" + this.byteToHex(b1) + ")");
            }
        }
        this.print("fieldName");
        this.increaseIndent();
        cdd.setLastFieldName(this.readUtf());
        this.decreaseIndent();
        if ((char)b1 == '[' || (char)b1 == 'L') {
            this.print("className1");
            this.increaseIndent();
            cdd.setLastFieldClassName1(this.readNewString());
            this.decreaseIndent();
        }
    }

    private void readClassData(ClassDataDesc cdd) {
        this.print("classdata");
        this.increaseIndent();
        if (cdd != null) {
            for (int classIndex = cdd.getClassCount() - 1; classIndex >= 0; --classIndex) {
                ClassDetails cd = cdd.getClassDetails(classIndex);
                this.print(cd.getClassName());
                this.increaseIndent();
                if (cd.isSC_SERIALIZABLE()) {
                    this.print("values");
                    this.increaseIndent();
                    for (ClassField cf : cd.getFields()) {
                        this.readClassDataField(cf);
                    }
                    this.decreaseIndent();
                }
                if (cd.isSC_SERIALIZABLE() && cd.isSC_WRITE_METHOD() || cd.isSC_EXTERNALIZABLE() && cd.isSC_BLOCKDATA()) {
                    this.print("objectAnnotation");
                    this.increaseIndent();
                    while (this._data.peek() != 120) {
                        this.readContentElement();
                    }
                    this._data.pop();
                    this.print("TC_ENDBLOCKDATA - 0x78");
                    this.decreaseIndent();
                }
                if (cd.isSC_EXTERNALIZABLE() && !cd.isSC_BLOCKDATA()) {
                    this.print("externalContents");
                    this.increaseIndent();
                    this.print("Unable to parse externalContents as the format is specific to the implementation class.");
                    throw new RuntimeException("Error: Unable to parse externalContents element.");
                }
                this.decreaseIndent();
            }
        } else {
            this.print("N/A");
        }
        this.decreaseIndent();
    }

    private void readClassDataField(ClassField cf) {
        this.print(cf.getName());
        this.increaseIndent();
        this.readFieldValue(cf.getTypeCode());
        this.decreaseIndent();
    }

    private void readFieldValue(byte typeCode) {
        switch ((char)typeCode) {
            case 'B': {
                this.readByteField();
                break;
            }
            case 'C': {
                this.readCharField();
                break;
            }
            case 'D': {
                this.readDoubleField();
                break;
            }
            case 'F': {
                this.readFloatField();
                break;
            }
            case 'I': {
                this.readIntField();
                break;
            }
            case 'J': {
                this.readLongField();
                break;
            }
            case 'S': {
                this.readShortField();
                break;
            }
            case 'Z': {
                this.readBooleanField();
                break;
            }
            case '[': {
                this.readArrayField();
                break;
            }
            case 'L': {
                this.readObjectField();
                break;
            }
            default: {
                throw new RuntimeException("Error: Illegal field type code ('" + typeCode + "', 0x" + this.byteToHex(typeCode) + ")");
            }
        }
    }

    private void readNewArray() {
        byte b1 = this._data.pop();
        this.print("TC_ARRAY - 0x" + this.byteToHex(b1));
        if (b1 != 117) {
            throw new RuntimeException("Error: Illegal value for TC_ARRAY (should be 0x75)");
        }
        this.increaseIndent();
        ClassDataDesc cdd = this.readClassDesc();
        if (cdd.getClassCount() != 1) {
            throw new RuntimeException("Error: Array class description made up of more than one class.");
        }
        ClassDetails cd = cdd.getClassDetails(0);
        if (cd.getClassName().charAt(0) != '[') {
            throw new RuntimeException("Error: Array class name does not begin with '['.");
        }
        this.newHandle();
        b1 = this._data.pop();
        byte b2 = this._data.pop();
        byte b3 = this._data.pop();
        byte b4 = this._data.pop();
        int size = (b1 << 24 & 0xFF000000) + (b2 << 16 & 0xFF0000) + (b3 << 8 & 0xFF00) + (b4 & 0xFF);
        this.print("Array size - " + size + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2) + " " + this.byteToHex(b3) + " " + this.byteToHex(b4));
        this.print("Values");
        this.increaseIndent();
        for (int i = 0; i < size; ++i) {
            this.print("Index " + i + ":");
            this.increaseIndent();
            this.readFieldValue((byte)cd.getClassName().charAt(1));
            this.decreaseIndent();
        }
        this.decreaseIndent();
        this.decreaseIndent();
    }

    private void readNewClass() {
        byte b1 = this._data.pop();
        this.print("TC_CLASS - 0x" + this.byteToHex(b1));
        if (b1 != 118) {
            throw new RuntimeException("Error: Illegal value for TC_CLASS (should be 0x76)");
        }
        this.increaseIndent();
        this.readClassDesc();
        this.newHandle();
    }

    private int readPrevObject() {
        byte b1 = this._data.pop();
        this.print("TC_REFERENCE - 0x" + this.byteToHex(b1));
        if (b1 != 113) {
            throw new RuntimeException("Error: Illegal value for TC_REFERENCE (should be 0x71)");
        }
        this.increaseIndent();
        b1 = this._data.pop();
        byte b2 = this._data.pop();
        byte b3 = this._data.pop();
        byte b4 = this._data.pop();
        int handle = (b1 << 24 & 0xFF000000) + (b2 << 16 & 0xFF0000) + (b3 << 8 & 0xFF00) + (b4 & 0xFF);
        this.print("Handle - " + handle + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2) + " " + this.byteToHex(b3) + " " + this.byteToHex(b4));
        this.decreaseIndent();
        return handle;
    }

    private void readNullReference() {
        byte b1 = this._data.pop();
        this.print("TC_NULL - 0x" + this.byteToHex(b1));
        if (b1 != 112) {
            throw new RuntimeException("Error: Illegal value for TC_NULL (should be 0x70)");
        }
    }

    private void readBlockData() {
        String contents = "";
        byte b1 = this._data.pop();
        this.print("TC_BLOCKDATA - 0x" + this.byteToHex(b1));
        if (b1 != 119) {
            throw new RuntimeException("Error: Illegal value for TC_BLOCKDATA (should be 0x77)");
        }
        this.increaseIndent();
        int len = this._data.pop().byteValue();
        this.print("Length - " + len + " - 0x" + this.byteToHex((byte)(len & 0xFF)));
        for (int i = 0; i < len; ++i) {
            contents = contents + this.byteToHex(this._data.pop());
        }
        this.print("Contents - 0x" + contents);
        this.decreaseIndent();
    }

    private void readLongBlockData() {
        String contents = "";
        byte b1 = this._data.pop();
        this.print("TC_BLOCKDATALONG - 0x" + this.byteToHex(b1));
        if (b1 != 122) {
            throw new RuntimeException("Error: Illegal value for TC_BLOCKDATA (should be 0x77)");
        }
        this.increaseIndent();
        b1 = this._data.pop();
        byte b2 = this._data.pop();
        byte b3 = this._data.pop();
        byte b4 = this._data.pop();
        long len = (b1 << 24 & 0xFF000000) + (b2 << 16 & 0xFF0000) + (b3 << 8 & 0xFF00) + (b4 & 0xFF);
        this.print("Length - " + len + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2) + " " + this.byteToHex(b3) + " " + this.byteToHex(b4));
        for (long l = 0L; l < len; ++l) {
            contents = contents + this.byteToHex(this._data.pop());
        }
        this.print("Contents - 0x" + contents);
        this.decreaseIndent();
    }

    private String readNewString() {
        switch (this._data.peek()) {
            case 116: {
                return this.readTC_STRING();
            }
            case 124: {
                return this.readTC_LONGSTRING();
            }
            case 113: {
                this.readPrevObject();
                return "[TC_REF]";
            }
        }
        this.print("Invalid newString type 0x" + this.byteToHex(this._data.peek()));
        throw new RuntimeException("Error illegal newString type.");
    }

    private String readTC_STRING() {
        byte b1 = this._data.pop();
        this.print("TC_STRING - 0x" + this.byteToHex(b1));
        if (b1 != 116) {
            throw new RuntimeException("Error: Illegal value for TC_STRING (should be 0x74)");
        }
        this.increaseIndent();
        this.newHandle();
        String val = this.readUtf();
        this.decreaseIndent();
        return val;
    }

    private String readTC_LONGSTRING() {
        byte b1 = this._data.pop();
        this.print("TC_LONGSTRING - 0x" + this.byteToHex(b1));
        if (b1 != 124) {
            throw new RuntimeException("Error: Illegal value for TC_LONGSTRING (should be 0x7c)");
        }
        this.increaseIndent();
        this.newHandle();
        String val = this.readLongUtf();
        this.decreaseIndent();
        return val;
    }

    private String readUtf() {
        String content = "";
        String hex = "";
        byte b1 = this._data.pop();
        byte b2 = this._data.pop();
        int len = (b1 << 8 & 0xFF00) + (b2 & 0xFF);
        this.print("Length - " + len + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2));
        for (int i = 0; i < len; ++i) {
            b1 = this._data.pop();
            content = content + (char)b1;
            hex = hex + this.byteToHex(b1);
        }
        this.print("Value - " + content + " - 0x" + hex);
        return content;
    }

    private String readLongUtf() {
        String content = "";
        String hex = "";
        byte b1 = this._data.pop();
        byte b2 = this._data.pop();
        byte b3 = this._data.pop();
        byte b4 = this._data.pop();
        byte b5 = this._data.pop();
        byte b6 = this._data.pop();
        byte b7 = this._data.pop();
        byte b8 = this._data.pop();
        long len = ((long)(b1 << 56) & 0xFF00000000000000L) + ((long)(b2 << 48) & 0xFF000000000000L) + ((long)(b3 << 40) & 0xFF0000000000L) + ((long)(b4 << 32) & 0xFF00000000L) + (long)(b5 << 24 & 0xFF000000) + (long)(b6 << 16 & 0xFF0000) + (long)(b7 << 8 & 0xFF00) + (long)(b8 & 0xFF);
        this.print("Length - " + len + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2) + " " + this.byteToHex(b3) + " " + this.byteToHex(b4) + " " + this.byteToHex(b5) + " " + this.byteToHex(b6) + " " + this.byteToHex(b7) + " " + this.byteToHex(b8));
        for (long l = 0L; l < len; ++l) {
            b1 = this._data.pop();
            content = content + (char)b1;
            hex = hex + this.byteToHex(b1);
        }
        this.print("Value - " + content + " - 0x" + hex);
        return content;
    }

    private void readByteField() {
        byte b1 = this._data.pop();
        if (b1 >= 32 && b1 <= 126) {
            this.print("(byte)" + b1 + " (ASCII: " + (char)b1 + ") - 0x" + this.byteToHex(b1));
        } else {
            this.print("(byte)" + b1 + " - 0x" + this.byteToHex(b1));
        }
    }

    private void readCharField() {
        byte b1 = this._data.pop();
        this.print("(char)" + (char)b1 + " - 0x" + this.byteToHex(b1));
    }

    private void readDoubleField() {
        byte b1 = this._data.pop();
        byte b2 = this._data.pop();
        byte b3 = this._data.pop();
        byte b4 = this._data.pop();
        byte b5 = this._data.pop();
        byte b6 = this._data.pop();
        byte b7 = this._data.pop();
        byte b8 = this._data.pop();
        this.print("(double)" + (double)(((long)(b1 << 56) & 0xFF00000000000000L) + ((long)(b2 << 48) & 0xFF000000000000L) + ((long)(b3 << 40) & 0xFF0000000000L) + ((long)(b4 << 32) & 0xFF00000000L) + (long)(b5 << 24 & 0xFF000000) + (long)(b6 << 16 & 0xFF0000) + (long)(b7 << 8 & 0xFF00) + (long)(b8 & 0xFF)) + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2) + " " + this.byteToHex(b3) + " " + this.byteToHex(b4) + " " + this.byteToHex(b5) + " " + this.byteToHex(b6) + " " + this.byteToHex(b7) + " " + this.byteToHex(b8));
    }

    private void readFloatField() {
        byte b1 = this._data.pop();
        byte b2 = this._data.pop();
        byte b3 = this._data.pop();
        byte b4 = this._data.pop();
        this.print("(float)" + (float)((b1 << 24 & 0xFF000000) + (b2 << 16 & 0xFF0000) + (b3 << 8 & 0xFF00) + (b4 & 0xFF)) + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2) + " " + this.byteToHex(b3) + " " + this.byteToHex(b4));
    }

    private void readIntField() {
        byte b1 = this._data.pop();
        byte b2 = this._data.pop();
        byte b3 = this._data.pop();
        byte b4 = this._data.pop();
        this.print("(int)" + ((b1 << 24 & 0xFF000000) + (b2 << 16 & 0xFF0000) + (b3 << 8 & 0xFF00) + (b4 & 0xFF)) + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2) + " " + this.byteToHex(b3) + " " + this.byteToHex(b4));
    }

    private void readLongField() {
        byte b1 = this._data.pop();
        byte b2 = this._data.pop();
        byte b3 = this._data.pop();
        byte b4 = this._data.pop();
        byte b5 = this._data.pop();
        byte b6 = this._data.pop();
        byte b7 = this._data.pop();
        byte b8 = this._data.pop();
        this.print("(long)" + (((long)(b1 << 56) & 0xFF00000000000000L) + ((long)(b2 << 48) & 0xFF000000000000L) + ((long)(b3 << 40) & 0xFF0000000000L) + ((long)(b4 << 32) & 0xFF00000000L) + (long)(b5 << 24 & 0xFF000000) + (long)(b6 << 16 & 0xFF0000) + (long)(b7 << 8 & 0xFF00) + (long)(b8 & 0xFF)) + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2) + " " + this.byteToHex(b3) + " " + this.byteToHex(b4) + " " + this.byteToHex(b5) + " " + this.byteToHex(b6) + " " + this.byteToHex(b7) + " " + this.byteToHex(b8));
    }

    private void readShortField() {
        byte b1 = this._data.pop();
        byte b2 = this._data.pop();
        this.print("(short)" + (short)((b1 << 8 & 0xFF00) + (b2 & 0xFF)) + " - 0x" + this.byteToHex(b1) + " " + this.byteToHex(b2));
    }

    private void readBooleanField() {
        byte b1 = this._data.pop();
        this.print("(boolean)" + (b1 == 0 ? "false" : "true") + " - 0x" + this.byteToHex(b1));
    }

    private void readArrayField() {
        this.print("(array)");
        this.increaseIndent();
        switch (this._data.peek()) {
            case 112: {
                this.readNullReference();
                break;
            }
            case 117: {
                this.readNewArray();
                break;
            }
            case 113: {
                this.readPrevObject();
                break;
            }
            default: {
                throw new RuntimeException("Error: Unexpected array field value type (0x" + this.byteToHex(this._data.peek()));
            }
        }
        this.decreaseIndent();
    }

    private void readObjectField() {
        this.print("(object)");
        this.increaseIndent();
        switch (this._data.peek()) {
            case 115: {
                this.readNewObject();
                break;
            }
            case 113: {
                this.readPrevObject();
                break;
            }
            case 112: {
                this.readNullReference();
                break;
            }
            case 116: {
                this.readTC_STRING();
                break;
            }
            case 118: {
                this.readNewClass();
                break;
            }
            case 117: {
                this.readNewArray();
                break;
            }
            default: {
                throw new RuntimeException("Error: Unexpected identifier for object field value 0x" + this.byteToHex(this._data.peek()));
            }
        }
        this.decreaseIndent();
    }
}

