/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.net.proxy;

import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import nb.barmie.net.proxy.ProxyServer;
import nb.barmie.net.proxy.ProxySession;
import nb.barmie.net.proxy.thread.PassThroughProxyThread;
import nb.barmie.net.proxy.thread.ReplyDataCapturingProxyThread;
import nb.barmie.util.ProgramOptions;

public class RMIReturnDataCapturingProxy
extends ProxyServer {
    private volatile boolean _reconnectOccurred = false;

    public RMIReturnDataCapturingProxy(InetAddress targetHost, int targetPort, ProgramOptions options) {
        super(targetHost, targetPort, options);
    }

    @Override
    protected ProxySession createProxySession(Socket clientSock, Socket targetSock) {
        if (this._proxySessions.size() == 1) {
            ((ProxySession)this._proxySessions.get(0)).shutdown();
            this._proxySessions.remove(0);
            this._reconnectOccurred = true;
        }
        return new ProxySession(new PassThroughProxyThread(clientSock, targetSock), new ReplyDataCapturingProxyThread(targetSock, clientSock));
    }

    public void resetDataBuffer() {
        if (this._proxySessions.size() == 1) {
            ((ReplyDataCapturingProxyThread)((ProxySession)this._proxySessions.get(0)).getInboundProxyThread()).resetDataBuffer();
        }
    }

    public ArrayList<Byte> getDataBuffer() {
        if (this._proxySessions.size() == 1) {
            return ((ReplyDataCapturingProxyThread)((ProxySession)this._proxySessions.get(0)).getInboundProxyThread()).getDataBuffer();
        }
        return null;
    }

    public boolean didReconnect() {
        return this._reconnectOccurred;
    }

    public void resetReconnectFlag() {
        this._reconnectOccurred = false;
    }
}

