/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.enumeration;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Collections;
import nb.barmie.modes.attack.DeserPayload;
import nb.barmie.modes.attack.DeserPayloadFactory;
import nb.barmie.modes.attack.RMIAttack;
import nb.barmie.modes.attack.RMIAttackFactory;
import nb.barmie.modes.enumeration.RMIEndpoint;
import nb.barmie.modes.enumeration.RMIEnumerator;
import nb.barmie.modes.enumeration.RMIObject;
import nb.barmie.net.TCPEndpoint;
import nb.barmie.util.ProgramOptions;

public class EnumerationTask
implements Runnable {
    private final TCPEndpoint _target;
    private final RMIEnumerator _enumerator;
    private final ProgramOptions _options;

    public EnumerationTask(TCPEndpoint target, RMIEnumerator rmie, ProgramOptions options) {
        this._target = target;
        this._enumerator = rmie;
        this._options = options;
    }

    @Override
    public void run() {
        String output = "";
        boolean deserAttackAvailable = false;
        boolean isLocalRegistry = false;
        int oi = 0;
        int ci = 0;
        RMIEndpoint ep = this._enumerator.enumerateEndpoint(this._target);
        if (this._target.getHost().startsWith("127.") || this._target.getHost().equalsIgnoreCase("localhost")) {
            isLocalRegistry = true;
        }
        if (ep.isRegistry()) {
            output = output + "RMI Registry at " + this._target.getHost() + ":" + this._target.getPort() + "\n";
            output = output + "Objects exposed: " + ep.getExposedObjects().size() + "\n";
            for (RMIObject o : ep.getExposedObjects()) {
                output = output + "Object " + ++oi + "\n";
                output = output + "  Name: " + o.getObjectName() + "\n";
                output = output + "  Endpoint: " + o.getObjectEndpoint().getHost() + ":" + o.getObjectEndpoint().getPort() + "\n";
                if (!isLocalRegistry && (o.getObjectEndpoint().getHost().startsWith("127.") || o.getObjectEndpoint().getHost().equalsIgnoreCase("localhost")) && this.testConnection(this._target.getHost(), o.getObjectEndpoint().getPort())) {
                    output = output + "  [+] Object is bound to localhost, but appears to be exposed remotely.\n";
                }
                output = output + "  Classes: " + o.getObjectClasses().size() + "\n";
                for (String className : o.getObjectClasses().keySet()) {
                    output = output + "    Class " + ++ci + "\n";
                    output = output + "      Classname: " + className + "\n";
                    if (o.getStringAnnotations().size() <= 0) continue;
                    output = output + "      String annotations: " + o.getStringAnnotations().size() + "\n";
                    for (String a : o.getStringAnnotations()) {
                        output = output + "        Annotation: " + a + "\n";
                    }
                }
            }
            if (ep.isRemotelyModifiable()) {
                output = output + "[+] It appears to be possible to remotely bind/unbind/rebind to this registry\n";
            }
            deserAttackAvailable = false;
            output = output + "\n";
            ArrayList<RMIAttack> attacks = RMIAttackFactory.findAttacksForEndpoint(ep);
            if (attacks.size() > 0) {
                output = output + attacks.size() + " potential attacks identified (+++ = more reliable)\n";
                Collections.sort(attacks);
                for (RMIAttack rmia : attacks) {
                    output = output + rmia.getReliabilityIndicator() + " " + rmia.getDescription() + "\n";
                    if (deserAttackAvailable || !rmia.isDeserAttack()) continue;
                    deserAttackAvailable = true;
                }
            }
            output = output + "\n";
            if (deserAttackAvailable) {
                ArrayList<DeserPayload> deserPayloads = DeserPayloadFactory.findGadgetsForEndpoint(ep);
                output = output + deserPayloads.size() + " deserialization gadgets found on leaked CLASSPATH\n";
                if (deserPayloads.size() > 0) {
                    for (DeserPayload p : deserPayloads) {
                        output = output + "[+] " + p.getDescription() + "\n";
                    }
                } else {
                    output = output + "[~] Gadgets may still be present despite CLASSPATH not being leaked\n";
                }
            }
            if (ep.getEnumException() != null) {
                output = output + "[-] An exception occurred during enumeration.\n";
                output = output + "    " + ep.getEnumException().toString() + "\n";
            }
        } else if (ep.isObjectEndpoint()) {
            output = output + this._target.getHost() + ":" + this._target.getPort() + " appears to be an RMI object endpoint, rather than a registry.\n";
            if (ep.getEnumException() != null && !(ep.getEnumException() instanceof NoSuchObjectException)) {
                output = output + "[-] An exception occurred during enumeration.\n";
                output = output + "    " + ep.getEnumException().toString() + "\n";
            }
        } else if (ep.getEnumException() != null && (ep.getEnumException().toString().toLowerCase().contains("non-jrmp") || ep.getEnumException().toString().toLowerCase().contains("error during jrmp"))) {
            output = output + this._target.getHost() + ":" + this._target.getPort() + " is non-RMI or RMI over SSL (not currently supported).\n";
            output = output + "[~] RMI over SSL support will come in a future release!\n";
        }
        System.out.println(output);
        System.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testConnection(String host, int port) {
        Socket sock = null;
        try {
            sock = new Socket();
            sock.connect(new InetSocketAddress(host, port), this._options.getSocketTimeout());
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }
}

