/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.attack;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.SecureRandom;
import java.util.ArrayList;
import nb.barmie.exceptions.BaRMIeException;
import nb.barmie.exceptions.BaRMIeGetObjectException;
import nb.barmie.exceptions.BaRMIeInputException;
import nb.barmie.exceptions.BaRMIeWriteFileException;
import nb.barmie.modes.enumeration.RMIEndpoint;
import nb.barmie.modes.enumeration.RMIObject;
import nb.barmie.net.proxy.PortForwarder;
import nb.barmie.net.proxy.ProxyServer;
import nb.barmie.net.proxy.RMIObjectUIDFixingProxy;
import nb.barmie.util.ProgramOptions;

public abstract class RMIAttack
implements Comparable<RMIAttack> {
    protected final String REMEDIATION_NO_FIX = "No fix currently available. Consider implementing network-layer access controls for this service.";
    private boolean _isAppSpecific = true;
    private boolean _isDeserAttack = false;
    private boolean _nonDefaultDependency = false;
    private String _description = "";
    private String _detail = "";
    private String _remediation = "";
    protected ProgramOptions _options = null;
    protected ArrayList<ProxyServer> _proxies = new ArrayList();

    public abstract boolean canAttackEndpoint(RMIEndpoint var1);

    public abstract void executeAttack(RMIEndpoint var1) throws BaRMIeException;

    protected void doCustomCleanUp() {
    }

    public final void cleanUp() {
        this.doCustomCleanUp();
        for (ProxyServer p : this._proxies) {
            p.stopProxy(true);
        }
        this._proxies.clear();
    }

    @Override
    public final int compareTo(RMIAttack other) {
        int thisScore = 0;
        int otherScore = 0;
        if (this._isAppSpecific) {
            ++thisScore;
        }
        if (!this._isDeserAttack) {
            thisScore += 2;
        }
        if (!this._nonDefaultDependency) {
            thisScore += 4;
        }
        if (other.isAppSpecific()) {
            ++otherScore;
        }
        if (!other.isDeserAttack()) {
            otherScore += 2;
        }
        if (!other.hasNonDefaultDependencies()) {
            otherScore += 4;
        }
        return otherScore - thisScore;
    }

    public final String getReliabilityIndicator() {
        return "[" + (this._isAppSpecific ? "+" : "-") + (!this._isDeserAttack ? "+" : "-") + (!this._nonDefaultDependency ? "+" : "-") + "]";
    }

    public final boolean isAppSpecific() {
        return this._isAppSpecific;
    }

    protected final void setAppSpecific(boolean appSpecific) {
        this._isAppSpecific = appSpecific;
    }

    public final boolean isDeserAttack() {
        return this._isDeserAttack;
    }

    protected final void setIsDeserAttack(boolean isDeserAttack) {
        this._isDeserAttack = isDeserAttack;
    }

    public final boolean hasNonDefaultDependencies() {
        return this._nonDefaultDependency;
    }

    protected final void setRequiresNonDefaultDependency(boolean nonDefaultDependency) {
        this._nonDefaultDependency = nonDefaultDependency;
    }

    public final String getDescription() {
        return this._description;
    }

    protected final void setDescription(String description) {
        this._description = description;
    }

    public final String getDetailedDescription() {
        return this._detail;
    }

    protected final void setDetailedDescription(String detail) {
        this._detail = detail;
    }

    public final String getRemediationAdvice() {
        return this._remediation;
    }

    protected final void setRemediationAdvice(String remediation) {
        this._remediation = remediation;
    }

    public final void setProgramOptions(ProgramOptions options) {
        this._options = options;
    }

    protected final String promptUserForInput(String prompt, boolean allowEmpty) throws BaRMIeInputException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        while (input.equals("")) {
            System.out.print(prompt);
            try {
                input = br.readLine();
            }
            catch (IOException ioe) {
                throw new BaRMIeInputException(ioe);
            }
            if (!allowEmpty) continue;
            break;
        }
        return input;
    }

    protected final String promptUserForInputWithDefault(String prompt, String defaultResponse) throws BaRMIeInputException {
        String input = this.promptUserForInput(prompt, true);
        return input.equals("") ? defaultResponse : input;
    }

    protected Object getRemoteObject(RMIEndpoint ep, String objectName) throws BaRMIeGetObjectException {
        Object obj;
        Registry reg;
        this.startPortForwarding(ep, objectName);
        try {
            reg = LocateRegistry.getRegistry(ep.getEndpoint().getHost(), ep.getEndpoint().getPort());
        }
        catch (RemoteException rex) {
            throw new BaRMIeGetObjectException("Failed to create a reference to the target RMI registry.", rex);
        }
        try {
            obj = reg.lookup(objectName);
        }
        catch (UnmarshalException ue) {
            if (ue.getCause() instanceof InvalidClassException && ue.getCause().toString().contains("local class incompatible: stream classdesc serialVersionUID = ")) {
                obj = this.getRemoteObjectWithUIDHack(ep, objectName);
            }
            throw new BaRMIeGetObjectException("Failed to lookup the object '" + objectName + "'.", ue);
        }
        catch (NotBoundException nbe) {
            throw new BaRMIeGetObjectException("The object '" + objectName + "' is not bound to the target RMI registry.", nbe);
        }
        catch (RemoteException rex) {
            throw new BaRMIeGetObjectException("Failed to lookup the object '" + objectName + "'.", rex);
        }
        return obj;
    }

    private Object getRemoteObjectWithUIDHack(RMIEndpoint ep, String objectName) throws BaRMIeGetObjectException {
        ProxyServer proxy = null;
        try {
            Remote obj;
            proxy = new RMIObjectUIDFixingProxy(InetAddress.getByName(ep.getEndpoint().getHost()), ep.getEndpoint().getPort(), this._options);
            proxy.startProxy();
            Registry reg = LocateRegistry.getRegistry(proxy.getServerListenAddress().getHostAddress(), proxy.getServerListenPort());
            Remote remote = obj = reg.lookup(objectName);
            return remote;
        }
        catch (Exception ex) {
            throw new BaRMIeGetObjectException("Failed to lookup a remote object via RMIObjectUIDFixingProxy.", ex);
        }
        finally {
            if (proxy != null) {
                proxy.stopProxy(true);
            }
        }
    }

    protected void startPortForwarding(RMIEndpoint ep, String objectName) throws BaRMIeGetObjectException {
        if (!ep.getEndpoint().getHost().startsWith("127.") && !ep.getEndpoint().getHost().equalsIgnoreCase("localhost")) {
            for (RMIObject rmiObj : ep.getExposedObjects()) {
                if (!rmiObj.getObjectEndpoint().getHost().startsWith("127.") && !rmiObj.getObjectEndpoint().getHost().equalsIgnoreCase("localhost")) continue;
                System.out.println("[~] Remote object is bound to local host, testing external connectivity...");
                if (this.testConnection(ep.getEndpoint().getHost(), rmiObj.getObjectEndpoint().getPort())) {
                    try {
                        PortForwarder forwarder = new PortForwarder(InetAddress.getByName(ep.getEndpoint().getHost()), rmiObj.getObjectEndpoint().getPort(), this._options);
                        forwarder.startProxy();
                        this._proxies.add(forwarder);
                        System.out.println("[+] Object appears to be exposed remotely, a port forwarder has been started.");
                        System.out.println("[+] Local TCP port " + rmiObj.getObjectEndpoint().getPort() + " is being forwarded to " + ep.getEndpoint().getHost() + ":" + rmiObj.getObjectEndpoint().getPort());
                        continue;
                    }
                    catch (Exception ex) {
                        throw new BaRMIeGetObjectException("Failed to start a port forwarder for the remote object.", ex);
                    }
                }
                System.out.println("[~] Warning: connection to " + ep.getEndpoint().getHost() + ":" + rmiObj.getObjectEndpoint().getPort() + " failed, object lookup may fail");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testConnection(String host, int port) {
        Socket sock = null;
        try {
            sock = new Socket();
            sock.connect(new InetSocketAddress(host, port), this._options.getSocketTimeout());
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    protected void writeFile(String filename, byte[] contents) throws BaRMIeWriteFileException {
        FileOutputStream file = null;
        try {
            file = new FileOutputStream(filename);
            file.write(contents);
        }
        catch (IOException ioe) {
            throw new BaRMIeWriteFileException("Failed to write the file '" + filename + "'.", ioe);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected boolean fileExists(String filename) {
        return new File(filename).exists();
    }

    protected String generateRandomString() {
        SecureRandom sr = new SecureRandom();
        char[] chars = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
        String out = "";
        int len = sr.nextInt(24) + 8;
        for (int i = 0; i < len; ++i) {
            out = out + chars[sr.nextInt(chars.length)];
        }
        return out;
    }
}

