/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

class PasswordRetriever
implements AutoCloseable {
    public static final String SPEC_STDIN = "stdin";
    private final Map<File, BufferedReader> mFileReaders = new HashMap<File, BufferedReader>();
    private BufferedReader mStdIn;
    private boolean mClosed;

    PasswordRetriever() {
    }

    public String getPassword(String spec, String description) throws IOException {
        this.assertNotClosed();
        if (spec.startsWith("pass:")) {
            return spec.substring("pass:".length());
        }
        if (SPEC_STDIN.equals(spec)) {
            Console console = System.console();
            if (console != null) {
                char[] password = console.readPassword(description + ": ", new Object[0]);
                if (password == null) {
                    throw new IOException("Failed to read " + description + ": console closed");
                }
                return new String(password);
            }
            if (this.mStdIn == null) {
                this.mStdIn = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
            }
            System.out.println(description + ":");
            String line = this.mStdIn.readLine();
            if (line == null) {
                throw new IOException("Failed to read " + description + ": standard input closed");
            }
            return line;
        }
        if (spec.startsWith("file:")) {
            String line;
            String name = spec.substring("file:".length());
            File file = new File(name).getCanonicalFile();
            BufferedReader in = this.mFileReaders.get(file);
            if (in == null) {
                in = Files.newBufferedReader(file.toPath(), Charset.defaultCharset());
                this.mFileReaders.put(file, in);
            }
            if ((line = in.readLine()) == null) {
                throw new IOException("Failed to read " + description + " : end of file reached in " + file);
            }
            return line;
        }
        if (spec.startsWith("env:")) {
            String name = spec.substring("env:".length());
            String value = System.getenv(name);
            if (value == null) {
                throw new IOException("Failed to read " + description + ": environment variable " + value + " not specified");
            }
            return value;
        }
        throw new IOException("Unsupported password spec for " + description + ": " + spec);
    }

    private void assertNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Closed");
        }
    }

    @Override
    public void close() {
        if (this.mStdIn != null) {
            try {
                this.mStdIn.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.mStdIn = null;
            }
        }
        for (BufferedReader in : this.mFileReaders.values()) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        this.mFileReaders.clear();
        this.mClosed = true;
    }
}

