/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.apk;

import com.android.apksig.apk.AndroidBinXmlParser;
import com.android.apksig.apk.CodenameMinSdkVersionException;
import com.android.apksig.apk.MinSdkVersionException;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ApkUtils {
    private static final String ANDROID_MANIFEST_ZIP_ENTRY_NAME = "AndroidManifest.xml";
    private static final int MIN_SDK_VERSION_ATTR_ID = 16843276;

    private ApkUtils() {
    }

    public static ZipSections findZipSections(DataSource apk) throws IOException, ZipFormatException {
        Pair<ByteBuffer, Long> eocdAndOffsetInFile = ZipUtils.findZipEndOfCentralDirectoryRecord(apk);
        if (eocdAndOffsetInFile == null) {
            throw new ZipFormatException("ZIP End of Central Directory record not found");
        }
        ByteBuffer eocdBuf = eocdAndOffsetInFile.getFirst();
        long eocdOffset = eocdAndOffsetInFile.getSecond();
        eocdBuf.order(ByteOrder.LITTLE_ENDIAN);
        long cdStartOffset = ZipUtils.getZipEocdCentralDirectoryOffset(eocdBuf);
        if (cdStartOffset > eocdOffset) {
            throw new ZipFormatException("ZIP Central Directory start offset out of range: " + cdStartOffset + ". ZIP End of Central Directory offset: " + eocdOffset);
        }
        long cdSizeBytes = ZipUtils.getZipEocdCentralDirectorySizeBytes(eocdBuf);
        long cdEndOffset = cdStartOffset + cdSizeBytes;
        if (cdEndOffset > eocdOffset) {
            throw new ZipFormatException("ZIP Central Directory overlaps with End of Central Directory. CD end: " + cdEndOffset + ", EoCD start: " + eocdOffset);
        }
        int cdRecordCount = ZipUtils.getZipEocdCentralDirectoryTotalRecordCount(eocdBuf);
        return new ZipSections(cdStartOffset, cdSizeBytes, cdRecordCount, eocdOffset, eocdBuf);
    }

    public static void setZipEocdCentralDirectoryOffset(ByteBuffer zipEndOfCentralDirectory, long offset) {
        ByteBuffer eocd = zipEndOfCentralDirectory.slice();
        eocd.order(ByteOrder.LITTLE_ENDIAN);
        ZipUtils.setZipEocdCentralDirectoryOffset(eocd, offset);
    }

    public static int getMinSdkVersionFromBinaryAndroidManifest(ByteBuffer androidManifestContents) throws MinSdkVersionException {
        try {
            int result = 1;
            AndroidBinXmlParser parser = new AndroidBinXmlParser(androidManifestContents);
            int eventType = parser.getEventType();
            while (eventType != 2) {
                if (eventType == 3 && parser.getDepth() == 2 && "uses-sdk".equals(parser.getName()) && parser.getNamespace().isEmpty()) {
                    int minSdkVersion = 1;
                    block7: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (parser.getAttributeNameResourceId(i) != 16843276) continue;
                        int valueType = parser.getAttributeValueType(i);
                        switch (valueType) {
                            case 2: {
                                minSdkVersion = parser.getAttributeIntValue(i);
                                break block7;
                            }
                            case 1: {
                                String codename = parser.getAttributeStringValue(i);
                                throw new CodenameMinSdkVersionException("Unable to determine APK's minimum supported Android platform version: Codename in AndroidManifest.xml's minSdkVersion: \"" + codename + "\"" + ". Only integer values supported.", codename);
                            }
                            default: {
                                throw new MinSdkVersionException("Unable to determine APK's minimum supported Android: unsupported value type in AndroidManifest.xml's minSdkVersion. Only integer values supported.");
                            }
                        }
                    }
                    result = Math.max(result, minSdkVersion);
                }
                eventType = parser.next();
            }
            return result;
        }
        catch (AndroidBinXmlParser.XmlParserException e) {
            throw new MinSdkVersionException("Unable to determine APK's minimum supported Android platform version: malformed binary resource: AndroidManifest.xml", e);
        }
    }

    public static class ZipSections {
        private final long mCentralDirectoryOffset;
        private final long mCentralDirectorySizeBytes;
        private final int mCentralDirectoryRecordCount;
        private final long mEocdOffset;
        private final ByteBuffer mEocd;

        public ZipSections(long centralDirectoryOffset, long centralDirectorySizeBytes, int centralDirectoryRecordCount, long eocdOffset, ByteBuffer eocd) {
            this.mCentralDirectoryOffset = centralDirectoryOffset;
            this.mCentralDirectorySizeBytes = centralDirectorySizeBytes;
            this.mCentralDirectoryRecordCount = centralDirectoryRecordCount;
            this.mEocdOffset = eocdOffset;
            this.mEocd = eocd;
        }

        public long getZipCentralDirectoryOffset() {
            return this.mCentralDirectoryOffset;
        }

        public long getZipCentralDirectorySizeBytes() {
            return this.mCentralDirectorySizeBytes;
        }

        public int getZipCentralDirectoryRecordCount() {
            return this.mCentralDirectoryRecordCount;
        }

        public long getZipEndOfCentralDirectoryOffset() {
            return this.mEocdOffset;
        }

        public ByteBuffer getZipEndOfCentralDirectory() {
            return this.mEocd;
        }
    }
}

