/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.jacoco;

import com.android.jack.tools.jacoco.JackMethodCoverage;
import com.android.jack.tools.jacoco.ProbeDescription;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.CounterImpl;
import org.jacoco.core.internal.analysis.MethodCoverageImpl;

public class JackCoverageAnalyzer {
    @Nonnull
    private static final String CURRENT_VERSION = "1.0";
    @Nonnull
    private static final String JSON_VERSION_ATTRIBUTE = "version";
    @Nonnull
    private static final String JSON_DATA_ATTRIBUTE = "data";
    @Nonnull
    private final ExecutionDataStore executionDataStore;
    @Nonnull
    private final ICoverageVisitor coverageVisitor;

    public JackCoverageAnalyzer(@Nonnull ExecutionDataStore executionDataStore, @Nonnull ICoverageVisitor coverageVisitor) {
        this.executionDataStore = executionDataStore;
        this.coverageVisitor = coverageVisitor;
    }

    public void analyze(@Nonnull File jackCoverageDescriptionFile) throws IOException {
        if (!jackCoverageDescriptionFile.exists()) {
            String string = String.valueOf(jackCoverageDescriptionFile);
            throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string).length()).append("File ").append(string).append(" does not exist.").toString());
        }
        FileInputStream is = new FileInputStream(jackCoverageDescriptionFile);
        try {
            this.analyze(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private void analyze(@Nonnull InputStream coverageDescriptionInputStream) throws IOException {
        JsonReader jsonReader = new JsonReader(new InputStreamReader(coverageDescriptionInputStream));
        this.readMetadata(jsonReader);
    }

    private void checkVersion(@CheckForNull String version) {
        if (version == null) {
            throw new JsonParseException("Missing 'version' attribute before coverage metadadata");
        }
        String[] parts = version.split(Pattern.quote("."));
        if (parts.length != 2) {
            throw new JsonParseException("Version number format must be x.y");
        }
        if (!version.equals(CURRENT_VERSION)) {
            String string = String.valueOf(version);
            throw new JsonParseException(string.length() != 0 ? "Unknown version ".concat(string) : new String("Unknown version "));
        }
    }

    private void readMetadata(@Nonnull JsonReader jsonReader) throws IOException {
        jsonReader.beginObject();
        String version = null;
        while (jsonReader.hasNext()) {
            String attributeName = jsonReader.nextName();
            if (attributeName.equals(JSON_VERSION_ATTRIBUTE)) {
                version = jsonReader.nextString();
                continue;
            }
            if (attributeName.equals(JSON_DATA_ATTRIBUTE)) {
                this.checkVersion(version);
                this.readClasses(jsonReader);
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
    }

    private void readClasses(@Nonnull JsonReader jsonReader) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            IClassCoverage classCoverage = this.readClass(jsonReader);
            this.coverageVisitor.visitCoverage(classCoverage);
        }
        jsonReader.endArray();
    }

    @Nonnull
    private IClassCoverage readClass(@Nonnull JsonReader jsonReader) throws IOException {
        boolean noMatch;
        long id = 0L;
        String className = null;
        String sourceFile = null;
        String superClassName = null;
        ArrayList<IMethodCoverage> methods = new ArrayList<IMethodCoverage>();
        ArrayList<ProbeDescription> probes = new ArrayList<ProbeDescription>();
        ArrayList<String> interfaces = new ArrayList<String>();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String attributeName = jsonReader.nextName();
            if ("id".equals(attributeName)) {
                id = jsonReader.nextLong();
                continue;
            }
            if ("name".equals(attributeName)) {
                className = jsonReader.nextString();
                continue;
            }
            if ("sourceFile".equals(attributeName)) {
                sourceFile = jsonReader.nextString();
                continue;
            }
            if ("superClassName".equals(attributeName)) {
                superClassName = jsonReader.nextString();
                continue;
            }
            if ("interfaces".equals(attributeName)) {
                this.readInterfaces(jsonReader, interfaces);
                continue;
            }
            if ("methods".equals(attributeName)) {
                JackCoverageAnalyzer.readMethods(jsonReader, methods);
                continue;
            }
            if ("probes".equals(attributeName)) {
                JackCoverageAnalyzer.readProbes(jsonReader, probes, methods);
                continue;
            }
            throw new JsonParseException(new StringBuilder(20 + String.valueOf(attributeName).length()).append("Unknown attribute \"").append(attributeName).append("\"").toString());
        }
        jsonReader.endObject();
        ExecutionData executionData = this.executionDataStore.get(id);
        if (executionData != null) {
            noMatch = false;
            executionData.assertCompatibility(id, className, probes.size());
        } else {
            noMatch = this.executionDataStore.contains(className);
        }
        String[] interfacesArray = interfaces.toArray(new String[0]);
        String string = className;
        ClassCoverageImpl c = new ClassCoverageImpl(className, id, noMatch, new StringBuilder(2 + String.valueOf(string).length()).append("L").append(string).append(";").toString(), superClassName, interfacesArray);
        c.setSourceFileName(sourceFile);
        boolean[] executionProbes = executionData != null ? executionData.getProbes() : null;
        for (ProbeDescription probe : probes) {
            int probeIndex = probe.id;
            boolean active = executionProbes != null && executionProbes[probeIndex];
            MethodCoverageImpl methodCoverage = probe.method;
            for (ProbeDescription.Line line : probe.lines) {
                CounterImpl branchCounter;
                CounterImpl instructionCounter;
                if (active) {
                    instructionCounter = CounterImpl.getInstance(0, line.instructionsCount);
                    branchCounter = CounterImpl.getInstance(0, line.branchesCount);
                } else {
                    instructionCounter = CounterImpl.getInstance(line.instructionsCount, 0);
                    branchCounter = CounterImpl.getInstance(line.branchesCount, 0);
                }
                methodCoverage.increment(instructionCounter, branchCounter, line.line);
            }
        }
        for (IMethodCoverage method : methods) {
            c.addMethod(method);
        }
        return c;
    }

    private void readInterfaces(@Nonnull JsonReader jsonReader, @Nonnull List<String> interfaces) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            interfaces.add(jsonReader.nextString());
        }
        jsonReader.endArray();
    }

    private static void readProbes(@Nonnull JsonReader jsonReader, @Nonnull List<ProbeDescription> probes, @Nonnull List<? extends IMethodCoverage> methods) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            probes.add(JackCoverageAnalyzer.readProbe(jsonReader, methods));
        }
        jsonReader.endArray();
    }

    private static ProbeDescription readProbe(@Nonnull JsonReader jsonReader, @Nonnull List<? extends IMethodCoverage> methods) throws IOException {
        ProbeDescription probe = new ProbeDescription();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String attributeName = jsonReader.nextName();
            if ("id".equals(attributeName)) {
                probe.setId(jsonReader.nextInt());
                continue;
            }
            if ("method".equals(attributeName)) {
                int methodId = jsonReader.nextInt();
                probe.setMethod((MethodCoverageImpl)methods.get(methodId));
                continue;
            }
            if ("lines".equals(attributeName)) {
                JackCoverageAnalyzer.readLines(jsonReader, probe);
                continue;
            }
            throw new JsonParseException(new StringBuilder(20 + String.valueOf(attributeName).length()).append("Unknown attribute \"").append(attributeName).append("\"").toString());
        }
        jsonReader.endObject();
        return probe;
    }

    private static void readLines(@Nonnull JsonReader jsonReader, @Nonnull ProbeDescription probe) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            jsonReader.beginObject();
            int line = -1;
            int instructionsCount = -1;
            int branchesCount = -1;
            while (jsonReader.hasNext()) {
                String attributeName = jsonReader.nextName();
                if ("line".equals(attributeName)) {
                    line = jsonReader.nextInt();
                    continue;
                }
                if ("insnCount".equals(attributeName)) {
                    instructionsCount = jsonReader.nextInt();
                    continue;
                }
                if ("branchCount".equals(attributeName)) {
                    branchesCount = jsonReader.nextInt();
                    continue;
                }
                throw new JsonParseException(new StringBuilder(20 + String.valueOf(attributeName).length()).append("Unknown attribute \"").append(attributeName).append("\"").toString());
            }
            probe.addLine(line, instructionsCount, branchesCount);
            jsonReader.endObject();
        }
        jsonReader.endArray();
    }

    private static void readMethods(@Nonnull JsonReader jsonReader, @Nonnull List<IMethodCoverage> methods) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            methods.add(JackCoverageAnalyzer.readMethod(jsonReader));
        }
        jsonReader.endArray();
    }

    @Nonnull
    private static IMethodCoverage readMethod(@Nonnull JsonReader jsonReader) throws IOException {
        int id = -1;
        String name = null;
        String desc = null;
        String signature = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String attributeName = jsonReader.nextName();
            if ("id".equals(attributeName)) {
                id = jsonReader.nextInt();
                continue;
            }
            if ("name".equals(attributeName)) {
                name = jsonReader.nextString();
                continue;
            }
            if ("desc".equals(attributeName)) {
                desc = jsonReader.nextString();
                continue;
            }
            if ("signature".equals(attributeName)) {
                signature = jsonReader.nextString();
                continue;
            }
            throw new JsonParseException(new StringBuilder(20 + String.valueOf(attributeName).length()).append("Unknown attribute \"").append(attributeName).append("\"").toString());
        }
        jsonReader.endObject();
        return new JackMethodCoverage(id, name, desc, signature);
    }
}

