/*
 * Decompiled with CFR 0.152.
 */
package net.dirtybox.util.obfuscation;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AndroidStringObfuscator {
    private static String OBFUSCATION_CHARSET = "UTF-8";
    private static byte[] KEY;
    private static String VALUE;
    private static boolean DO_ENCRYPT;
    private static boolean HANDLE_D;
    private static boolean HANDLE_E;
    private static boolean HANDLE_KEY;

    private static void usage() {
        System.out.println("Usage: AndroidStringObfuscator <d|e> \"<string>\" k \"<string>\"");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            AndroidStringObfuscator.usage();
        } else {
            for (String string : stringArray) {
                if (HANDLE_D) {
                    VALUE = string;
                    HANDLE_D = false;
                    continue;
                }
                if (HANDLE_E) {
                    VALUE = string;
                    DO_ENCRYPT = true;
                    HANDLE_E = false;
                    continue;
                }
                if (HANDLE_KEY) {
                    byte[] byArray;
                    try {
                        byArray = string.getBytes(OBFUSCATION_CHARSET);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new RuntimeException(unsupportedEncodingException);
                    }
                    KEY = Base64.decode(byArray, 0);
                    HANDLE_KEY = false;
                    continue;
                }
                if (string.equalsIgnoreCase("d")) {
                    HANDLE_D = true;
                    continue;
                }
                if (string.equalsIgnoreCase("e")) {
                    HANDLE_E = true;
                    continue;
                }
                if (string.equalsIgnoreCase("k")) {
                    HANDLE_KEY = true;
                    continue;
                }
                AndroidStringObfuscator.usage();
            }
            if (DO_ENCRYPT) {
                System.out.println(AndroidStringObfuscator.obfuscate(VALUE, KEY));
            } else {
                System.out.println(AndroidStringObfuscator.unobfuscate(VALUE, KEY));
            }
        }
    }

    public static String obfuscate(String string, byte[] byArray) {
        byte[] byArray2;
        Cipher cipher;
        byte[] byArray3;
        try {
            byArray3 = string.getBytes(OBFUSCATION_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        try {
            cipher = Cipher.getInstance("AES/CTR/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        byte[] byArray4 = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray4);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4);
        try {
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
        try {
            byArray2 = cipher.doFinal(byArray3);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
        byte[] byArray5 = new byte[byArray4.length + byArray2.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray2, 0, byArray5, byArray4.length, byArray2.length);
        byte[] byArray6 = Base64.encode(byArray5, 2);
        try {
            return new String(byArray6, OBFUSCATION_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String unobfuscate(String string, byte[] byArray) {
        byte[] byArray2;
        Cipher cipher;
        byte[] byArray3;
        try {
            byArray3 = string.getBytes(OBFUSCATION_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        byte[] byArray4 = Base64.decode(byArray3, 0);
        try {
            cipher = Cipher.getInstance("AES/CTR/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        byte[] byArray5 = new byte[16];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray5.length);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray5);
        byte[] byArray6 = new byte[byArray4.length - byArray5.length];
        System.arraycopy(byArray4, byArray5.length, byArray6, 0, byArray6.length);
        try {
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
        try {
            byArray2 = cipher.doFinal(byArray6);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
        try {
            return new String(byArray2, OBFUSCATION_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    static {
        DO_ENCRYPT = false;
        HANDLE_D = false;
        HANDLE_E = false;
        HANDLE_KEY = false;
    }
}

