/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.Percent;
import com.android.sched.util.log.stats.PercentImpl;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class VFSStatCategory
extends Enum<VFSStatCategory> {
    public static final /* enum */ VFSStatCategory ZIP_READ = new VFSStatCategory("zip", "opened-for-reading-entries", "Zip entries opened for reading", DummyStat.COUNTER);
    public static final /* enum */ VFSStatCategory ZIP_CREATED_ENTRIES = new VFSStatCategory("zip", "created-entries", "Created zip entries", DummyStat.COUNTER);
    public static final /* enum */ VFSStatCategory DIR_READ = new VFSStatCategory("dir", "opened-for-reading-files", "Physical files opened for reading", DummyStat.COUNTER);
    public static final /* enum */ VFSStatCategory DIR_WRITE = new VFSStatCategory("dir", "opened-for-writing-files", "Physical files opened for writing", DummyStat.COUNTER);
    public static final /* enum */ VFSStatCategory DIR_CREATE = new VFSStatCategory("dir", "created-physical-files", "Created physical files", DummyStat.PERCENT);
    public static final /* enum */ VFSStatCategory OPTIMIZED_COPIES = new VFSStatCategory("deflate", "optimized-copies", "Optimized copies (without inflation/deflation)", DummyStat.PERCENT);
    @CheckForNull
    private Tracer tracer;
    @Nonnull
    private static final String NAME_GLOBAL_PREFIX = "sched.vfs";
    @Nonnull
    private final String namePrefix;
    @Nonnull
    private final String nameSuffix;
    @Nonnull
    private final String description;
    @CheckForNull
    Map<String, StatisticId<Statistic>> statMap;
    @Nonnull
    private Statistic dummy;
    private static final /* synthetic */ VFSStatCategory[] $VALUES;

    public static VFSStatCategory[] values() {
        return (VFSStatCategory[])$VALUES.clone();
    }

    public static VFSStatCategory valueOf(String name) {
        return Enum.valueOf(VFSStatCategory.class, name);
    }

    private VFSStatCategory(@Nonnull String namePrefix, @Nonnull String nameSuffix, String description, Statistic dummy) {
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.description = description;
        this.dummy = dummy;
    }

    public synchronized StatisticId<Counter> getCounterStatId(@Nonnull String infoString) {
        StatisticId<Statistic> id;
        if (this.statMap == null) {
            this.statMap = new HashMap<String, StatisticId<Statistic>>();
        }
        if ((id = this.statMap.get(infoString)) == null) {
            id = new StatisticId<Counter>("sched.vfs." + this.namePrefix + '.' + infoString + '.' + this.nameSuffix, this.description + " for '" + infoString + "'", CounterImpl.class, Counter.class);
            this.statMap.put(infoString, id);
        }
        return id;
    }

    public synchronized StatisticId<Percent> getPercentStatId(@Nonnull String infoString) {
        StatisticId<Statistic> id;
        if (this.statMap == null) {
            this.statMap = new HashMap<String, StatisticId<Statistic>>();
        }
        if ((id = this.statMap.get(infoString)) == null) {
            id = new StatisticId<Percent>("sched.vfs." + this.namePrefix + '.' + infoString + '.' + this.nameSuffix, this.description + " for '" + infoString + "'", PercentImpl.class, Percent.class);
            this.statMap.put(infoString, id);
        }
        return id;
    }

    @Nonnull
    public Counter getCounterStat(@CheckForNull Tracer tracer, @CheckForNull String infoString) {
        assert (this.dummy instanceof Counter);
        if (infoString == null) {
            infoString = "other";
        }
        if (tracer != null && tracer.isTracing()) {
            StatisticId<Counter> id = this.getCounterStatId(infoString);
            return tracer.getStatistic(id);
        }
        return (Counter)this.dummy;
    }

    @Nonnull
    public Percent getPercentStat(@CheckForNull Tracer tracer, @CheckForNull String infoString) {
        assert (this.dummy instanceof Percent);
        if (infoString == null) {
            infoString = "other";
        }
        if (tracer != null && tracer.isTracing()) {
            StatisticId<Percent> id = this.getPercentStatId(infoString);
            return tracer.getStatistic(id);
        }
        return (Percent)this.dummy;
    }

    static {
        $VALUES = new VFSStatCategory[]{ZIP_READ, ZIP_CREATED_ENTRIES, DIR_READ, DIR_WRITE, DIR_CREATE, OPTIMIZED_COPIES};
    }

    private static class DummyStat {
        @Nonnull
        static final Percent PERCENT = new StatisticId<Percent>("dummy.percent", "Dummy Percent", Percent.class, Percent.class).getDummyInstance();
        @Nonnull
        static final Counter COUNTER = new StatisticId<Counter>("dummy.counter", "Dummy Counter", Counter.class, Counter.class).getDummyInstance();

        private DummyStat() {
        }
    }
}

