/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.print;

import com.android.sched.util.print.DataModel;
import com.android.sched.util.print.DataType;
import com.android.sched.util.print.Printer;
import com.android.sched.util.print.TypePrinter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;

public abstract class AbstractPrinter
implements Printer {
    @Nonnull
    protected final EnumMap<DataType, TypePrinter<?>> printers = new EnumMap(DataType.class);
    @Nonnull
    private final TypePrinter<?> defaultPrinter = new MissingPrinter();
    @Nonnull
    private final PrintWriter printer;
    @Nonnull
    private final ArrayList<ResourceBundle> bundles = new ArrayList();

    public AbstractPrinter(@Nonnull PrintWriter printer) {
        this.printer = printer;
    }

    @Nonnull
    public <T> TypePrinter<T> getFormatter(@Nonnull DataType type) {
        assert (this.printers.size() == DataType.values().length) : "Missing printer in " + this.getClass().getCanonicalName();
        TypePrinter<?> printer = this.printers.get((Object)type);
        if (printer == null) {
            printer = this.defaultPrinter;
        }
        return printer;
    }

    @Override
    @Nonnull
    public Printer addResourceBundles(@Nonnull Collection<ResourceBundle> bundles) {
        this.bundles.addAll(bundles);
        return this;
    }

    @Override
    @Nonnull
    public Printer addResourceBundles(ResourceBundle ... bundles) {
        this.bundles.addAll(Arrays.asList(bundles));
        return this;
    }

    @Nonnull
    protected String getString(@Nonnull String name) {
        for (ResourceBundle bundle : this.bundles) {
            try {
                return bundle.getString(name);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return name;
    }

    @Override
    public boolean print(@Nonnull DataModel data) {
        TypePrinter<DataModel> formatter = this.getFormatter(data.getDataView().getDataType());
        return formatter.print(this.printer, data);
    }

    protected static class NothingPrinter
    implements TypePrinter<Object> {
        protected NothingPrinter() {
        }

        @Override
        @Nonnull
        public boolean print(@Nonnull PrintWriter printer, @Nonnull Object object) {
            return false;
        }
    }

    protected class WithBundlePrinter
    implements TypePrinter<String> {
        protected WithBundlePrinter() {
        }

        @Override
        @Nonnull
        public boolean print(@Nonnull PrintWriter printer, @Nonnull String key) {
            return AbstractPrinter.this.getFormatter(DataType.STRING).print(printer, AbstractPrinter.this.getString(key));
        }
    }

    private class MissingPrinter
    implements TypePrinter<Object> {
        private MissingPrinter() {
        }

        @Override
        @Nonnull
        public boolean print(@Nonnull PrintWriter printer, @Nonnull Object object) {
            return AbstractPrinter.this.getFormatter(DataType.STRING).print(printer, "<missing formatter for '" + object.getClass().getCanonicalName() + "'>");
        }
    }
}

