/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer;

public class SimpleStat {
    private long count;
    private double min = Double.POSITIVE_INFINITY;
    private Object minObject;
    private double max = Double.NEGATIVE_INFINITY;
    private Object maxObject;
    private double total;
    private double squareSum;

    public SimpleStat() {
        this.clear();
    }

    public void add(double value, Object obj) {
        if (!Double.isNaN(value)) {
            if (value < this.min) {
                this.min = value;
                this.minObject = obj;
            }
            if (value > this.max) {
                this.max = value;
                this.maxObject = obj;
            }
            this.total += value;
            this.squareSum += value * value;
        }
        ++this.count;
    }

    public long getCount() {
        return this.count;
    }

    public double getMin() {
        return this.min;
    }

    public Object getMinObject() {
        return this.minObject;
    }

    public double getMax() {
        return this.max;
    }

    public Object getMaxObject() {
        return this.maxObject;
    }

    public double getAverage() {
        return this.total / (double)this.count;
    }

    public double getTotal() {
        return this.total;
    }

    public double getVariance() {
        double average = this.getAverage();
        double d = this.squareSum / (double)this.count;
        return Math.sqrt(d -= average * average);
    }

    public void clear() {
        this.count = 0L;
        this.squareSum = 0.0;
    }
}

