/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.stats;

import com.android.sched.util.log.stats.Percent;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import javax.annotation.Nonnull;

public class PercentImpl
extends Percent {
    private long trueCount;
    private long total;

    protected PercentImpl(@Nonnull StatisticId<? extends Statistic> id) {
        super(id);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void addTrue() {
        ++this.trueCount;
        ++this.total;
    }

    @Override
    public synchronized void addFalse() {
        ++this.total;
    }

    @Override
    public synchronized void add(boolean value) {
        if (value) {
            this.addTrue();
        } else {
            this.addFalse();
        }
    }

    @Override
    public synchronized void removeTrue() {
        --this.trueCount;
        --this.total;
    }

    @Override
    public synchronized void removeFalse() {
        --this.total;
    }

    @Override
    public synchronized void remove(boolean value) {
        if (value) {
            this.removeTrue();
        } else {
            this.removeFalse();
        }
    }

    @Override
    public synchronized double getPercent() {
        if (this.trueCount < 0L || this.total < 0L) {
            return Double.NaN;
        }
        return (double)this.trueCount / (double)this.total;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public long getTrueCount() {
        return this.trueCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void merge(@Nonnull Statistic statistic) {
        PercentImpl percent;
        PercentImpl percentImpl = percent = (PercentImpl)statistic;
        synchronized (percentImpl) {
            this.trueCount += percent.trueCount;
            this.total += percent.total;
        }
    }
}

