/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.expression;

import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.Expression;
import com.android.sched.util.config.expression.PropertyNotRequiredException;
import javax.annotation.Nonnull;

public abstract class LongExpression
extends Expression {
    public abstract long eval(@Nonnull ConfigChecker var1) throws PropertyIdException, PropertyNotRequiredException;

    @Nonnull
    public BooleanExpression isEqual(final @Nonnull LongExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return LongExpression.this.eval(checker) == right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return LongExpression.this.getDescription() + " is equal to " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return LongExpression.this.format(LongExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), LongExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isNotEqual(final @Nonnull LongExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return LongExpression.this.eval(checker) != right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return LongExpression.this.getDescription() + " is not equal to " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return LongExpression.this.format(LongExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), LongExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isGreater(final @Nonnull LongExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return LongExpression.this.eval(checker) > right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return LongExpression.this.getDescription() + " is greater than " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return LongExpression.this.format(LongExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), LongExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isGreaterOrEqual(final @Nonnull LongExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return LongExpression.this.eval(checker) >= right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return LongExpression.this.getDescription() + " is greater or equal than " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return LongExpression.this.format(LongExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), LongExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isLower(final @Nonnull LongExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return LongExpression.this.eval(checker) < right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return LongExpression.this.getDescription() + " is lower than " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return LongExpression.this.format(LongExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), LongExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isLowerOrEqual(final @Nonnull LongExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return LongExpression.this.eval(checker) <= right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return LongExpression.this.getDescription() + " is lower or equal than " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return LongExpression.this.format(LongExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), LongExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public static LongExpression getConstant(final long value) {
        return new LongExpression(){

            @Override
            public long eval(@Nonnull ConfigChecker checker) {
                return value;
            }

            @Override
            @Nonnull
            public String getDescription() {
                return Long.toString(value);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return Long.toString(value);
            }
        };
    }

    @Nonnull
    private String format(@Nonnull String left, boolean eval, @Nonnull String right, long lhs, long rhs) {
        StringBuilder sb = new StringBuilder();
        if (!eval) {
            long tmp = lhs;
            lhs = rhs;
            rhs = tmp;
        }
        sb.append(left);
        if (lhs < rhs) {
            sb.append(" is lower than ");
        } else if (lhs > rhs) {
            sb.append(" is greater than ");
        } else {
            sb.append(" is equal to ");
        }
        sb.append(right);
        return sb.toString();
    }
}

