/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.id.KeyId;
import com.android.sched.util.config.id.ObjectId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.location.Location;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class ConfigChecker {
    @Nonnull
    private final CodecContext context;
    @Nonnull
    private final Map<PropertyId<?>, PropertyId.Value> values = new HashMap();
    @Nonnull
    private final Map<KeyId<?, ?>, Object> instances = new HashMap();
    @Nonnull
    private final Map<KeyId<?, ?>, Location> locations = new HashMap();
    @Nonnull
    private final Map<KeyId<?, ?>, String> dropped = new HashMap();

    ConfigChecker(@Nonnull CodecContext context, @Nonnull Map<PropertyId<?>, PropertyId.Value> stringValues, @Nonnull Map<ObjectId<?>, Object> instanceValues, @Nonnull Map<KeyId<?, ?>, Location> locationsById) {
        this.context = context;
        this.values.putAll(stringValues);
        this.instances.putAll(instanceValues);
        this.locations.putAll(locationsById);
    }

    @Nonnull
    public synchronized <T> T parse(@Nonnull PropertyId<T> propertyId) throws PropertyIdException {
        PropertyId.Value value = this.values.get(propertyId);
        if (value == null) {
            throw new MissingPropertyException(propertyId);
        }
        try {
            value.check(this.context);
            return value.getObject(this.context);
        }
        catch (ParsingException e) {
            throw new PropertyIdException(propertyId, this.getLocation(propertyId), e);
        }
    }

    public synchronized <T, S> void check(@Nonnull KeyId<T, S> keyId) throws PropertyIdException {
        if (this.instances.get(keyId) == null) {
            if (keyId instanceof PropertyId) {
                PropertyId propertyId = (PropertyId)keyId;
                PropertyId.Value value = this.values.get(propertyId);
                if (value == null) {
                    throw new MissingPropertyException(propertyId);
                }
                try {
                    value.check(this.context);
                }
                catch (ParsingException e) {
                    throw new PropertyIdException(propertyId, this.getLocation(propertyId), e);
                }
            } else {
                assert (keyId instanceof ObjectId);
                ObjectId objectId = (ObjectId)keyId;
                objectId.checkInstantiability();
            }
        }
    }

    @Nonnull
    public <T> String getRawValue(@Nonnull PropertyId<T> propertyId) throws MissingPropertyException {
        PropertyId.Value value = this.values.get(propertyId);
        if (value == null) {
            throw new MissingPropertyException(propertyId);
        }
        return value.getString();
    }

    @Nonnull
    public Map<KeyId<?, ?>, Object> getInstances() {
        return this.instances;
    }

    @Nonnull
    public Map<PropertyId<?>, PropertyId.Value> getValues() {
        return this.values;
    }

    @Nonnull
    public Map<KeyId<?, ?>, String> getDropCauses() {
        return this.dropped;
    }

    @Nonnull
    public Location getLocation(@Nonnull KeyId<?, ?> keyId) {
        assert (this.locations.get(keyId) != null);
        return this.locations.get(keyId);
    }

    public void remove(@Nonnull KeyId<?, ?> keyId, @Nonnull String cause) {
        this.values.remove(keyId);
        this.instances.remove(keyId);
        this.locations.remove(keyId);
        this.dropped.put(keyId, cause);
    }
}

