/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jack.google.common.base.Joiner;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.Selector;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import javax.annotation.Nonnull;

public class ClassSelector<T>
extends Selector<T>
implements StringCodec<Class<? extends T>> {
    public ClassSelector(@Nonnull Class<T> type) {
        super(type);
    }

    @Override
    @Nonnull
    public Class<? extends T> checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        return this.getClass(string);
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull Class<? extends T> cls) throws CheckingException {
        if (!this.checkClass(cls)) {
            throw new CheckingException("The value must be {" + Joiner.on(',').join(this.getClasses()) + "} but is '" + cls.getCanonicalName() + "'");
        }
    }

    @Override
    @Nonnull
    public Class<? extends T> parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull Class<? extends T> type) {
        return this.getName(type);
    }
}

