/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.item.Component;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.SubPlanBuilder;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.SchedEventType;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import javax.annotation.Nonnull;

public class PlanBuilder<T extends Component>
extends SubPlanBuilder<T> {
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final Request request;

    public PlanBuilder(@Nonnull Request request, @Nonnull Class<T> runOn) {
        super(request.getScheduler(), runOn);
        this.request = request;
    }

    @Nonnull
    public Plan<T> getPlan() {
        assert (this.request != null);
        try (Event event = this.tracer.open(SchedEventType.PLANBUILDER);){
            this.plan.initPlan(this.request, this);
        }
        return this.plan;
    }

    @Nonnull
    public Request getRequest() {
        return this.request;
    }
}

