/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.item.Component;
import com.android.sched.item.Items;
import com.android.sched.item.TagOrMarkerOrComponent;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.IllegalRequestException;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.scheduler.PlanBuilder;
import com.android.sched.scheduler.PlanCandidate;
import com.android.sched.scheduler.ProductionSet;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.SubPlanBuilder;
import com.android.sched.scheduler.TagOrMarkerOrComponentSet;
import com.android.sched.scheduler.genetic.stats.RunnerPercent;
import com.android.sched.scheduler.genetic.stats.RunnerPercentImpl;
import com.android.sched.scheduler.genetic.stats.TagPercent;
import com.android.sched.scheduler.genetic.stats.TagPercentImpl;
import com.android.sched.util.codec.PercentFormatter;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.SchedEventType;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Percent;
import com.android.sched.util.log.stats.StatisticId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class FitnessPlanCandidate<T extends Component>
implements PlanCandidate<T> {
    @CheckForNull
    private static Map<ManagedRunnable, StatisticId<Percent>> runnerSatisfaction;
    @CheckForNull
    private static Map<Class<? extends TagOrMarkerOrComponent>, StatisticId<Percent>> needSatisfaction;
    @CheckForNull
    private static Map<Class<? extends TagOrMarkerOrComponent>, StatisticId<Percent>> noSatisfaction;
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private final List<ManagedRunnable> plan;
    @Nonnull
    private final List<TagOrMarkerOrComponentSet> beforeTags;
    @Nonnull
    private final Request request;
    @Nonnull
    private final Class<T> rootRunOn;
    @Nonnegative
    private long unsatisfiedConstraint = 0L;
    @Nonnegative
    private long satisfiedConstraint = 0L;
    @Nonnegative
    private int satisfiedRunner = 0;
    @Nonnegative
    private int adapterCount = 0;
    @Nonnegative
    private int unsatisfiedProduction = 0;
    @Nonnull
    private static PercentFormatter formatter;

    public FitnessPlanCandidate(@Nonnull Request request, @Nonnull Class<T> rootRunOn, @Nonnull PlanBuilder<T> builder) {
        this(request, rootRunOn, builder.getRunners());
    }

    public FitnessPlanCandidate(@Nonnull FitnessPlanCandidate<T> analyzer, @Nonnull List<ManagedRunnable> plan) {
        this(analyzer.request, analyzer.rootRunOn, plan);
    }

    FitnessPlanCandidate(@Nonnull Request request, @Nonnull Class<T> rootRunOn, @Nonnull List<ManagedRunnable> plan) {
        try (Event event = this.tracer.open(SchedEventType.ANALYZER);){
            this.request = request;
            this.rootRunOn = rootRunOn;
            this.plan = new ArrayList<ManagedRunnable>(plan);
            this.beforeTags = new ArrayList<TagOrMarkerOrComponentSet>();
            FeatureSet features = request.getFeatures();
            Stack<Class<T>> runOn = new Stack<Class<T>>();
            ProductionSet toProduce = new ProductionSet(request.getTargetProductions());
            TagOrMarkerOrComponentSet currentTags = new TagOrMarkerOrComponentSet(request.getInitialTags());
            this.beforeTags.add(new TagOrMarkerOrComponentSet(currentTags));
            runOn.push(rootRunOn);
            for (int idx = 0; idx < plan.size(); ++idx) {
                ManagedRunnable runner = plan.get(idx);
                State currentState = new State();
                for (Class clazz : runner.getProductions()) {
                    if (toProduce.contains(clazz)) {
                        toProduce.remove(clazz);
                        continue;
                    }
                    ++this.unsatisfiedProduction;
                }
                while (!runOn.isEmpty()) {
                    if (runOn.contains(runner.getRunOn())) {
                        ++this.satisfiedConstraint;
                        currentState.setSatisfied();
                        while (runOn.peek() != runner.getRunOn()) {
                            runOn.pop();
                        }
                        break;
                    }
                    if (request.getVisitors().containsAdapters((Class)runOn.peek(), runner.getRunOn())) {
                        ++this.satisfiedConstraint;
                        currentState.setSatisfied();
                        for (ManagedVisitor managedVisitor : request.getVisitors().getAdapter((Class)runOn.peek(), runner.getRunOn())) {
                            runOn.push(managedVisitor.getRunOnAfter());
                            ++this.adapterCount;
                        }
                        break;
                    }
                    runOn.pop();
                }
                if (runOn.isEmpty()) {
                    ++this.unsatisfiedConstraint;
                    currentState.setUnsatisfied();
                    runOn.push(rootRunOn);
                }
                if (this.tracer.isTracing()) {
                    TagOrMarkerOrComponentSet needed = runner.getNeededTags(features);
                    for (Class tag : runner.getMissingTags(features, currentTags)) {
                        this.tracer.getStatistic(this.getNeedSatisfaction(tag)).addFalse();
                        needed.remove(tag);
                    }
                    for (Class tag : needed) {
                        this.tracer.getStatistic(this.getNeedSatisfaction(tag)).addTrue();
                    }
                    TagOrMarkerOrComponentSet tagOrMarkerOrComponentSet = runner.getUnsupportedTags(features);
                    for (Class tag : runner.getForbiddenTags(features, currentTags)) {
                        this.tracer.getStatistic(this.getNoSatisfaction(tag)).addFalse();
                        tagOrMarkerOrComponentSet.remove(tag);
                    }
                    for (Class tag : tagOrMarkerOrComponentSet) {
                        this.tracer.getStatistic(this.getNoSatisfaction(tag)).addTrue();
                    }
                }
                if (runner.isCompatible(features, currentTags)) {
                    assert (runner.getUnsatisfiedConstraintCount(features, currentTags) == 0);
                    this.satisfiedConstraint += (long)runner.getConstraintCount(features);
                    currentState.setSatisfied();
                } else {
                    assert (runner.getUnsatisfiedConstraintCount(features, currentTags) > 0);
                    this.unsatisfiedConstraint += (long)runner.getUnsatisfiedConstraintCount(features, currentTags);
                    currentState.setUnsatisfied();
                }
                if (this.tracer.isTracing()) {
                    this.tracer.getStatistic(this.getRunnerSatisfaction(runner)).add(currentState.isSatisfied());
                }
                if (currentState.isSatisfied()) {
                    ++this.satisfiedRunner;
                }
                this.update(currentState, idx);
                currentTags = runner.getAfterTags(currentTags);
                this.beforeTags.add(currentTags);
            }
        }
    }

    protected void update(@Nonnull State currentState, int index) {
    }

    @Nonnull
    private StatisticId<Percent> getNeedSatisfaction(@Nonnull Class<? extends TagOrMarkerOrComponent> tag) {
        if (needSatisfaction == null) {
            needSatisfaction = new HashMap<Class<? extends TagOrMarkerOrComponent>, StatisticId<Percent>>();
        }
        assert (needSatisfaction != null);
        StatisticId<Percent> id = needSatisfaction.get(tag);
        if (id == null) {
            String name = Items.getName(tag);
            id = new StatisticId<TagPercent>("sched.tag." + name + ".need.satisfied", "Number of time 'need " + name + "' is satisfied", TagPercentImpl.class, TagPercent.class);
            assert (needSatisfaction != null);
            needSatisfaction.put(tag, id);
        }
        return id;
    }

    @Nonnull
    private StatisticId<Percent> getNoSatisfaction(@Nonnull Class<? extends TagOrMarkerOrComponent> tag) {
        if (noSatisfaction == null) {
            noSatisfaction = new HashMap<Class<? extends TagOrMarkerOrComponent>, StatisticId<Percent>>();
        }
        assert (noSatisfaction != null);
        StatisticId<Percent> id = noSatisfaction.get(tag);
        if (id == null) {
            String name = Items.getName(tag);
            id = new StatisticId<TagPercent>("sched.tag." + name + ".no.satisfied", "Number of time 'no " + name + "' is satisfied", TagPercentImpl.class, TagPercent.class);
            assert (noSatisfaction != null);
            noSatisfaction.put(tag, id);
        }
        return id;
    }

    @Nonnull
    private StatisticId<Percent> getRunnerSatisfaction(@Nonnull ManagedRunnable runner) {
        if (runnerSatisfaction == null) {
            runnerSatisfaction = new HashMap<ManagedRunnable, StatisticId<Percent>>();
        }
        assert (runnerSatisfaction != null);
        StatisticId<Percent> id = runnerSatisfaction.get(runner);
        if (id == null) {
            String name = runner.getName();
            id = new StatisticId<RunnerPercent>("sched.runner." + name + ".constraint.satisfied", "Number of time '" + name + "' has all their constraints satisfied", RunnerPercentImpl.class, RunnerPercent.class);
            runnerSatisfaction.put(runner, id);
        }
        return id;
    }

    public double getFitness() {
        if (this.satisfiedConstraint > 0L || this.unsatisfiedConstraint > 0L) {
            if (this.unsatisfiedConstraint > 0L) {
                return (double)this.satisfiedConstraint / (double)(this.satisfiedConstraint + this.unsatisfiedConstraint + (long)this.unsatisfiedProduction);
            }
            return 1.0 + 1.0 / (double)(10 * this.adapterCount + this.plan.size());
        }
        return 1.0;
    }

    @Override
    public boolean isValid() {
        return this.unsatisfiedConstraint == 0L && this.unsatisfiedProduction == 0;
    }

    @Nonnegative
    public int getUnsatisfiedRunnerCount() {
        return this.plan.size() - this.satisfiedRunner;
    }

    @Nonnegative
    public int getSatisfiedRunnerCount() {
        return this.satisfiedRunner;
    }

    @Nonnegative
    long getSatisfiedConstraintCount() {
        return this.satisfiedConstraint;
    }

    @Nonnegative
    public long getUnsatisfiedConstraintCount() {
        return this.unsatisfiedConstraint;
    }

    @Nonnegative
    public int getUnsatisfiedProductionCount() {
        return this.unsatisfiedProduction;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getBeforeTags(@Nonnegative int index) {
        return this.beforeTags.get(index);
    }

    @Nonnull
    Class<? extends Component> getRunOnBefore(@Nonnegative int index) {
        if (index == 0) {
            return this.rootRunOn;
        }
        return this.plan.get(index - 1).getRunOn();
    }

    @Nonnegative
    int getAdapterCount() {
        return this.adapterCount;
    }

    @Override
    @Nonnull
    public String getDescription() {
        try {
            return this.getPlanBuilder().getDescription();
        }
        catch (IllegalRequestException e) {
            return "Unknown";
        }
    }

    @Override
    @Nonnull
    public String getDetailedDescription() {
        try {
            return this.getPlanBuilder().getDetailedDescription();
        }
        catch (IllegalRequestException e) {
            return "Unknown";
        }
    }

    @Override
    @Nonnull
    public PlanBuilder<T> getPlanBuilder() throws IllegalRequestException {
        try (Event event = this.tracer.open(SchedEventType.PLANBUILDER);){
            PlanBuilder pb;
            Stack<Class<T>> runOn = new Stack<Class<T>>();
            Stack<SubPlanBuilder> adapters = new Stack<SubPlanBuilder>();
            runOn.push(this.rootRunOn);
            adapters.push(this.request.getPlanBuilder(this.rootRunOn));
            for (ManagedRunnable runner : this.plan) {
                while (!runOn.isEmpty()) {
                    if (runOn.contains(runner.getRunOn())) {
                        while (runOn.peek() != runner.getRunOn()) {
                            runOn.pop();
                            adapters.pop();
                        }
                        break;
                    }
                    if (this.request.getVisitors().containsAdapters((Class)runOn.peek(), runner.getRunOn())) {
                        for (ManagedVisitor visitor : this.request.getVisitors().getAdapter((Class)runOn.peek(), runner.getRunOn())) {
                            runOn.push(visitor.getRunOnAfter());
                            adapters.push(((SubPlanBuilder)adapters.peek()).appendSubPlan(visitor));
                        }
                        break;
                    }
                    runOn.pop();
                    adapters.pop();
                }
                ((SubPlanBuilder)adapters.peek()).append(runner);
            }
            while (runOn.peek() != this.rootRunOn) {
                adapters.pop();
                runOn.pop();
            }
            PlanBuilder planBuilder = pb = (PlanBuilder)adapters.pop();
            return planBuilder;
        }
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("fitness: ");
        sb.append(this.getFitness());
        sb.append(", runners: ");
        sb.append(this.plan.size());
        sb.append(", adapters: ");
        sb.append(this.getAdapterCount());
        sb.append(", constraints: ");
        sb.append(this.satisfiedConstraint + this.unsatisfiedConstraint);
        sb.append(", satisfied: ");
        sb.append(this.satisfiedConstraint);
        sb.append(" (");
        sb.append(FitnessPlanCandidate.toPercent(this.satisfiedConstraint, this.satisfiedConstraint + this.unsatisfiedConstraint));
        sb.append(") ");
        sb.append(", unsatisfied: ");
        sb.append(this.unsatisfiedConstraint);
        sb.append(" (");
        sb.append(FitnessPlanCandidate.toPercent(this.unsatisfiedConstraint, this.satisfiedConstraint + this.unsatisfiedConstraint));
        sb.append(")");
        return sb.toString();
    }

    @Nonnull
    private static String toPercent(long val, long total) {
        if (total != 0L) {
            return formatter.formatValue(Double.valueOf((float)val / (float)total));
        }
        return formatter.formatValue(Double.NaN);
    }

    @Override
    @Nonnull
    public Iterator<ManagedRunnable> iterator() {
        return this.plan.iterator();
    }

    @Nonnull
    public List<ManagedRunnable> getRunnables() {
        return this.plan;
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.plan.size();
    }

    static {
        formatter = new PercentFormatter();
    }

    protected static class State {
        @Nonnull
        private ThreeState state = ThreeState.UNDEFINED;

        protected State() {
        }

        void setSatisfied() {
            if (this.state != ThreeState.UNSATISFIED) {
                this.state = ThreeState.SATISFIED;
            }
        }

        void setUnsatisfied() {
            this.state = ThreeState.UNSATISFIED;
        }

        boolean isSatisfied() {
            assert (this.state != ThreeState.UNDEFINED);
            return this.state == ThreeState.SATISFIED;
        }

        static enum ThreeState {
            SATISFIED,
            UNSATISFIED,
            UNDEFINED;

        }
    }
}

